{{-- Floating Compare Bar --}}
<div x-data="{ show: @entangle('isExpanded') }"
     x-show="$wire.count > 0"
     x-cloak
     class="fixed bottom-0 left-0 right-0 z-50 transition-transform duration-300"
     :class="show ? 'translate-y-0' : 'translate-y-[calc(100%-3.5rem)]'">

    {{-- Bar Container --}}
    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        <div class="rounded-t-2xl shadow-2xl overflow-hidden" style="background: var(--card-bg); border: 1px solid var(--border); border-bottom: none;">

            {{-- Header (always visible) --}}
            <button @click="show = !show"
                    class="w-full flex items-center justify-between px-6 py-3 cursor-pointer transition-smooth hover:bg-opacity-50"
                    style="background: var(--bg-color);">
                <div class="flex items-center gap-3">
                    <i class="ph ph-scales text-xl" style="color: var(--primary);"></i>
                    <span class="font-semibold" style="color: var(--text-primary);">
                        @lang('Compare Products')
                    </span>
                    <span class="px-2 py-0.5 text-xs font-bold rounded-full text-white" style="background: var(--primary);">
                        {{ $count }}/{{ $maxProducts }}
                    </span>
                </div>
                <i class="ph transition-transform duration-300" :class="show ? 'ph-caret-down' : 'ph-caret-up'" style="color: var(--text-muted);"></i>
            </button>

            {{-- Expanded Content --}}
            <div x-show="show" x-collapse class="px-6 pb-6">
                {{-- Products Grid --}}
                <div class="grid grid-cols-2 sm:grid-cols-4 gap-4 mb-4">
                    @foreach($products as $product)
                        <div class="relative p-4 rounded-xl" style="background: var(--bg-color);">
                            {{-- Remove Button --}}
                            <button wire:click="removeProduct({{ $product['id'] }})"
                                    class="absolute -top-2 -right-2 w-6 h-6 flex items-center justify-center rounded-full text-white text-xs transition-smooth hover:scale-110"
                                    style="background: var(--danger);">
                                <i class="ph ph-x"></i>
                            </button>

                            <h4 class="font-semibold text-sm truncate" style="color: var(--text-primary);">
                                {{ $product['name'] }}
                            </h4>
                            <p class="text-xs mt-1" style="color: var(--text-muted);">
                                @lang('From') {{ gs('cur_sym') }}{{ number_format($product['starting_price'], 2) }}
                            </p>
                        </div>
                    @endforeach

                    {{-- Empty Slots --}}
                    @for($i = count($products); $i < $maxProducts; $i++)
                        <div class="p-4 rounded-xl border-2 border-dashed flex items-center justify-center" style="border-color: var(--border);">
                            <span class="text-xs" style="color: var(--text-muted);">@lang('Add product')</span>
                        </div>
                    @endfor
                </div>

                {{-- Actions --}}
                <div class="flex items-center justify-between gap-4">
                    <button wire:click="clearAll"
                            class="px-4 py-2 text-sm font-medium rounded-lg transition-smooth"
                            style="color: var(--text-secondary); background: var(--bg-color);">
                        <i class="ph ph-trash mr-1"></i> @lang('Clear All')
                    </button>

                    <button wire:click="goToCompare"
                            class="px-6 py-2.5 text-sm font-semibold rounded-xl text-white transition-smooth hover:opacity-90 disabled:opacity-50"
                            style="background: var(--primary);"
                            @if($count < 2) disabled @endif>
                        <i class="ph ph-scales mr-1"></i> @lang('Compare Now')
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

