<div class="min-h-screen py-12" style="background: var(--bg-color);">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Header --}}
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-8">
            <div>
                <h1 class="text-3xl font-bold" style="color: var(--text-primary);">@lang('Compare Products')</h1>
                <p class="mt-1" style="color: var(--text-secondary);">
                    @lang('Compare features and pricing side by side')
                </p>
            </div>

            @if(count($comparisonData['products'] ?? []) > 0)
                <div class="flex items-center gap-3">
                    {{-- Share Button --}}
                    <button wire:click="showShare"
                            class="inline-flex items-center gap-2 px-4 py-2 text-sm font-medium rounded-lg transition-smooth"
                            style="background: var(--card-bg); color: var(--text-secondary); border: 1px solid var(--border);">
                        <i class="ph ph-share-network"></i>
                        @lang('Share')
                    </button>

                    {{-- Print Button --}}
                    <a href="{{ route('store.compare.print', ['products' => $encodedProducts]) }}" target="_blank"
                       class="inline-flex items-center gap-2 px-4 py-2 text-sm font-medium rounded-lg transition-smooth"
                       style="background: var(--card-bg); color: var(--text-secondary); border: 1px solid var(--border);">
                        <i class="ph ph-printer"></i>
                        @lang('Print')
                    </a>

                    {{-- Export CSV --}}
                    <button wire:click="exportCsv"
                            class="inline-flex items-center gap-2 px-4 py-2 text-sm font-medium rounded-lg transition-smooth"
                            style="background: var(--card-bg); color: var(--text-secondary); border: 1px solid var(--border);">
                        <i class="ph ph-download-simple"></i>
                        @lang('Export')
                    </button>

                    {{-- Clear All --}}
                    <button wire:click="clearAll"
                            class="inline-flex items-center gap-2 px-4 py-2 text-sm font-medium rounded-lg transition-smooth"
                            style="background: color-mix(in srgb, var(--danger) 10%, transparent); color: var(--danger);">
                        <i class="ph ph-trash"></i>
                        @lang('Clear')
                    </button>
                </div>
            @endif
        </div>

        {{-- Cycle Switcher --}}
        @if(count($comparisonData['products'] ?? []) > 0)
            <div class="mb-8 flex justify-center">
                <x-theme.pricing.cycle-switcher
                    :cycles="collect($comparisonData['products'])->first()['pricing']['cycles'] ?? []"
                    :selected="$selectedCycle"
                    style="pills"
                    event-name="cycle-changed"
                    @cycle-changed="$wire.changeCycle($event.detail.cycle)"
                />
            </div>
        @endif

        {{-- Comparison Table --}}
        <div class="rounded-2xl overflow-hidden" style="background: var(--card-bg); border: 1px solid var(--border);">
            <x-theme.compare.table
                :data="$comparisonData"
                :selected-cycle="$selectedCycle"
                highlight-differences
                show-pricing
            />
        </div>

        {{-- Empty State --}}
        @if(count($comparisonData['products'] ?? []) === 0)
            <div class="text-center py-16">
                <a href="/"
                   class="inline-flex items-center gap-2 px-6 py-3 font-semibold rounded-xl text-white transition-smooth hover:opacity-90"
                   style="background: var(--primary);">
                    <i class="ph ph-storefront"></i>
                    @lang('Browse Products')
                </a>
            </div>
        @endif
    </div>

    {{-- Share Modal --}}
    @if($showShareModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center p-4" style="background: rgba(0,0,0,0.5);">
            <div class="w-full max-w-md rounded-2xl p-6" style="background: var(--card-bg);">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold" style="color: var(--text-primary);">@lang('Share Comparison')</h3>
                    <button wire:click="hideShare" class="p-2 rounded-lg transition-smooth" style="color: var(--text-muted);">
                        <i class="ph ph-x text-xl"></i>
                    </button>
                </div>

                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium mb-2" style="color: var(--text-secondary);">@lang('Shareable Link')</label>
                        <div class="flex gap-2">
                            <input type="text" value="{{ $shareableUrl }}" readonly
                                   class="flex-1 px-4 py-2 text-sm rounded-lg"
                                   style="background: var(--bg-color); border: 1px solid var(--border); color: var(--text-primary);"
                                   id="share-url">
                            <button onclick="navigator.clipboard.writeText(document.getElementById('share-url').value); this.innerHTML = '<i class=\'ph ph-check\'></i>'"
                                    class="px-4 py-2 rounded-lg text-white transition-smooth"
                                    style="background: var(--primary);">
                                <i class="ph ph-copy"></i>
                            </button>
                        </div>
                    </div>

                    <div class="flex justify-center gap-4 pt-4" style="border-top: 1px solid var(--border);">
                        <a href="https://twitter.com/intent/tweet?url={{ urlencode($shareableUrl) }}&text={{ urlencode(__('Check out this product comparison!')) }}"
                           target="_blank" class="p-3 rounded-full transition-smooth" style="background: var(--bg-color);">
                            <i class="ph ph-twitter-logo text-xl" style="color: #1DA1F2;"></i>
                        </a>
                        <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode($shareableUrl) }}"
                           target="_blank" class="p-3 rounded-full transition-smooth" style="background: var(--bg-color);">
                            <i class="ph ph-facebook-logo text-xl" style="color: #4267B2;"></i>
                        </a>
                        <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode($shareableUrl) }}"
                           target="_blank" class="p-3 rounded-full transition-smooth" style="background: var(--bg-color);">
                            <i class="ph ph-linkedin-logo text-xl" style="color: #0077B5;"></i>
                        </a>
                        <a href="mailto:?subject={{ urlencode(__('Product Comparison')) }}&body={{ urlencode($shareableUrl) }}"
                           class="p-3 rounded-full transition-smooth" style="background: var(--bg-color);">
                            <i class="ph ph-envelope text-xl" style="color: var(--text-secondary);"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

