<div class="domain-options">
    {{-- Option Tabs --}}
    <div class="flex flex-col sm:flex-row gap-3 mb-6">
        <button wire:click="selectOption('new')"
                class="flex-1 p-4 rounded-xl text-left transition-smooth {{ $option === 'new' ? 'ring-2' : '' }}"
                style="background: var(--card-bg); border: 1px solid var(--border); {{ $option === 'new' ? 'ring-color: var(--primary);' : '' }}">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-lg flex items-center justify-center"
                     style="background: {{ $option === 'new' ? 'var(--primary)' : 'var(--bg-color)' }}; color: {{ $option === 'new' ? 'white' : 'var(--text-secondary)' }};">
                    <i class="ph ph-globe text-xl"></i>
                </div>
                <div>
                    <h4 class="font-semibold" style="color: var(--text-primary);">@lang('Register New Domain')</h4>
                    <p class="text-sm" style="color: var(--text-muted);">@lang('Search for your perfect domain')</p>
                </div>
            </div>
        </button>

        <button wire:click="selectOption('transfer')"
                class="flex-1 p-4 rounded-xl text-left transition-smooth {{ $option === 'transfer' ? 'ring-2' : '' }}"
                style="background: var(--card-bg); border: 1px solid var(--border); {{ $option === 'transfer' ? 'ring-color: var(--primary);' : '' }}">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-lg flex items-center justify-center"
                     style="background: {{ $option === 'transfer' ? 'var(--primary)' : 'var(--bg-color)' }}; color: {{ $option === 'transfer' ? 'white' : 'var(--text-secondary)' }};">
                    <i class="ph ph-arrows-left-right text-xl"></i>
                </div>
                <div>
                    <h4 class="font-semibold" style="color: var(--text-primary);">@lang('Transfer Domain')</h4>
                    <p class="text-sm" style="color: var(--text-muted);">@lang('Move your existing domain to us')</p>
                </div>
            </div>
        </button>

        <button wire:click="selectOption('own')"
                class="flex-1 p-4 rounded-xl text-left transition-smooth {{ $option === 'own' ? 'ring-2' : '' }}"
                style="background: var(--card-bg); border: 1px solid var(--border); {{ $option === 'own' ? 'ring-color: var(--primary);' : '' }}">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-lg flex items-center justify-center"
                     style="background: {{ $option === 'own' ? 'var(--primary)' : 'var(--bg-color)' }}; color: {{ $option === 'own' ? 'white' : 'var(--text-secondary)' }};">
                    <i class="ph ph-link text-xl"></i>
                </div>
                <div>
                    <h4 class="font-semibold" style="color: var(--text-primary);">@lang('I Have a Domain')</h4>
                    <p class="text-sm" style="color: var(--text-muted);">@lang("I'll update my DNS records")</p>
                </div>
            </div>
        </button>
    </div>

    {{-- New Domain Search --}}
    @if($option === 'new')
        <div class="p-6 rounded-xl" style="background: var(--card-bg); border: 1px solid var(--border);">
            @if(!$selectedDomain)
                {{-- Search Form --}}
                <form wire:submit="searchDomains" class="mb-6">
                    <div class="flex gap-3">
                        <input type="text" wire:model="searchQuery"
                               placeholder="{{ __('Enter your domain name...') }}"
                               class="flex-1 px-4 py-3 rounded-xl bg-transparent outline-none"
                               style="border: 1px solid var(--border); color: var(--text-primary);">
                        <button type="submit"
                                class="px-6 py-3 font-semibold rounded-xl text-white transition-smooth hover:opacity-90"
                                style="background: var(--primary);"
                                wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="searchDomains">
                                <i class="ph ph-magnifying-glass"></i>
                            </span>
                            <span wire:loading wire:target="searchDomains">
                                <i class="ph ph-spinner animate-spin"></i>
                            </span>
                        </button>
                    </div>
                    @error('searchQuery')
                        <p class="mt-2 text-sm" style="color: var(--danger);">{{ $message }}</p>
                    @enderror
                </form>

                {{-- Popular TLDs --}}
                @if(!$searched && count($popularTlds) > 0)
                    <div class="flex flex-wrap gap-2 mb-4">
                        <span class="text-sm" style="color: var(--text-muted);">@lang('Popular'):</span>
                        @foreach($popularTlds as $tld)
                            <span class="px-3 py-1 text-sm rounded-lg" style="background: var(--bg-color); color: var(--text-secondary);">
                                .{{ $tld['extension'] }}
                                <span style="color: var(--primary);">{{ gs('cur_sym') }}{{ number_format($tld['price'], 2) }}</span>
                            </span>
                        @endforeach
                    </div>
                @endif

                {{-- Search Results --}}
                @if($searched && count($searchResults) > 0)
                    <div class="space-y-3">
                        @foreach($searchResults as $index => $result)
                            <div class="flex items-center justify-between p-4 rounded-xl transition-smooth"
                                 style="background: var(--bg-color);">
                                <div class="flex items-center gap-3">
                                    @if($result['available'])
                                        <i class="ph ph-check-circle text-xl" style="color: var(--success);"></i>
                                    @elseif($result['available'] === false)
                                        <i class="ph ph-x-circle text-xl" style="color: var(--danger);"></i>
                                    @else
                                        <i class="ph ph-question text-xl" style="color: var(--text-muted);"></i>
                                    @endif
                                    <span class="font-medium" style="color: var(--text-primary);">{{ $result['domain'] }}</span>
                                </div>
                                <div class="flex items-center gap-4">
                                    <span class="font-bold" style="color: var(--primary);">
                                        {{ gs('cur_sym') }}{{ number_format($result['register_price'], 2) }}/yr
                                    </span>
                                    @if($result['available'])
                                        <button wire:click="selectDomain({{ $index }})"
                                                class="px-4 py-2 text-sm font-semibold rounded-lg text-white transition-smooth hover:opacity-90"
                                                style="background: var(--primary);">
                                            @lang('Select')
                                        </button>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            @else
                {{-- Selected Domain Display --}}
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center gap-3">
                        <i class="ph ph-check-circle text-2xl" style="color: var(--success);"></i>
                        <div>
                            <h4 class="text-lg font-bold" style="color: var(--text-primary);">{{ $selectedDomain['domain'] }}</h4>
                            <p class="text-sm" style="color: var(--success);">@lang('Domain selected')</p>
                        </div>
                    </div>
                    <button wire:click="clearSelection" class="text-sm" style="color: var(--primary);">
                        @lang('Change')
                    </button>
                </div>

                {{-- Years Selector --}}
                @include('livewire.store.partials.domain-options-config')
            @endif
        </div>
    @endif

    {{-- Transfer Domain --}}
    @if($option === 'transfer')
        @include('livewire.store.partials.domain-transfer-form')
    @endif

    {{-- Own Domain --}}
    @if($option === 'own')
        @include('livewire.store.partials.domain-own-form')
    @endif
</div>

