<div class="domain-search-widget {{ $mode === 'inline' ? 'domain-search-inline' : '' }}">
    {{-- Search Form --}}
    <form wire:submit="search" class="relative group">
        @if($mode === 'inline')
            <div class="flex flex-col sm:flex-row gap-3 p-2 sm:p-3 rounded-2xl bg-white/5 border border-white/10 backdrop-blur-lg transition-all duration-300 focus-within:border-primary-500/50">
                <div class="relative flex-1">
                    <div class="absolute inset-y-0 left-0 pl-5 flex items-center pointer-events-none">
                        <i class="ph ph-globe text-2xl text-slate-400 group-focus-within:text-primary-400 transition-colors" wire:loading.class="ph-spinner animate-spin" wire:target="search"></i>
                    </div>
                    <input type="text" 
                           wire:model.live.debounce.300ms="query" 
                           placeholder="@lang('Search for a domain name...')"
                           class="w-full pl-14 pr-4 h-14 bg-transparent border-none rounded-xl text-white placeholder-slate-500 focus:outline-none focus:ring-0 text-lg font-medium">
                </div>
                <button type="submit" 
                        wire:loading.attr="disabled"
                        class="h-14 px-10 rounded-xl bg-primary-600 hover:bg-primary-500 text-white font-bold text-lg shadow-lg shadow-primary-500/30 transition-all duration-300 disabled:opacity-50 active:scale-[0.98]">
                    <span wire:loading.remove wire:target="search">@lang('Search')</span>
                    <span wire:loading wire:target="search">@lang('Checking')...</span>
                </button>
            </div>
        @else
            <div class="flex flex-col sm:flex-row gap-3">
                {{-- Existing full/compact mode logic --}}
                <div class="flex-1 relative">
                    <div class="flex rounded-xl overflow-hidden" style="background: var(--card-bg); border: 1px solid var(--border);">
                        <input type="text"
                               wire:model.live.debounce.300ms="query"
                               placeholder="{{ __('Enter your domain name...') }}"
                               class="flex-1 px-5 py-4 text-lg bg-transparent outline-none"
                               style="color: var(--text-primary);">

                        {{-- TLD Selector --}}
                        @if($mode === 'full')
                            <div class="relative" x-data="{ open: false }">
                                <button type="button" @click="open = !open"
                                        class="h-full px-4 flex items-center gap-2 font-medium transition-smooth"
                                        style="background: var(--bg-color); color: var(--text-secondary);">
                                    <span>{{ $selectedTld ? '.' . $selectedTld : __('All TLDs') }}</span>
                                    <i class="ph ph-caret-down text-sm"></i>
                                </button>

                                <div x-show="open" @click.away="open = false" x-cloak
                                     class="absolute right-0 top-full mt-2 w-48 rounded-xl shadow-xl z-20 py-2"
                                     style="background: var(--card-bg); border: 1px solid var(--border);">
                                    <button type="button" wire:click="selectTld('')" @click="open = false"
                                            class="w-full px-4 py-2 text-left text-sm transition-smooth hover:bg-opacity-50"
                                            style="color: var(--text-secondary);">
                                        @lang('All TLDs')
                                    </button>
                                    @foreach($popularTlds as $tld)
                                        <button type="button" wire:click="selectTld('{{ $tld['extension'] }}')" @click="open = false"
                                                class="w-full px-4 py-2 text-left text-sm flex items-center justify-between transition-smooth hover:bg-opacity-50"
                                                style="color: var(--text-primary);">
                                            <span>.{{ $tld['extension'] }}</span>
                                            <span style="color: var(--text-muted);">{{ gs('cur_sym') }}{{ number_format($tld['price'], 2) }}</span>
                                        </button>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                {{-- Search Button --}}
                <button type="submit"
                        class="px-8 py-4 font-semibold rounded-xl text-white transition-smooth hover:opacity-90 disabled:opacity-50"
                        style="background: var(--primary);"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="search">
                        <i class="ph ph-magnifying-glass mr-2"></i>@lang('Search')
                    </span>
                    <span wire:loading wire:target="search">
                        <i class="ph ph-spinner animate-spin mr-2"></i>@lang('Searching...')
                    </span>
                </button>
            </div>
        @endif
        @error('query')
            <p class="mt-2 text-sm text-red-500">{{ $message }}</p>
        @enderror
    </form>

    {{-- Popular TLDs (full mode only) --}}
    @if($mode === 'full' && !$searched)
        <div class="mt-6 flex flex-wrap items-center gap-3">
            <span class="text-sm" style="color: var(--text-muted);">@lang('Popular'):</span>
            @foreach($popularTlds as $tld)
                <button wire:click="selectTld('{{ $tld['extension'] }}')"
                        class="px-3 py-1.5 text-sm font-medium rounded-lg transition-smooth"
                        style="background: var(--bg-color); color: var(--text-secondary);">
                    .{{ $tld['extension'] }}
                    <span class="ml-1" style="color: var(--primary);">{{ gs('cur_sym') }}{{ number_format($tld['price'], 2) }}</span>
                </button>
            @endforeach
        </div>
    @endif

    {{-- Results --}}
    @if($searched && count($results) > 0)
        <div class="mt-8 space-y-4">
            @foreach($results as $index => $result)
                <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4 p-4 sm:p-6 rounded-2xl bg-white/5 border border-white/10 backdrop-blur-sm transition-all duration-300 {{ $result['available'] ? 'hover:border-primary-500/30' : '' }}">
                    <div class="flex items-center gap-4">
                        {{-- Availability Icon --}}
                        <div class="w-12 h-12 rounded-full flex items-center justify-center {{ $result['available'] ? 'bg-emerald-500/10 text-emerald-400' : 'bg-red-500/10 text-red-400' }}">
                            <i class="ph {{ $result['available'] ? 'ph-check-circle' : 'ph-x-circle' }} text-2xl"></i>
                        </div>

                        <div>
                            <h4 class="font-bold text-lg text-white">{{ $result['domain'] }}</h4>
                            <p class="text-xs uppercase tracking-wider font-black {{ $result['available'] ? 'text-emerald-400' : 'text-red-400' }}">
                                {{ $result['available'] ? __('Available') : __('Unavailable') }}
                            </p>
                        </div>
                    </div>

                    <div class="flex items-center gap-6">
                        {{-- Pricing --}}
                        <div class="text-right">
                            <span class="text-xl font-black text-white block">{{ $result['formatted_price'] }}</span>
                            <span class="text-[10px] text-slate-500 uppercase font-bold">@lang('per year')</span>
                        </div>

                        {{-- Action Button --}}
                        @if($result['available'])
                            <button wire:click="addToCart({{ $index }})"
                                    class="inline-flex items-center gap-2 px-6 py-3 bg-primary-600 hover:bg-primary-500 text-white rounded-xl font-bold text-sm transition-all shadow-lg shadow-primary-500/20 active:scale-[0.98]">
                                <i class="ph ph-shopping-cart text-lg"></i>
                                @lang('Add')
                            </button>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    @endif

    {{-- Suggestions --}}
    @if(count($suggestions) > 0)
        <div class="mt-6 p-6 rounded-2xl bg-white/[0.02] border border-white/5">
            <p class="text-xs font-black uppercase tracking-widest text-slate-500 mb-4">@lang('Suggested Alternatives')</p>
            <div class="flex flex-wrap gap-2">
                @foreach($suggestions as $suggestion)
                    <button wire:click="$set('query', '{{ $suggestion }}'); search()"
                            class="px-4 py-2 text-sm rounded-xl bg-white/5 border border-white/10 text-white hover:bg-white/10 hover:border-primary-500/30 transition-all active:scale-[0.98]">
                        {{ $suggestion }}
                    </button>
                @endforeach
            </div>
        </div>
    @endif
</div>

