{{-- Registration Period --}}
<div class="mb-6">
    <label class="block text-sm font-medium mb-3" style="color: var(--text-secondary);">
        @lang('Registration Period')
    </label>
    <div class="flex gap-2">
        @for($y = 1; $y <= 5; $y++)
            <button type="button"
                    wire:click="updateYears({{ $y }})"
                    class="flex-1 px-4 py-3 text-center font-medium rounded-lg transition-smooth {{ $years === $y ? 'ring-2' : '' }}"
                    style="{{ $years === $y
                        ? 'background: var(--primary); color: white; ring-color: var(--primary);'
                        : 'background: var(--bg-color); color: var(--text-secondary);' }}">
                {{ $y }} {{ trans_choice('Year|Years', $y) }}
            </button>
        @endfor
    </div>
</div>

{{-- ID Protection --}}
@if($selectedDomain['supports_id_protection'] ?? false)
    <div class="p-4 rounded-xl mb-6" style="background: var(--bg-color);">
        <label class="flex items-center justify-between cursor-pointer">
            <div class="flex items-center gap-3">
                <i class="ph ph-shield-check text-xl" style="color: var(--primary);"></i>
                <div>
                    <span class="font-medium" style="color: var(--text-primary);">@lang('ID Protection')</span>
                    <p class="text-sm" style="color: var(--text-muted);">@lang('Hide your personal info from WHOIS')</p>
                </div>
            </div>
            <div class="flex items-center gap-3">
                <span class="font-semibold" style="color: var(--primary);">
                    +{{ gs('cur_sym') }}{{ number_format($selectedDomain['id_protection_price'] ?? 0, 2) }}/yr
                </span>
                <button type="button"
                        wire:click="toggleIdProtection"
                        class="w-12 h-6 rounded-full transition-smooth relative"
                        style="background: {{ $idProtection ? 'var(--primary)' : 'var(--border)' }};">
                    <span class="absolute top-0.5 w-5 h-5 rounded-full bg-white shadow transition-transform {{ $idProtection ? 'translate-x-6' : 'translate-x-0.5' }}"></span>
                </button>
            </div>
        </label>
    </div>
@endif

{{-- Price Summary --}}
<div class="p-4 rounded-xl" style="background: var(--bg-color);">
    <div class="flex items-center justify-between mb-2">
        <span style="color: var(--text-secondary);">@lang('Domain Registration')</span>
        <span style="color: var(--text-primary);">
            {{ gs('cur_sym') }}{{ number_format(($selectedDomain['register_price'] ?? 0) * $years, 2) }}
        </span>
    </div>
    @if($idProtection && ($selectedDomain['supports_id_protection'] ?? false))
        <div class="flex items-center justify-between mb-2">
            <span style="color: var(--text-secondary);">@lang('ID Protection')</span>
            <span style="color: var(--text-primary);">
                {{ gs('cur_sym') }}{{ number_format(($selectedDomain['id_protection_price'] ?? 0) * $years, 2) }}
            </span>
        </div>
    @endif
    <div class="flex items-center justify-between pt-3 mt-3 border-t" style="border-color: var(--border);">
        <span class="font-semibold" style="color: var(--text-primary);">@lang('Domain Total')</span>
        @php
            $domainTotal = (($selectedDomain['register_price'] ?? 0) * $years)
                + ($idProtection ? (($selectedDomain['id_protection_price'] ?? 0) * $years) : 0);
        @endphp
        <span class="text-lg font-bold" style="color: var(--primary);">
            {{ gs('cur_sym') }}{{ number_format($domainTotal, 2) }}
        </span>
    </div>
</div>

