<div class="p-6 rounded-xl" style="background: var(--card-bg); border: 1px solid var(--border);">
    <div class="flex items-center gap-3 mb-6">
        <div class="w-12 h-12 rounded-xl flex items-center justify-center" style="background: var(--bg-color);">
            <i class="ph ph-link text-2xl" style="color: var(--primary);"></i>
        </div>
        <div>
            <h4 class="font-semibold" style="color: var(--text-primary);">@lang('Use Your Own Domain')</h4>
            <p class="text-sm" style="color: var(--text-muted);">@lang("You'll need to update your domain's DNS records")</p>
        </div>
    </div>

    <div class="space-y-4">
        {{-- Domain Name --}}
        <div>
            <label class="block text-sm font-medium mb-2" style="color: var(--text-secondary);">
                @lang('Your Domain Name')
            </label>
            <input type="text"
                   wire:model="ownDomain"
                   placeholder="example.com"
                   class="w-full px-4 py-3 rounded-xl bg-transparent outline-none transition-smooth"
                   style="border: 1px solid var(--border); color: var(--text-primary);">
            @error('ownDomain')
                <p class="mt-2 text-sm" style="color: var(--danger);">{{ $message }}</p>
            @enderror
        </div>

        {{-- DNS Instructions --}}
        <div class="p-4 rounded-xl" style="background: var(--bg-color);">
            <h5 class="font-medium mb-3" style="color: var(--text-primary);">@lang('After ordering, you will need to'):</h5>
            <ol class="space-y-3 text-sm" style="color: var(--text-secondary);">
                <li class="flex items-start gap-3">
                    <span class="w-6 h-6 rounded-full flex items-center justify-center text-xs font-bold shrink-0"
                          style="background: var(--primary); color: white;">1</span>
                    <span>@lang('Log in to your domain registrar account')</span>
                </li>
                <li class="flex items-start gap-3">
                    <span class="w-6 h-6 rounded-full flex items-center justify-center text-xs font-bold shrink-0"
                          style="background: var(--primary); color: white;">2</span>
                    <span>@lang('Update your nameservers or DNS records')</span>
                </li>
                <li class="flex items-start gap-3">
                    <span class="w-6 h-6 rounded-full flex items-center justify-center text-xs font-bold shrink-0"
                          style="background: var(--primary); color: white;">3</span>
                    <span>@lang('Wait for DNS propagation (up to 48 hours)')</span>
                </li>
            </ol>
        </div>

        {{-- Nameserver Preview --}}
        <div class="p-4 rounded-xl" style="background: color-mix(in srgb, var(--primary) 10%, transparent);">
            <h5 class="font-medium mb-2" style="color: var(--primary);">@lang('Our Nameservers')</h5>
            <div class="font-mono text-sm space-y-1" style="color: var(--text-primary);">
                <div>ns1.{{ config('app.domain', 'yourdomain.com') }}</div>
                <div>ns2.{{ config('app.domain', 'yourdomain.com') }}</div>
            </div>
            <p class="mt-2 text-xs" style="color: var(--text-muted);">
                @lang('Full DNS information will be provided after order completion')
            </p>
        </div>

        <button type="button"
                wire:click="setOwnDomain"
                class="w-full px-6 py-3 font-semibold rounded-xl text-white transition-smooth hover:opacity-90"
                style="background: var(--primary);">
            @lang('Continue with My Domain')
        </button>
    </div>
</div>

