<div class="p-6 rounded-xl" style="background: var(--card-bg); border: 1px solid var(--border);">
    <div class="flex items-center gap-3 mb-6">
        <div class="w-12 h-12 rounded-xl flex items-center justify-center" style="background: var(--bg-color);">
            <i class="ph ph-arrows-left-right text-2xl" style="color: var(--primary);"></i>
        </div>
        <div>
            <h4 class="font-semibold" style="color: var(--text-primary);">@lang('Transfer Your Domain')</h4>
            <p class="text-sm" style="color: var(--text-muted);">@lang('Move your domain to us and get a free year extension')</p>
        </div>
    </div>

    <div class="space-y-4">
        {{-- Domain Name --}}
        <div>
            <label class="block text-sm font-medium mb-2" style="color: var(--text-secondary);">
                @lang('Domain Name')
            </label>
            <input type="text"
                   wire:model="transferDomain"
                   placeholder="example.com"
                   class="w-full px-4 py-3 rounded-xl bg-transparent outline-none transition-smooth"
                   style="border: 1px solid var(--border); color: var(--text-primary);">
            @error('transferDomain')
                <p class="mt-2 text-sm" style="color: var(--danger);">{{ $message }}</p>
            @enderror
        </div>

        {{-- EPP/Auth Code --}}
        <div>
            <label class="block text-sm font-medium mb-2" style="color: var(--text-secondary);">
                @lang('EPP/Authorization Code')
            </label>
            <input type="text"
                   wire:model="eppCode"
                   placeholder="@lang('Enter the authorization code from your current registrar')"
                   class="w-full px-4 py-3 rounded-xl bg-transparent outline-none transition-smooth"
                   style="border: 1px solid var(--border); color: var(--text-primary);">
            @error('eppCode')
                <p class="mt-2 text-sm" style="color: var(--danger);">{{ $message }}</p>
            @enderror
            <p class="mt-2 text-sm" style="color: var(--text-muted);">
                @lang('You can get this code from your current domain registrar')
            </p>
        </div>

        {{-- Transfer Info --}}
        <div class="p-4 rounded-xl" style="background: var(--bg-color);">
            <h5 class="font-medium mb-2" style="color: var(--text-primary);">@lang('Transfer includes'):</h5>
            <ul class="space-y-2 text-sm" style="color: var(--text-secondary);">
                <li class="flex items-center gap-2">
                    <i class="ph ph-check text-sm" style="color: var(--success);"></i>
                    @lang('Free 1 year domain extension')
                </li>
                <li class="flex items-center gap-2">
                    <i class="ph ph-check text-sm" style="color: var(--success);"></i>
                    @lang('All DNS records preserved')
                </li>
                <li class="flex items-center gap-2">
                    <i class="ph ph-check text-sm" style="color: var(--success);"></i>
                    @lang('Free ID protection (if supported)')
                </li>
            </ul>
        </div>

        <button type="button"
                wire:click="setTransferDomain"
                class="w-full px-6 py-3 font-semibold rounded-xl text-white transition-smooth hover:opacity-90"
                style="background: var(--primary);">
            @lang('Continue with Transfer')
        </button>
    </div>
</div>

