@php
    $user = auth()->user();
    $footer = getFooterConfig();
    $showFooter = $footer['show_footer'];
    $footerText = $footer['footer_text'];
    $showSocialLinks = $footer['show_social_links'];
    $siteName = gs('site_name') ?? 'Salieno';

    $dynamicSocialLinks = socialLinks();
    $useDynamicSocialLinks = $dynamicSocialLinks->isNotEmpty();

    // Use injected menu data [M-03]
    $footerMenuItems = $clientFooterMenu;
    $useDynamicFooterLinks = $footerMenuItems->isNotEmpty();
@endphp

@if($showFooter)
<footer class="border-t px-4 py-6 lg:px-8" style="background-color: var(--card-bg); border-color: var(--border);">
    <div class="mx-auto max-w-5xl">
        <div class="flex flex-col md:flex-row items-center justify-between gap-4">
            {{-- Copyright Text --}}
            <p class="text-sm text-center md:text-left" style="color: var(--text-muted);">
                @if($footerText)
                    {!! $footerText !!}
                @else
                    &copy; {{ date('Y') }} {{ $siteName }}. @lang('All rights reserved').
                @endif
            </p>

            {{-- Social Links --}}
            @if($showSocialLinks)
                @if($useDynamicSocialLinks)
                    {{-- Dynamic Social Links from Database --}}
                    <div class="flex items-center gap-3">
                        @foreach($dynamicSocialLinks as $link)
                            <a href="{{ $link->url }}" target="_blank" rel="noopener noreferrer"
                              class="w-9 h-9 rounded-xl flex items-center justify-center transition-smooth social-link-hover"
                               style="color: var(--text-muted); background-color: var(--primary-light);"
                               title="{{ $link->display_name }}">
                                <i class="{{ $link->display_icon }} text-lg"></i>
                            </a>
                        @endforeach
                    </div>
                @else
                    {{-- Legacy Social Links from General Settings --}}
                    @php
                        $socialKeys = ['facebook', 'twitter', 'instagram', 'linkedin', 'youtube'];
                        $socialSettings = gs($socialKeys);
                        $socialLinks = array_filter($socialSettings);
                    @endphp
                    @if(count($socialLinks) > 0)
                    <div class="flex items-center gap-3">
                        @foreach($socialLinks as $platform => $url)
                            <a href="{{ $url }}" target="_blank" rel="noopener noreferrer"
                              class="w-9 h-9 rounded-xl flex items-center justify-center transition-smooth social-link-hover"
                               style="color: var(--text-muted); background-color: var(--primary-light);"
                               
                               >
                                @switch($platform)
                                    @case('facebook')
                                        <i class="ph ph-facebook-logo text-lg"></i>
                                        @break
                                    @case('twitter')
                                        <i class="ph ph-twitter-logo text-lg"></i>
                                        @break
                                    @case('instagram')
                                        <i class="ph ph-instagram-logo text-lg"></i>
                                        @break
                                    @case('linkedin')
                                        <i class="ph ph-linkedin-logo text-lg"></i>
                                        @break
                                    @case('youtube')
                                        <i class="ph ph-youtube-logo text-lg"></i>
                                        @break
                                @endswitch
                            </a>
                        @endforeach
                    </div>
                    @endif
                @endif
            @endif
        </div>

        {{-- Footer Links --}}
        <div class="mt-4 pt-4 flex flex-wrap items-center justify-center gap-4 text-sm" style="border-top: 1px solid var(--border);">
            @if($useDynamicFooterLinks)
                {{-- Dynamic Footer Links from Database --}}
                @foreach($footerMenuItems as $item)
                    @php $url = $menuService->resolveItemUrl($item); @endphp
                    <a href="{{ $url }}" target="{{ $item->target ?? '_self' }}" class="transition-smooth hover-text-primary" style="color: var(--text-muted);">
                        {{ __($item->label) }}
                    </a>
                @endforeach
            @else
                {{-- Legacy Footer Links --}}
                @if(gs('terms_url'))
                <a href="{{ gs('terms_url') }}" class="transition-smooth hover-text-primary" style="color: var(--text-muted);"
                   >
                    @lang('Terms of Service')
                </a>
                @endif
                @if(gs('privacy_url'))
                <a href="{{ gs('privacy_url') }}" class="transition-smooth hover-text-primary" style="color: var(--text-muted);"
                   >
                    @lang('Privacy Policy')
                </a>
                @endif
                @if(isMenuVisible('support'))
                <a href="{{ route('client.tickets') }}" class="transition-smooth hover-text-primary" style="color: var(--text-muted);"
                   >
                    @lang('Contact Support')
                </a>
                @endif
            @endif
        </div>
    </div>
</footer>
@endif

