{{-- Authorize.net Direct Post Payment Form --}}
<div x-data="{ isSubmitting: false }">
    <form action="{{ $data->url ?? '' }}" method="POST" id="authorizenet-form" @submit="isSubmitting = true">
        @csrf
        <input type="hidden" name="trx" value="{{ $data->track }}">

        <div class="space-y-6">
            {{-- Payment Details Section --}}
            <div>
                <h4 class="text-xs font-semibold uppercase tracking-wider mb-4 flex items-center gap-2" style="color: var(--text-primary); opacity: 0.8;">
                    <i class="ph ph-credit-card"></i>
                    @lang('Payment Details')
                </h4>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Card Number')</label>
                        <div class="relative">
                            <input type="text" name="cardNumber" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="•••• •••• •••• ••••" autocomplete="off" required>
                            <i class="ph ph-credit-card absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Expiry Date')</label>
                            <div class="relative">
                                <input type="text" name="cardExpiry" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="MMYY" autocomplete="off" required>
                                <i class="ph ph-calendar absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('CVV')</label>
                            <div class="relative">
                                <input type="text" name="cardCVC" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="•••" autocomplete="off" required>
                                <i class="ph ph-lock absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Billing Information Section --}}
            <div class="pt-2 border-t border-white/5">
                <h4 class="text-xs font-semibold uppercase tracking-wider mb-4 mt-2 flex items-center gap-2" style="color: var(--text-primary); opacity: 0.8;">
                    <i class="ph ph-identification-card"></i>
                    @lang('Billing Information')
                </h4>
                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('First Name')</label>
                            <div class="relative">
                                <input type="text" name="firstName" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="John" autocomplete="off" required>
                                <i class="ph ph-user absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Last Name')</label>
                            <div class="relative">
                                <input type="text" name="lastName" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="Doe" autocomplete="off" required>
                                <i class="ph ph-user absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Address')</label>
                        <div class="relative">
                            <input type="text" name="address" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="123 Main Street" autocomplete="off" required>
                            <i class="ph ph-house absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('City')</label>
                            <div class="relative">
                                <input type="text" name="city" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="New York" autocomplete="off" required>
                                <i class="ph ph-map-pin absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('State')</label>
                            <div class="relative">
                                <input type="text" name="state" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="NY" autocomplete="off" required>
                                <i class="ph ph-map-trifold absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('ZIP Code')</label>
                            <div class="relative">
                                <input type="text" name="zip" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="10001" autocomplete="off" required>
                                <i class="ph ph-hash absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Country')</label>
                            <div class="relative">
                                <input type="text" name="country" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="USA" autocomplete="off" required>
                                <i class="ph ph-globe absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <button type="submit" class="btn-primary w-full py-3 px-6 text-sm font-medium rounded-xl mt-6 flex items-center justify-center gap-2" :disabled="isSubmitting">
            <template x-if="!isSubmitting">
                <span class="flex items-center gap-2">
                    <i class="ph ph-lock-simple"></i>
                    @lang('Pay Securely')
                </span>
            </template>
            <template x-if="isSubmitting">
                <span class="flex items-center gap-2">
                    <i class="ph ph-spinner animate-spin"></i>
                    @lang('Processing...')
                </span>
            </template>
        </button>
    </form>

    <div class="mt-4 flex items-center justify-center gap-2 text-xs" style="color: var(--text-muted);">
        <i class="ph ph-shield-check"></i>
        <span>@lang('Secured by Authorize.net')</span>
    </div>
</div>

