{{-- BTCPay Checkout Redirect --}}
@php
    $checkoutLink = $data->invoice['checkoutLink'] ?? '#';
@endphp

<div class="text-center py-10">
    <div class="mb-6">
        <div class="animate-spin w-12 h-12 border-4 rounded-full mx-auto mb-4" style="border-color: var(--primary); border-top-color: transparent;"></div>
        <p style="color: var(--text-secondary);">@lang('Redirecting to BTCPay Checkout...')</p>
    </div>

    <div class="rounded-xl p-4 mb-6 mx-auto max-w-sm" style="background: var(--primary-light);">
        <div class="flex justify-between items-center">
            <span class="text-sm" style="color: var(--text-secondary);">@lang('Amount')</span>
            <span class="font-semibold" style="color: var(--text-primary);">{{ showAmount($deposit->final_amount, currencyFormat: false) }} {{ $deposit->method_currency }}</span>
        </div>
    </div>

    <div class="mt-4 flex items-center justify-center gap-2 text-xs" style="color: var(--text-muted);">
        <i class="ph ph-shield-check"></i>
        <span>@lang('Secured by BTCPay Server')</span>
    </div>
</div>

@push('scripts')
<script nonce="{{ csp_nonce() }}">
    "use strict";
    (function() {
        window.location.href = '{{ $checkoutLink }}';
    })();
</script>
@endpush
