{{-- Checkout.com Payment Form --}}
<div x-data="{ isSubmitting: false }">
    <form action="{{ $data->url ?? '' }}" method="POST" id="checkout-form" @submit="isSubmitting = true">
        @csrf
        <input type="hidden" name="track" value="{{ $data->track }}">
        <input type="hidden" name="method" value="Checkout">

        <div class="space-y-6">
            {{-- Payment Details Section --}}
            <div>
                <h4 class="text-xs font-semibold uppercase tracking-wider mb-4 flex items-center gap-2" style="color: var(--text-primary); opacity: 0.8;">
                    <i class="ph ph-credit-card"></i>
                    @lang('Credit Card Details')
                </h4>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Card Number')</label>
                        <div class="relative">
                            <input type="text" name="cardNumber" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="•••• •••• •••• ••••" autocomplete="off" required>
                            <i class="ph ph-credit-card absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Expiry Date')</label>
                            <div class="relative">
                                <input type="text" name="cardExpiry" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="MM/YY" autocomplete="off" required>
                                <i class="ph ph-calendar absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-1.5" style="color: var(--text-secondary);">@lang('CVV')</label>
                            <div class="relative">
                                <input type="text" name="cardCVC" class="input-dynamic w-full px-4 py-3 pl-11 text-sm rounded-xl transition-smooth" placeholder="•••" autocomplete="off" required>
                                <i class="ph ph-lock absolute left-4 top-1/2 -translate-y-1/2 text-lg" style="color: var(--text-secondary);"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <button type="submit" class="btn-primary w-full py-3 px-6 text-sm font-medium rounded-xl mt-6 flex items-center justify-center gap-2" :disabled="isSubmitting">
            <template x-if="!isSubmitting">
                <span class="flex items-center gap-2">
                    <i class="ph ph-lock-simple"></i>
                    @lang('Pay Securely')
                </span>
            </template>
            <template x-if="isSubmitting">
                <span class="flex items-center gap-2">
                    <i class="ph ph-spinner animate-spin"></i>
                    @lang('Processing...')
                </span>
            </template>
        </button>
    </form>

    <div class="mt-4 flex items-center justify-center gap-2 text-xs" style="color: var(--text-muted);">
        <i class="ph ph-shield-check"></i>
        <span>@lang('Secured by Checkout.com')</span>
    </div>
</div>
