{{-- CoinPayments Crypto Payment View --}}
<div class="text-center">
    <div class="mb-6">
        <h4 class="text-xs font-semibold uppercase tracking-wider mb-4 flex items-center justify-center gap-2" style="color: var(--text-primary); opacity: 0.8;">
            <i class="ph ph-qr-code"></i>
            @lang('Scan to Pay')
        </h4>
        <div class="inline-block p-4 rounded-2xl bg-white dark:bg-white mb-4 border border-subtle" style="box-shadow: 0 4px 20px rgba(0,0,0,0.05);">
            <img src="{{ $data->img }}" alt="@lang('QR Code')" class="w-48 h-48 mx-auto grayscale-0">
        </div>
    </div>

    <div class="space-y-4 max-w-sm mx-auto">
        {{-- Amount Display --}}
        <div class="rounded-xl p-4 text-center transition-smooth" style="background: var(--primary-light);">
            <p class="text-xs mb-1" style="color: var(--text-secondary);">@lang('Total Amount to Send')</p>
            <div class="flex items-center justify-center gap-2">
                <span class="text-xl font-bold font-mono" style="color: var(--text-primary);">{{ $data->amount }} {{ $data->currency }}</span>
                <button type="button" onclick="navigator.clipboard.writeText('{{ $data->amount }}')" class="hover:text-primary transition-colors touch-target" title="@lang('Copy Amount')">
                    <i class="ph ph-copy"></i>
                </button>
            </div>
        </div>

        {{-- Address Display --}}
        <div class="rounded-xl p-4 text-left transition-smooth" style="background: var(--card-bg);">
            <p class="text-xs mb-1.5" style="color: var(--text-secondary);">@lang('Bitcoin Address')</p>
            <div class="flex items-center gap-3">
                <code class="text-xs break-all font-mono py-1 flex-1" style="color: var(--text-primary);">{{ $data->address }}</code>
                <button type="button" onclick="navigator.clipboard.writeText('{{ $data->address }}')" class="hover:text-primary transition-colors touch-target shrink-0 p-2 rounded-lg shadow-sm" style="background: var(--card-bg); border: 1px solid var(--border);" title="@lang('Copy Address')">
                    <i class="ph ph-copy text-lg"></i>
                </button>
            </div>
        </div>
    </div>

    <div class="mt-8 flex flex-col items-center gap-3">
        <div class="flex items-center gap-2 text-sm font-medium animate-pulse" style="color: var(--primary);">
            <i class="ph ph-hourglass-high"></i>
            <span>@lang('Waiting for payment confirmation...')</span>
        </div>
        <p class="text-xs px-6" style="color: var(--text-muted);">
            @lang('Please send the exact amount to the address above. Payment will be confirmed automatically after network confirmation.')
        </p>
    </div>

    <div class="mt-6 pt-6 flex items-center justify-center gap-2 text-xs" style="color: var(--text-muted); border-top: 1px solid var(--border-subtle);">
        <i class="ph ph-shield-check"></i>
        <span>@lang('Secured by CoinPayments')</span>
    </div>
</div>
