{{-- Flutterwave Payment Integration --}}
<div x-data="{ isProcessing: false }">
    <div class="text-center mb-6">
        <div class="inline-flex items-center justify-center w-16 h-16 rounded-2xl mb-4" style="background: var(--primary-light);">
            <i class="ph ph-credit-card text-3xl" style="color: var(--primary);"></i>
        </div>
        <p class="text-sm" style="color: var(--text-secondary);">@lang('Complete your payment securely with Flutterwave')</p>
    </div>

    <div class="rounded-xl p-4 mb-6" style="background: var(--primary-light);">
        <div class="flex justify-between items-center">
            <span class="text-sm" style="color: var(--text-secondary);">@lang('Amount')</span>
            <span class="font-semibold" style="color: var(--text-primary);">{{ $data->amount }} {{ $data->currency }}</span>
        </div>
    </div>

    <button type="button" id="flutterwave-btn" @click="isProcessing = true; payWithRave()" class="btn-primary w-full py-3 px-6 text-sm font-medium rounded-xl flex items-center justify-center gap-2" :disabled="isProcessing">
        <template x-if="!isProcessing">
            <span class="flex items-center gap-2">
                <i class="ph ph-lock-simple"></i>
                @lang('Pay Now')
            </span>
        </template>
        <template x-if="isProcessing">
            <span class="flex items-center gap-2">
                <i class="ph ph-spinner animate-spin"></i>
                @lang('Processing...')
            </span>
        </template>
    </button>

    <div class="mt-4 flex items-center justify-center gap-2 text-xs" style="color: var(--text-muted);">
        <i class="ph ph-shield-check"></i>
        <span>@lang('Secured by Flutterwave')</span>
    </div>
</div>

@push('scripts')
<script src="https://checkout.flutterwave.com/v3.js"></script>
<script nonce="{{ csp_nonce() }}">
    "use strict";

    function payWithRave() {
        FlutterwaveCheckout({
            public_key: "{{ $data->public_key }}",
            tx_ref: "{{ $data->tx_ref }}",
            amount: {{ $data->amount }},
            currency: "{{ $data->currency }}",
            payment_options: "card, account, ussd, qr, mobilemoneyghana",
            redirect_url: "{{ $data->redirect_url }}",
            customer: {
                email: "{{ $data->customer_email }}",
                phone_number: "{{ $data->customer_phone }}",
            },
            customizations: {
                title: "{{ $data->customizations['title'] }}",
                logo: "{{ $data->customizations['logo'] }}",
            },
            onclose: function() {
                document.querySelector('#flutterwave-btn').__x.$data.isProcessing = false;
            }
        });
    }
</script>
@endpush

