{{-- NMI (Network Merchants Inc) Payment Form --}}
<div x-data="{ isSubmitting: false }">
    <form action="{{ $data->url ?? route('ipn.NMI') }}" method="POST" id="nmi-form" @submit="isSubmitting = true">
        @csrf
        <input type="hidden" name="track" value="{{ $deposit->trx }}">
        @if(isset($data->val))
            @foreach($data->val as $key => $value)
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
            @endforeach
        @endif

        <div class="space-y-4">
            <div>
                <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Card Number')</label>
                <input type="text" name="ccnumber" class="input-dynamic w-full px-4 py-3 text-sm rounded-xl transition-smooth" placeholder="•••• •••• •••• ••••" autocomplete="off" required>
            </div>

            <div class="grid grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Exp Month')</label>
                    <select name="ccexp_month" class="input-dynamic w-full px-4 py-3 text-sm rounded-xl transition-smooth" required>
                        <option value="">@lang('Month')</option>
                        @for($i = 1; $i <= 12; $i++)
                            <option value="{{ str_pad($i, 2, '0', STR_PAD_LEFT) }}">{{ str_pad($i, 2, '0', STR_PAD_LEFT) }}</option>
                        @endfor
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Exp Year')</label>
                    <select name="ccexp_year" class="input-dynamic w-full px-4 py-3 text-sm rounded-xl transition-smooth" required>
                        <option value="">@lang('Year')</option>
                        @for($i = date('Y'); $i <= date('Y') + 10; $i++)
                            <option value="{{ $i }}">{{ $i }}</option>
                        @endfor
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('CVV')</label>
                    <input type="text" name="cvv" class="input-dynamic w-full px-4 py-3 text-sm rounded-xl transition-smooth" placeholder="•••" autocomplete="off" required maxlength="4">
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Cardholder Name')</label>
                <input type="text" name="first_name" class="input-dynamic w-full px-4 py-3 text-sm rounded-xl transition-smooth" placeholder="John Doe" autocomplete="off" required>
            </div>

            <div>
                <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Billing Address')</label>
                <input type="text" name="address1" class="input-dynamic w-full px-4 py-3 text-sm rounded-xl transition-smooth" placeholder="123 Main Street" autocomplete="off">
            </div>

            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('City')</label>
                    <input type="text" name="city" class="input-dynamic w-full px-4 py-3 text-sm rounded-xl transition-smooth" placeholder="New York" autocomplete="off">
                </div>
                <div>
                    <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('ZIP Code')</label>
                    <input type="text" name="zip" class="input-dynamic w-full px-4 py-3 text-sm rounded-xl transition-smooth" placeholder="10001" autocomplete="off">
                </div>
            </div>
        </div>

        <button type="submit" class="btn-primary w-full py-3 px-6 text-sm font-medium rounded-xl mt-6 flex items-center justify-center gap-2" :disabled="isSubmitting">
            <template x-if="!isSubmitting">
                <span class="flex items-center gap-2">
                    <i class="ph ph-lock-simple"></i>
                    @lang('Pay Securely')
                </span>
            </template>
            <template x-if="isSubmitting">
                <span class="flex items-center gap-2">
                    <i class="ph ph-spinner animate-spin"></i>
                    @lang('Processing...')
                </span>
            </template>
        </button>
    </form>

    <div class="mt-4 flex items-center justify-center gap-2 text-xs" style="color: var(--text-muted);">
        <i class="ph ph-shield-check"></i>
        <span>@lang('Secure Payment')</span>
    </div>
</div>

