{{-- Paystack Payment Integration --}}
<div x-data="{ isProcessing: false }">
    <div class="text-center mb-6">
        <div class="inline-flex items-center justify-center w-16 h-16 rounded-2xl mb-4" style="background: var(--primary-light);">
            <i class="ph ph-credit-card text-3xl" style="color: var(--primary);"></i>
        </div>
        <p class="text-sm" style="color: var(--text-secondary);">@lang('Complete your payment securely with Paystack')</p>
    </div>

    <div class="rounded-xl p-4 mb-6" style="background: var(--primary-light);">
        <div class="flex justify-between items-center">
            <span class="text-sm" style="color: var(--text-secondary);">@lang('Amount')</span>
            <span class="font-semibold" style="color: var(--text-primary);">{{ showAmount($deposit->final_amount, currencyFormat: false) }} {{ $deposit->method_currency }}</span>
        </div>
    </div>

    <button type="button" id="paystack-btn" @click="isProcessing = true; payWithPaystack()" class="btn-primary w-full py-3 px-6 text-sm font-medium rounded-xl flex items-center justify-center gap-2" :disabled="isProcessing">
        <template x-if="!isProcessing">
            <span class="flex items-center gap-2">
                <i class="ph ph-lock-simple"></i>
                @lang('Pay Now')
            </span>
        </template>
        <template x-if="isProcessing">
            <span class="flex items-center gap-2">
                <i class="ph ph-spinner animate-spin"></i>
                @lang('Processing...')
            </span>
        </template>
    </button>

    <div class="mt-4 flex items-center justify-center gap-2 text-xs" style="color: var(--text-muted);">
        <i class="ph ph-shield-check"></i>
        <span>@lang('Secured by Paystack')</span>
    </div>
</div>

@push('scripts')
<script src="https://js.paystack.co/v1/inline.js"></script>
<script nonce="{{ csp_nonce() }}">
    function payWithPaystack() {
        var handler = PaystackPop.setup({
            key: '{{ $data->key }}',
            email: '{{ $data->email }}',
            amount: {{ $data->amount }},
            currency: '{{ $data->currency }}',
            ref: '{{ $data->ref }}',
            callback: function(response) {
                // Redirect to IPN handler
                window.location.href = '{{ route("ipn.Paystack") }}?reference=' + response.reference + '&trx={{ $deposit->trx }}';
            },
            onClose: function() {
                // Reset button state
                document.querySelector('#paystack-btn').__x.$data.isProcessing = false;
            }
        });
        handler.openIframe();
    }
</script>
@endpush

