{{-- Razorpay Payment Integration --}}
<div class="text-center">
    <div class="mb-6">
        <div class="inline-flex items-center justify-center w-16 h-16 rounded-2xl mb-4" style="background: var(--primary-light);">
            <i class="ph ph-credit-card text-3xl" style="color: var(--primary);"></i>
        </div>
        <p class="text-sm" style="color: var(--text-secondary);">@lang('Click the button below to pay via Razorpay')</p>
    </div>

    <form action="{{ $data->url }}" method="{{ $data->method ?? 'POST' }}" id="razorpay-form">
        <input type="hidden" custom="{{ $data->custom }}" name="hidden">
        <script src="{{ $data->checkout_js }}"
            @foreach($data->val as $key => $value)
                data-{{ $key }}="{{ $value }}"
            @endforeach
        ></script>
    </form>

    <div class="mt-4 flex items-center justify-center gap-2 text-xs" style="color: var(--text-muted);">
        <i class="ph ph-shield-check"></i>
        <span>@lang('Secured by Razorpay')</span>
    </div>
</div>

@push('scripts')
<script nonce="{{ csp_nonce() }}">
    (function() {
        "use strict";
        // Style the Razorpay button
        var razorpayBtn = document.querySelector('.razorpay-payment-button');
        if (razorpayBtn) {
            razorpayBtn.className = 'btn-primary w-full py-3 px-6 text-sm font-medium rounded-xl';
            razorpayBtn.innerHTML = '<i class="ph ph-credit-card mr-2"></i> Pay with Razorpay';
        }
    })();
</script>
@endpush

