@php
    $user = auth()->user();
    $layout = getLayoutConfig();
    $supportEnabled = isFeatureEnabled('support') && isMenuVisible('support');
    $depositEnabled = isFeatureEnabled('deposits');
    $securityEnabled = isFeatureEnabled('security') && isMenuVisible('security');
    $profileEnabled = isMenuVisible('profile');
    $transactionsEnabled = isMenuVisible('transactions');
    $emailHistoryEnabled = isMenuVisible('email_history');
    $headerSticky = $layout['header_sticky'];
    $showNotificationBell = $layout['show_notification_bell'];
    $showUserBalance = $layout['show_user_balance'];
    $showSearch = $layout['show_search'];
    $showQuickActions = $layout['show_quick_actions'];

    // Use injected menu data [M-03]
    $avatarMenuItems = $clientAvatarMenu;
    $useDynamicAvatarMenu = $avatarMenuItems->isNotEmpty();
@endphp

{{-- Modern Clean Header with Dynamic Colors --}}
<header class="{{ $headerSticky ? 'sticky top-0' : '' }} z-30 backdrop-blur-xl" style="background-color: var(--header-bg); border-bottom: 1px solid var(--header-border);">
    <div class="flex h-16 items-center justify-between px-4 lg:px-8">
        {{-- Left: Mobile Menu & Page Title --}}
        <div class="flex items-center gap-3">
            <button @click="sidebarOpen = true" class="lg:hidden p-2 -ml-2 rounded-xl transition-smooth text-dynamic-secondary active:scale-95">
                <i class="ph-duotone ph-list text-xl"></i>
            </button>
            <div class="flex items-center gap-3">
                <a href="{{ route('client.dashboard') }}" class="lg:hidden flex items-center hover:opacity-80 transition-opacity">
                    <x-client.logo height="h-7" mobileHeight="h-7" maxWidth="max-w-[150px]" />
                </a>
                <div class="hidden sm:block">
                    <h1 class="text-lg font-bold tracking-tight text-dynamic">{{ $title ?? __('Dashboard') }}</h1>
                </div>
            </div>
        </div>

        {{-- Right: Actions --}}
        <div class="flex items-center gap-2">
            {{-- Search Button --}}
            @if($showSearch)
            <button @click="$dispatch('open-global-search')" class="hidden lg:flex p-2.5 rounded-xl transition-smooth text-dynamic-muted hover:bg-primary-light hover:text-primary-color">
                <i class="ph-duotone ph-magnifying-glass text-xl"></i>
            </button>
            @endif

            {{-- Quick Actions: New Ticket Button --}}
            @if($supportEnabled && $showQuickActions)
            <a href="{{ route('client.tickets.create') }}" wire:navigate class="hidden md:inline-flex items-center gap-2 px-4 py-2 text-sm font-semibold rounded-xl transition-all hover:scale-[1.02] active:scale-[0.98] btn-primary">
                <i class="ph-duotone ph-headset text-base"></i>
                <span>@lang('Get Help')</span>
            </a>
            @endif

            {{-- Quick Actions: Add Funds Button --}}
            @if($depositEnabled && $showQuickActions)
            <a href="{{ route('client.deposits.add') }}" wire:navigate class="hidden md:inline-flex items-center gap-2 px-4 py-2 text-sm font-semibold rounded-xl transition-all hover:scale-[1.02] active:scale-[0.98] btn-primary">
                <i class="ph-duotone ph-plus-circle text-base"></i>
                <span>@lang('Add Funds')</span>
            </a>
            @endif

            {{-- User Balance Display --}}
            @if($showUserBalance)
            <div class="hidden sm:flex items-center gap-2 px-3 py-2 rounded-xl bg-primary-light">
                <i class="ph-duotone ph-wallet text-sm text-primary-color"></i>
                <span class="text-sm font-bold text-dynamic">{{ showAmount($user->balance ?? 0) }}</span>
            </div>
            @endif

            {{-- Theme Switcher (controlled by theme.json settings.show_mode_switcher) --}}
            @if(templateMeta('settings.show_mode_switcher', true))
            <button @click="$store.theme.toggle()" class="p-2.5 rounded-xl transition-smooth text-dynamic-muted hover:bg-primary-light hover:text-primary-color">
                <i class="ph-duotone ph-sun text-xl block dark:hidden"></i>
                <i class="ph-duotone ph-moon text-xl hidden dark:block"></i>
            </button>
            @endif

            {{-- Language Switcher --}}
            <x-client.language-switcher variant="header" position="bottom" align="right" />

            {{-- Notifications --}}
            @if($showNotificationBell)
                @livewire('client.notification-dropdown')
            @endif

            {{-- User Menu --}}
            <div class="relative" x-data="{ open: false }">
                <button @click="open = !open" class="flex items-center gap-2 p-1.5 rounded-xl transition-smooth hover:bg-primary-light group">
                    <div class="flex h-9 w-9 items-center justify-center rounded-xl text-sm font-bold bg-primary-light text-primary-color group-hover:bg-primary-color group-hover:text-white transition-colors">
                        {{ strtoupper(substr($user->firstname ?? 'U', 0, 1)) }}
                    </div>
                    <i class="ph-duotone ph-caret-down text-[10px] hidden sm:block transition-transform duration-200 text-dynamic-muted" :class="open ? 'rotate-180' : ''"></i>
                </button>

                <div x-show="open" @click.away="open = false"
                     x-transition:enter="transition ease-out duration-200"
                     x-transition:enter-start="opacity-0 translate-y-1"
                     x-transition:enter-end="opacity-100 translate-y-0"
                     x-transition:leave="transition ease-in duration-150"
                     x-transition:leave-start="opacity-100 translate-y-0"
                     x-transition:leave-end="opacity-0 translate-y-1"
                    class="absolute right-0 mt-2 w-64 rounded-2xl shadow-xl overflow-hidden"
                     style="background-color: var(--card-bg); border: 1px solid var(--card-border);"
                     x-cloak>
                    <div class="px-5 py-4" style="border-bottom: 1px solid var(--card-border); background-color: var(--primary-light);">
                        <p class="text-sm font-semibold truncate" style="color: var(--text-primary);">{{ $user->firstname }} {{ $user->lastname }}</p>
                        <p class="text-xs truncate mt-0.5" style="color: var(--text-muted);">{{ $user->email }}</p>
                    </div>

                    <div class="p-2">
                        @if($useDynamicAvatarMenu)
                            {{-- Dynamic Avatar Dropdown Menu from Database --}}
                            @foreach($avatarMenuItems as $item)
                                @php
                                    $url = $menuService->resolveItemUrl($item);
                                @endphp
                                @if($item->type === 'divider')
                                    <div class="my-1 h-px" style="background-color: var(--border);"></div>
                                @else
                                    @php
                                        $isInternalLink = ($item->target ?? '_self') === '_self' && !str_starts_with($url, 'http');
                                    @endphp
                                    <a href="{{ $url }}" target="{{ $item->target }}" @if($isInternalLink) wire:navigate @endif class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);">
                                        @if($item->icon)
                                            <i class="ph {{ $item->icon }} text-lg" style="color: var(--text-muted);"></i>
                                        @endif
                                        {{ __($item->label) }}
                                    </a>
                                @endif
                            @endforeach
                        @else
                            {{-- Legacy Hardcoded Menu --}}
                            @if($profileEnabled)
                            <a href="{{ route('client.profile') }}" wire:navigate class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);">
                                <i class="ph ph-user-circle text-lg" style="color: var(--text-muted);"></i>
                                @lang('Profile')
                            </a>
                            @endif
                            @if($securityEnabled)
                            <a href="{{ route('client.security') }}" wire:navigate class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);">
                                <i class="ph ph-shield-check text-lg" style="color: var(--text-muted);"></i>
                                @lang('Security')
                            </a>
                            @endif
                            @if($transactionsEnabled)
                            <a href="{{ route('client.transactions') }}" wire:navigate class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);">
                                <i class="ph ph-arrows-left-right text-lg" style="color: var(--text-muted);"></i>
                                @lang('Transactions')
                            </a>
                            @endif
                            @if($emailHistoryEnabled)
                            <a href="{{ route('client.emails') }}" wire:navigate class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);">
                                <i class="ph ph-envelope text-lg" style="color: var(--text-muted);"></i>
                                @lang('Email History')
                            </a>
                            @endif
                            @if($depositEnabled)
                            <a href="{{ route('client.deposits.add') }}" wire:navigate class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);">
                                <i class="ph ph-wallet text-lg" style="color: var(--text-muted);"></i>
                                @lang('Add Funds')
                            </a>
                            @endif
                        @endif
                    </div>

                    <div class="p-2" style="border-top: 1px solid var(--card-border);">
                        <form method="POST" action="{{ route('client.logout') }}">
                            @csrf
                            <button type="submit" class="flex w-full items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--danger);">
                                <i class="ph ph-sign-out text-lg"></i>
                                @lang('Sign Out')
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

