@php
    $user = auth()->user();
    $layout = getLayoutConfig();
    $showMobileBottomNav = $layout['show_mobile_bottom_nav'] ?? true;

    // Use injected menu data [M-03]
    $mobileNavItems = $clientMobileBottomMenu;
    $useDynamicMenu = $mobileNavItems->isNotEmpty();

    // Fallback to default items if no dynamic menu configured
    if (!$useDynamicMenu) {
        $defaultItems = [
            ['route' => 'client.dashboard', 'icon' => 'ph-house', 'name' => 'Home', 'exact' => true],
            ['route' => 'client.services', 'icon' => 'ph-cube', 'name' => 'Services'],
            ['route' => 'client.invoices', 'icon' => 'ph-receipt', 'name' => 'Billing'],
            ['route' => 'client.tickets', 'icon' => 'ph-chat-circle-dots', 'name' => 'Support'],
            ['route' => 'client.profile', 'icon' => 'ph-user-circle', 'name' => 'Account'],
        ];
    }
@endphp

@if($showMobileBottomNav)
{{-- Mobile Bottom Navigation Bar - Improved Responsive Version --}}
<nav class="fixed bottom-0 inset-x-0 z-[1000] lg:hidden" 
     style="background-color: var(--card-bg); 
            border-top: 1px solid var(--border); 
            box-shadow: 0 -4px 20px rgba(0,0,0,0.08);
            padding-bottom: env(safe-area-inset-bottom, 0);">
    <div class="flex items-center justify-around px-1 sm:px-2" style="min-height: 64px;">
        @if($useDynamicMenu)
            {{-- Dynamic Menu from Database --}}
            @foreach($mobileNavItems->take(5) as $item)
                @php
                    $url = $menuService->resolveItemUrl($item);
                    $isActive = false;
                    if ($item->type === 'page_link' && $item->page_key) {
                        $page = config("client_area_pages.pages.{$item->page_key}");
                        if ($page && isset($page['route'])) {
                            $isActive = request()->routeIs($page['route'] . '*');
                        }
                    } elseif ($item->type === 'route' && $item->route) {
                        $isActive = request()->routeIs($item->route . '*');
                    }
                @endphp
                @php
                    $isInternalLink = !str_starts_with($url, 'http');
                @endphp
                <a href="{{ $url }}"
                   @if($isInternalLink) wire:navigate @endif
                   class="flex flex-col items-center justify-center rounded-xl transition-all duration-200 touch-target"
                   style="min-width: 44px; 
                          min-height: 44px; 
                          padding: 0.375rem 0.5rem;
                          {{ $isActive ? 'color: var(--primary);' : 'color: var(--text-muted);' }}">
                    <i class="ph {{ str_contains($item->icon ?? 'ph-circle', 'ph-') ? ($item->icon ?? 'ph-circle') : 'ph-' . ($item->icon ?? 'circle') }}" 
                       style="font-size: 1.5rem; line-height: 1; opacity: {{ $isActive ? '1' : '0.6' }};"></i>
                    <span class="text-[10px] sm:text-[11px] font-medium mt-1 truncate" 
                          style="max-width: 64px; line-height: 1.2;">{{ __($item->label) }}</span>
                </a>
            @endforeach
        @else
            {{-- Legacy Default Navigation --}}
            @foreach($defaultItems as $item)
                @php
                    $isActive = isset($item['exact']) && $item['exact']
                        ? request()->routeIs($item['route'])
                        : request()->routeIs($item['route'].'*');
                @endphp
                <a href="{{ route($item['route']) }}"
                   wire:navigate
                   class="flex flex-col items-center justify-center rounded-xl transition-all duration-200 touch-target"
                   style="min-width: 44px; 
                          min-height: 44px; 
                          padding: 0.375rem 0.5rem;
                          {{ $isActive ? 'color: var(--primary);' : 'color: var(--text-muted);' }}">
                    <i class="ph {{ str_contains($item['icon'], 'ph-') ? $item['icon'] : 'ph-' . $item['icon'] }}" 
                       style="font-size: 1.5rem; line-height: 1; opacity: {{ $isActive ? '1' : '0.6' }};"></i>
                    <span class="text-[10px] sm:text-[11px] font-medium mt-1" 
                          style="line-height: 1.2;">@lang($item['name'])</span>
                </a>
            @endforeach
        @endif
    </div>
</nav>

{{-- Bottom Nav Spacer for Content - Includes safe area --}}
<div class="lg:hidden" style="height: calc(64px + env(safe-area-inset-bottom, 0));"></div>
@endif

