@php
    $menuService = $menuService;
    $badgeService = app(\App\Services\MenuBadgeService::class);
    $url = $menuService->resolveItemUrl($item);
    $hasChildren = $item->children && $item->children->count() > 0;

    // Get badge if any
    $badge = $badgeService->resolveBadge($item, auth()->user());

    // Badge color classes
    $badgeColors = [
        'rose' => 'bg-rose-500/20 text-rose-400',
        'amber' => 'bg-amber-500/20 text-amber-400',
        'emerald' => 'bg-emerald-500/20 text-emerald-400',
        'sky' => 'bg-sky-500/20 text-sky-400',
        'indigo' => 'bg-indigo-500/20 text-indigo-400',
        'purple' => 'bg-purple-500/20 text-purple-400',
        'orange' => 'bg-orange-500/20 text-orange-400',
        'pink' => 'bg-pink-500/20 text-pink-400',
        'slate' => 'bg-slate-500/20 text-slate-400',
    ];
    $badgeColorClass = $badge ? ($badgeColors[$badge['color']] ?? $badgeColors['slate']) : '';

    // Check if current route matches this item
    $isActive = false;
    if ($item->type === 'page_link' && $item->page_key) {
        $page = config("client_area_pages.pages.{$item->page_key}");
        if ($page && isset($page['route'])) {
            $isActive = request()->routeIs($page['route'] . '*');
        }
    } elseif ($item->type === 'route' && $item->route) {
        $isActive = request()->routeIs($item->route . '*');
    } elseif ($item->type === 'url' && $item->url) {
        $isActive = url()->current() === $item->url;
    }

    // Check if any child is active
    $hasActiveChild = false;
    if ($hasChildren) {
        foreach ($item->children as $child) {
            if ($child->type === 'page_link' && $child->page_key) {
                $childPage = config("client_area_pages.pages.{$child->page_key}");
                if ($childPage && isset($childPage['route']) && request()->routeIs($childPage['route'] . '*')) {
                    $hasActiveChild = true;
                    break;
                }
            } elseif ($child->type === 'route' && $child->route && request()->routeIs($child->route . '*')) {
                $hasActiveChild = true;
                break;
            }
        }
    }

    $depth = $depth ?? 0;
    $paddingLeft = $depth > 0 ? 'pl-' . (3 + ($depth * 3)) : 'pl-3';
@endphp

@if($item->type === 'divider')
    {{-- Divider --}}
    <li class="my-3 px-3">
        <div class="h-px" style="background-color: rgba(255,255,255,0.1);"></div>
        @if($item->label)
            <p class="mt-3 text-[11px] font-medium uppercase tracking-wider" style="color: var(--sidebar-text); opacity: 0.5;">{{ __($item->label) }}</p>
        @endif
    </li>
@elseif($hasChildren)
    {{-- Parent with Children --}}
    <li x-data="{ expanded: {{ $isActive || $hasActiveChild ? 'true' : 'false' }} }">
        <button @click="expanded = !expanded"
                @class(['w-full group flex items-center justify-between gap-3 {{ $paddingLeft }} pr-3 py-2.5 text-[13px] rounded-xl transition-smooth', 'font-medium shadow-sm' => $isActive || $hasActiveChild, 'hover-bg-sidebar' => !($isActive || $hasActiveChild)])
                style="{{ $isActive || $hasActiveChild ? 'background-color: var(--sidebar-active-bg); color: var(--sidebar-active-text);' : 'color: var(--sidebar-text);' }}"
            <span class="flex items-center gap-3">
                @if($item->icon)
                    <i class="ph {{ $isActive || $hasActiveChild ? 'ph-fill' : '' }} {{ $item->icon }} text-lg"></i>
                @endif
                <span>{{ __($item->label) }}</span>
            </span>
            <i class="ph ph-caret-down text-xs transition-transform duration-200" :class="expanded ? 'rotate-180' : ''"></i>
        </button>

        <ul x-show="expanded" x-collapse class="mt-1 space-y-1">
            @foreach($item->children as $child)
                @include('partials.client.sidebar-menu-item', ['item' => $child, 'depth' => $depth + 1])
            @endforeach
        </ul>
    </li>
@else
    {{-- Regular Link --}}
    @php
        // Only use wire:navigate for internal links (not external URLs)
        $isInternalLink = ($item->target ?? '_self') === '_self' && !str_starts_with($url, 'http');
    @endphp
    <li>
        <a href="{{ $url }}"
           target="{{ $item->target ?? '_self' }}"
           @if($isInternalLink) wire:navigate @endif
           @class(['group flex items-center gap-3 {{ $paddingLeft }} pr-3 py-2.5 text-[13px] rounded-xl transition-smooth', 'font-medium shadow-sm' => $isActive, 'hover-bg-sidebar' => !$isActive])
           style="{{ $isActive ? 'background-color: var(--sidebar-active-bg); color: var(--sidebar-active-text);' : 'color: var(--sidebar-text);' }}"
            @if($item->icon)
                <i class="ph {{ $isActive ? 'ph-fill' : '' }} {{ $item->icon }} text-lg"></i>
            @endif
            <span class="flex-1">{{ __($item->label) }}</span>
            @if($badge)
                <span class="ml-auto px-2 py-0.5 text-[10px] font-semibold rounded-full {{ $badgeColorClass }}">{{ $badge['text'] }}</span>
            @endif
        </a>
    </li>
@endif

