@php
    $user = auth()->user();
    $layout = getLayoutConfig();
    $sidebarWidth = $layout['sidebar_width'];
    $sidebarPosition = $layout['sidebar_position'];
    $showSidebarBalance = $layout['show_sidebar_balance'];
    $showQuickActions = $layout['show_quick_actions'];

    // Use injected menu data [M-03]
    $dynamicMenuItems = $clientSidebarMenu;
    $useDynamicMenu = $dynamicMenuItems->isNotEmpty();

    // Fallback to legacy navigation if no dynamic menu configured
    if (!$useDynamicMenu) {
        $navigation = getClientNavigation();
        $accountNav = getAccountNavigation();
    }

    // Feature checks for quick actions
    $depositEnabled = isFeatureEnabled('deposits');
    $supportEnabled = isFeatureEnabled('support');
@endphp

{{-- Mobile Overlay Backdrop --}}
<div
    x-show="sidebarOpen"
    x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0"
    x-transition:enter-end="opacity-100"
    x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="opacity-100"
    x-transition:leave-end="opacity-0"
    @click="sidebarOpen = false"
    class="fixed inset-0 z-40 lg:hidden"
    style="background-color: rgba(0, 0, 0, 0.5); backdrop-filter: blur(4px); -webkit-backdrop-filter: blur(4px);"
></div>

{{-- Modern Clean Sidebar with Dynamic Colors --}}
<aside
    x-ref="sidebar"
    x-persist="client-sidebar"
    :class="sidebarOpen ? 'translate-x-0' : '{{ $sidebarPosition === 'right' ? 'translate-x-full' : '-translate-x-full' }} lg:translate-x-0'"
    class="fixed inset-y-0 {{ $sidebarPosition === 'right' ? 'right-0' : 'left-0' }} z-50 flex flex-col transition-transform duration-300 ease-out sidebar-scroll overflow-y-auto safe-area-top safe-area-bottom scroll-touch"
    style="width: var(--sidebar-width); background-color: var(--sidebar-bg); border-{{ $sidebarPosition === 'right' ? 'left' : 'right' }}: 1px solid var(--border);"
    @touchstart.passive="touchStartX = $event.touches[0].clientX; touchStartY = $event.touches[0].clientY;"
    @touchmove.passive="
        if (Math.abs($event.touches[0].clientY - touchStartY) < 50) {
            const deltaX = $event.touches[0].clientX - touchStartX;
            if ('{{ $sidebarPosition }}' === 'left' && deltaX < -50) sidebarOpen = false;
            if ('{{ $sidebarPosition }}' === 'right' && deltaX > 50) sidebarOpen = false;
        }
    "
>
    {{-- Logo Section --}}
    <div class="flex items-center justify-between h-32 px-6">
        <a href="{{ route('client.dashboard') }}" wire:navigate class="hover:opacity-80 transition-opacity w-full">
            <x-client.sidebar-logo :maxHeight="$sidebarLogoHeight ?? '96'" maxWidth="max-w-none" />
        </a>
        <button @click="sidebarOpen = false" class="lg:hidden p-2 -mr-2 rounded-lg transition-smooth" style="color: var(--sidebar-text);">
            <i class="ph ph-x text-xl"></i>
        </button>
    </div>

    {{-- User Card --}}
    <div class="mx-4 mb-2 p-4 rounded-2xl" style="background-color: var(--sidebar-hover-bg);">
        <div class="flex items-center gap-3">
            <div class="flex h-11 w-11 items-center justify-center rounded-xl text-sm font-semibold" style="background-color: var(--sidebar-active-bg); color: var(--sidebar-active-text);">
                {{ strtoupper(substr($user->firstname ?? 'U', 0, 1)) }}{{ strtoupper(substr($user->lastname ?? '', 0, 1)) }}
            </div>
            <div class="flex-1 min-w-0">
                <p class="text-sm font-medium truncate" style="color: var(--sidebar-active-text);">{{ $user->firstname }} {{ $user->lastname }}</p>
                <p class="text-xs truncate" style="color: var(--sidebar-text); opacity: 0.7;">{{ $user->email }}</p>
            </div>
        </div>
        @if($showSidebarBalance)
        <div class="mt-4 pt-4 flex items-center justify-between" style="border-top: 1px solid rgba(255,255,255,0.1);">
            <div>
                <p class="text-[11px] font-medium uppercase tracking-wide" style="color: var(--sidebar-text); opacity: 0.6;">@lang('Balance')</p>
                <p class="text-lg font-semibold tracking-tight" style="color: var(--sidebar-active-text);">{{ showAmount($user->balance ?? 0) }}</p>
            </div>
            @if($depositEnabled && $showQuickActions)
            <a href="{{ route('client.deposits.add') }}" wire:navigate class="inline-flex items-center gap-1.5 px-3 py-2 text-xs font-medium rounded-lg transition-smooth" style="background-color: var(--primary); color: var(--sidebar-active-text, white);">
                <i class="ph ph-plus-circle text-sm"></i>
                @lang('Add')
            </a>
            @endif
        </div>
        @endif
    </div>

    {{-- Sidebar Search Trigger --}}
    <div class="px-4 mb-4">
        <button x-data="{ isMac: (navigator.userAgent.indexOf('Mac') !== -1) }" 
                @click="$dispatch('open-global-search')"
                class="flex items-center w-full gap-3 px-4 py-2.5 rounded-xl border border-subtle bg-transparent transition-smooth group hover-bg-sidebar"
                style="color: var(--sidebar-text);"
        >
            <i class="ph ph-magnifying-glass text-lg group-hover:text-primary transition-colors"></i>
            <span class="text-[13px] opacity-70 group-hover:opacity-100 transition-opacity">@lang('Search...')</span>
            <div class="ml-auto flex gap-0.5 items-center opacity-40 group-hover:opacity-100 transition-opacity">
                <kbd class="px-1 py-0.5 text-[9px] rounded border border-subtle" x-text="isMac ? '⌘' : 'Ctrl'"></kbd>
                <kbd class="px-1 py-0.5 text-[9px] rounded border border-subtle">K</kbd>
            </div>
        </button>
    </div>

    {{-- Navigation --}}
    <nav class="flex-1 px-4 py-4 overflow-y-auto">
        @if($useDynamicMenu)
            {{-- Dynamic Menu from Database --}}
            <ul class="space-y-1">
                @foreach($dynamicMenuItems as $item)
                    @include('partials.client.sidebar-menu-item', ['item' => $item])
                @endforeach
            </ul>
        @else
            {{-- Legacy Hardcoded Navigation --}}
            <ul class="space-y-1">
                @foreach($navigation as $item)
                    @php
                        $isActive = isset($item['exact']) && $item['exact']
                            ? request()->routeIs($item['route'])
                            : request()->routeIs($item['route'].'*');
                    @endphp
                    <li>
                        <a href="{{ route($item['route']) }}"
                           wire:navigate
                           @class(['group flex items-center gap-3 px-3 py-2.5 text-[13px] rounded-xl transition-smooth', 'font-medium shadow-sm' => $isActive, 'hover-bg-sidebar' => !$isActive])
                           style="{{ $isActive ? 'background-color: var(--sidebar-active-bg); color: var(--sidebar-active-text);' : 'color: var(--sidebar-text);' }}"
                            <i class="ph {{ $isActive ? 'ph-fill' : '' }} {{ !str_contains($item['icon'] ?? '', 'ph-') ? 'ph-' . ($item['icon'] ?? 'circle') : $item['icon'] }} text-lg"></i>
                            <span>{{ __($item['name']) }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>

            <div class="mt-6 mb-2 px-3">
                <p class="text-[11px] font-medium uppercase tracking-wider" style="color: var(--sidebar-text); opacity: 0.5;">@lang('Account')</p>
            </div>
            <ul class="space-y-1">
                @foreach($accountNav as $item)
                    @php $isActive = request()->routeIs($item['route'].'*'); @endphp
                    <li>
                        <a href="{{ route($item['route']) }}"
                           wire:navigate
                           @class(['group flex items-center gap-3 px-3 py-2.5 text-[13px] rounded-xl transition-smooth', 'font-medium shadow-sm' => $isActive, 'hover-bg-sidebar' => !$isActive])
                           style="{{ $isActive ? 'background-color: var(--sidebar-active-bg); color: var(--sidebar-active-text);' : 'color: var(--sidebar-text);' }}"
                            <i class="ph {{ $isActive ? 'ph-fill' : '' }} {{ !str_contains($item['icon'] ?? '', 'ph-') ? 'ph-' . ($item['icon'] ?? 'circle') : $item['icon'] }} text-lg"></i>
                            <span>{{ __($item['name']) }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>
        @endif
    </nav>

    {{-- Language Switcher & Logout --}}
    <div class="p-4 space-y-2" style="border-top: 1px solid rgba(255,255,255,0.1);">
        {{-- Language Switcher --}}
        <x-client.language-switcher variant="sidebar" position="top" align="left" />

        {{-- Logout Button --}}
        <form method="POST" action="{{ route('client.logout') }}">
            @csrf
            <button type="submit" class="w-full flex items-center justify-center gap-2 px-4 py-2.5 text-sm rounded-xl transition-smooth hover-bg-sidebar" style="color: var(--sidebar-text);">
                <i class="ph-duotone ph-sign-out text-lg"></i>
                @lang('Sign Out')
            </button>
        </form>
    </div>

    {{-- Mobile Swipe Indicator --}}
    <div class="lg:hidden swipe-indicator"></div>
</aside>

{{-- Mobile Floating Action Button --}}
@if($showQuickActions)
<div
    x-data="{ fabOpen: false }"
    class="fixed bottom-6 right-6 z-40 lg:hidden safe-area-bottom"
    style="padding-right: env(safe-area-inset-right, 0);"
>
    {{-- FAB Menu Items --}}
    <div
        x-show="fabOpen"
        x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0 scale-95 translate-y-4"
        x-transition:enter-end="opacity-100 scale-100 translate-y-0"
        x-transition:leave="transition ease-in duration-150"
        x-transition:leave-start="opacity-100 scale-100 translate-y-0"
        x-transition:leave-end="opacity-0 scale-95 translate-y-4"
        class="absolute bottom-16 right-0 mb-2 space-y-2"
        @click.away="fabOpen = false"
    >
        @if($supportEnabled)
        <a href="{{ route('client.tickets.create') }}" class="flex items-center gap-3 px-4 py-3 rounded-xl shadow-lg text-sm font-medium whitespace-nowrap" style="background-color: var(--card-bg); color: var(--text-primary); box-shadow: 0 10px 40px rgba(0,0,0,0.12);">
            <div class="flex h-10 w-10 items-center justify-center rounded-lg" style="background-color: var(--info); color: white;">
                <i class="ph-duotone ph-chat-circle-text text-lg"></i>
            </div>
            @lang('New Ticket')
        </a>
        @endif

        @if($depositEnabled)
        <a href="{{ route('client.deposits.add') }}" class="flex items-center gap-3 px-4 py-3 rounded-xl shadow-lg text-sm font-medium whitespace-nowrap" style="background-color: var(--card-bg); color: var(--text-primary); box-shadow: 0 10px 40px rgba(0,0,0,0.12);">
            <div class="flex h-10 w-10 items-center justify-center rounded-lg" style="background-color: var(--success); color: white;">
                <i class="ph-duotone ph-wallet text-lg"></i>
            </div>
            @lang('Add Funds')
        </a>
        @endif
    </div>

    {{-- FAB Button --}}
    <button
        @click="fabOpen = !fabOpen"
        class="flex h-14 w-14 items-center justify-center rounded-full shadow-xl transition-all duration-200"
        :class="fabOpen ? 'rotate-45' : ''"
        style="background-color: var(--primary); color: var(--sidebar-active-text, white); box-shadow: 0 8px 24px color-mix(in srgb, var(--primary) 25%, transparent);"
    >
        <i class="ph ph-plus text-2xl transition-transform duration-200" :class="fabOpen ? 'rotate-45' : ''"></i>
    </button>
</div>
@endif

