@php
    $user = auth()->user();
    $layout = getLayoutConfig();

    // Use injected menu data [M-03]
    $dynamicMenuItems = $clientTopnavMenu;
    $useDynamicMenu = $dynamicMenuItems->isNotEmpty();

    // Avatar dropdown menu
    $avatarMenuItems = $clientAvatarMenu;
    $useDynamicAvatarMenu = $avatarMenuItems->isNotEmpty();

    // Fallback to legacy navigation if no dynamic menu configured
    if (!$useDynamicMenu) {
        $navigation = getClientNavigation();
        $accountNav = getAccountNavigation();
        $mainNavItems = array_slice($navigation, 0, 5);
        $moreNavItems = array_slice($navigation, 5);
    } else {
        $navigation = [];
        $accountNav = [];
        $mainNavItems = $dynamicMenuItems->take(5);
        $moreNavItems = $dynamicMenuItems->slice(5);
    }

    // Layout settings
    $headerSticky = $layout['header_sticky'];
    $showUserBalance = $layout['show_user_balance'];
    $showCartIcon = $layout['show_cart_icon'];
    $showNotificationBell = $layout['show_notification_bell'];
    $showSearch = $layout['show_search'];
    $showQuickActions = $layout['show_quick_actions'];

    // Feature checks
    $depositEnabled = isFeatureEnabled('deposits');
    $supportEnabled = isFeatureEnabled('support') && isMenuVisible('support');
    $profileEnabled = isMenuVisible('profile');
    $securityEnabled = isFeatureEnabled('security') && isMenuVisible('security');
    $transactionsEnabled = isMenuVisible('transactions');
    $emailHistoryEnabled = isMenuVisible('email_history');
@endphp

{{-- Modern Top Navigation Bar with Dynamic Colors --}}
<header x-data="{ mobileMenuOpen: false }" class="{{ $headerSticky ? 'sticky top-0' : '' }} z-50" style="background-color: var(--header-bg); border-bottom: 1px solid var(--header-border);">
    <div class="mx-auto max-w-7xl px-4 lg:px-8">
        <div class="flex h-[72px] items-center justify-between">
            {{-- Logo --}}
            <a href="{{ route('client.dashboard') }}" class="flex items-center hover:opacity-80 transition-opacity">
                <x-client.top-logo height="h-9" mobileHeight="h-8" maxWidth="max-w-[200px]" />
            </a>

            {{-- Desktop Navigation --}}
            <nav class="hidden lg:flex items-center gap-1">
                @if($useDynamicMenu)
                    {{-- Dynamic Menu from Database --}}
                    @foreach($mainNavItems as $item)
                        @php
                            $url = $menuService->resolveItemUrl($item);
                            $isActive = false;
                            if ($item->type === 'page_link' && $item->page_key) {
                                $page = config("client_area_pages.pages.{$item->page_key}");
                                if ($page && isset($page['route'])) {
                                    $isActive = request()->routeIs($page['route'] . '*');
                                }
                            } elseif ($item->type === 'route' && $item->route) {
                                $isActive = request()->routeIs($item->route . '*');
                            }
                        @endphp
                        <a href="{{ $url }}" target="{{ $item->target ?? '_self' }}" class="px-4 py-2 rounded-xl text-sm font-medium transition-smooth hover-active-primary"
                           style="{{ $isActive ? 'background-color: var(--primary); color: white;' : 'color: var(--text-secondary);' }}"
                           
                            >
                            {{ __($item->label) }}
                        </a>
                    @endforeach

                    {{-- More Dropdown (if there are more items) --}}
                    @if($moreNavItems->count() > 0)
                    <div x-data="{ open: false }" class="relative">
                        <button @click="open = !open" class="px-4 py-2 rounded-xl text-sm font-medium transition-smooth flex items-center gap-1.5 hover-bg-primary-light" style="color: var(--text-secondary);"
                                
                                 >
                            @lang('More')
                            <i class="ph ph-caret-down text-xs transition-transform duration-200" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        <div x-show="open" @click.away="open = false" x-cloak
                             x-transition:enter="transition ease-out duration-200"
                             x-transition:enter-start="opacity-0 translate-y-1"
                             x-transition:enter-end="opacity-100 translate-y-0"
                            class="absolute right-0 mt-2 w-52 rounded-2xl shadow-xl overflow-hidden p-2"
                             style="background-color: var(--card-bg); border: 1px solid var(--card-border);">
                            @foreach($moreNavItems as $item)
                                @php $url = $menuService->resolveItemUrl($item); @endphp
                                <a href="{{ $url }}" target="{{ $item->target ?? '_self' }}" class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);">
                                    @if($item->icon)
                                        <i class="ph {{ $item->icon }}" style="color: var(--text-muted);"></i>
                                    @endif
                                    {{ __($item->label) }}
                                </a>
                            @endforeach
                        </div>
                    </div>
                    @endif
                @else
                    {{-- Legacy Hardcoded Navigation --}}
                    @foreach($mainNavItems as $item)
                        @php
                            $isActive = isset($item['exact']) && $item['exact']
                                ? request()->routeIs($item['route'])
                                : request()->routeIs($item['route'].'*');
                        @endphp
                        <a href="{{ route($item['route']) }}" class="px-4 py-2 rounded-xl text-sm font-medium transition-smooth hover-active-primary"
                           style="{{ $isActive ? 'background-color: var(--primary); color: white;' : 'color: var(--text-secondary);' }}"
                           
                            >
                            @lang($item['name'])
                        </a>
                    @endforeach

                    {{-- More Dropdown (if there are more items) --}}
                    @if(count($moreNavItems) > 0)
                    <div x-data="{ open: false }" class="relative">
                        <button @click="open = !open" class="px-4 py-2 rounded-xl text-sm font-medium transition-smooth flex items-center gap-1.5 hover-bg-primary-light" style="color: var(--text-secondary);"
                                
                                 >
                            @lang('More')
                            <i class="ph ph-caret-down text-xs transition-transform duration-200" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        <div x-show="open" @click.away="open = false" x-cloak
                             x-transition:enter="transition ease-out duration-200"
                             x-transition:enter-start="opacity-0 translate-y-1"
                             x-transition:enter-end="opacity-100 translate-y-0"
                            class="absolute right-0 mt-2 w-52 rounded-2xl shadow-xl overflow-hidden p-2"
                             style="background-color: var(--card-bg); border: 1px solid var(--card-border);">
                            @foreach($moreNavItems as $item)
                                <a href="{{ route($item['route']) }}" class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);"
                                   >
                                    <i class="ph {{ $item['icon'] }}" style="color: var(--text-muted);"></i>
                                    @lang($item['name'])
                                </a>
                            @endforeach
                        </div>
                    </div>
                    @endif
                @endif
            </nav>

            {{-- Right Side --}}
            <div class="flex items-center gap-3">
                {{-- Search Button --}}
                @if($showSearch)
                <button @click="$dispatch('open-global-search')" class="hidden lg:flex p-2.5 rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-muted);"
                        
                         >
                    <i class="ph ph-magnifying-glass text-xl"></i>
                </button>
                @endif

                {{-- User Balance --}}
                @if($showUserBalance)
                    <div class="hidden sm:flex items-center gap-2 px-4 py-2 rounded-xl" style="background-color: var(--primary-light);">
                        <i class="ph ph-wallet text-lg" style="color: var(--primary);"></i>
                        <span class="text-sm font-semibold" style="color: var(--text-primary);">{{ showAmount($user->balance ?? 0) }}</span>
                    </div>
                @endif

                {{-- Notification Bell --}}
                @if($showNotificationBell)
                    <livewire:client.notification-dropdown />
                @endif

                {{-- Mini Cart Dropdown --}}
                @if($showCartIcon)
                    <livewire:client.cart.mini-cart />
                @endif

                {{-- Language Switcher --}}
                <x-client.language-switcher variant="header" position="bottom" align="right" />

                {{-- User Menu --}}
                <div x-data="{ open: false }" class="relative">
                    <button @click="open = !open" class="flex items-center gap-2 p-1.5 rounded-xl transition-smooth hover-bg-primary-light"
                            >
                        <div class="w-9 h-9 rounded-xl flex items-center justify-center text-sm font-semibold" style="background-color: var(--primary); color: white;">
                            {{ strtoupper(substr($user->firstname ?? 'U', 0, 1)) }}
                        </div>
                        <i class="ph ph-caret-down text-xs hidden sm:block transition-transform duration-200" style="color: var(--text-muted);" :class="open ? 'rotate-180' : ''"></i>
                    </button>
                    <div x-show="open" @click.away="open = false" x-cloak
                         x-transition:enter="transition ease-out duration-200"
                         x-transition:enter-start="opacity-0 translate-y-1"
                         x-transition:enter-end="opacity-100 translate-y-0"
                        class="absolute right-0 mt-2 w-64 rounded-2xl shadow-xl overflow-hidden"
                         style="background-color: var(--card-bg); border: 1px solid var(--card-border);">
                        <div class="px-5 py-4" style="border-bottom: 1px solid var(--border); background-color: var(--primary-light);">
                            <p class="font-semibold" style="color: var(--text-primary);">{{ $user->fullname ?? 'User' }}</p>
                            <p class="text-xs mt-0.5" style="color: var(--text-muted);">{{ $user->email }}</p>
                        </div>
                        <div class="p-2">
                            @if($useDynamicAvatarMenu)
                                {{-- Dynamic Avatar Dropdown Menu --}}
                                @foreach($avatarMenuItems as $item)
                                    @php $url = $menuService->resolveItemUrl($item); @endphp
                                    @if($item->type === 'divider')
                                        <div class="my-1 h-px" style="background-color: var(--border);"></div>
                                    @else
                                        <a href="{{ $url }}" target="{{ $item->target ?? '_self' }}" class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);"
                                           >
                                            @if($item->icon)
                                                <i class="ph {{ $item->icon }} text-lg" style="color: var(--text-muted);"></i>
                                            @endif
                                            {{ __($item->label) }}
                                        </a>
                                    @endif
                                @endforeach
                            @else
                                {{-- Legacy Hardcoded Menu --}}
                                @if($profileEnabled)
                                <a href="{{ route('client.profile') }}" class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);"
                                   >
                                    <i class="ph ph-user-circle text-lg" style="color: var(--text-muted);"></i>
                                    @lang('Profile')
                                </a>
                                @endif
                                @if($securityEnabled)
                                <a href="{{ route('client.security') }}" class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);"
                                   >
                                    <i class="ph ph-shield-check text-lg" style="color: var(--text-muted);"></i>
                                    @lang('Security')
                                </a>
                                @endif
                                @if($transactionsEnabled)
                                <a href="{{ route('client.transactions') }}" class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);"
                                   >
                                    <i class="ph ph-arrows-left-right text-lg" style="color: var(--text-muted);"></i>
                                    @lang('Transactions')
                                </a>
                                @endif
                                @if($emailHistoryEnabled)
                                <a href="{{ route('client.emails') }}" class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);"
                                   >
                                    <i class="ph ph-envelope text-lg" style="color: var(--text-muted);"></i>
                                    @lang('Email History')
                                </a>
                                @endif
                                @if($depositEnabled)
                                <a href="{{ route('client.deposits.add') }}" class="flex items-center gap-3 px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-secondary);"
                                   >
                                    <i class="ph ph-wallet text-lg" style="color: var(--text-muted);"></i>
                                    @lang('Add Funds')
                                </a>
                                @endif
                            @endif
                        </div>
                        <div class="p-2" style="border-top: 1px solid var(--border);">
                            <form method="POST" action="{{ route('client.logout') }}">
                                @csrf
                                <button type="submit" class="flex items-center gap-3 w-full px-3 py-2.5 text-sm rounded-xl transition-smooth hover-bg-danger-light" style="color: var(--danger);"
                                          >
                                    <i class="ph ph-sign-out text-lg"></i>
                                    @lang('Logout')
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                {{-- Mobile Menu Button --}}
                <button @click="mobileMenuOpen = !mobileMenuOpen" class="lg:hidden p-2.5 rounded-xl transition-smooth hover-bg-primary-light" style="color: var(--text-muted);"
                        
                         >
                    <i class="ph ph-list text-xl"></i>
                </button>
            </div>
        </div>
    </div>

    {{-- Mobile Menu --}}
    <div x-show="mobileMenuOpen" x-cloak
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 -translate-y-2"
         x-transition:enter-end="opacity-100 translate-y-0"
        class="lg:hidden" style="border-top: 1px solid var(--border); background-color: var(--card-bg);">
        <nav class="px-4 py-4 space-y-1">
            @if($useDynamicMenu)
                {{-- Dynamic Menu from Database --}}
                @foreach($dynamicMenuItems as $item)
                    @php
                        $url = $menuService->resolveItemUrl($item);
                        $isActive = false;
                        if ($item->type === 'page_link' && $item->page_key) {
                            $page = config("client_area_pages.pages.{$item->page_key}");
                            if ($page && isset($page['route'])) {
                                $isActive = request()->routeIs($page['route'] . '*');
                            }
                        } elseif ($item->type === 'route' && $item->route) {
                            $isActive = request()->routeIs($item->route . '*');
                        }
                    @endphp
                    @if($item->type === 'divider')
                        @if($item->label)
                            <div class="pt-4 mt-4" style="border-top: 1px solid var(--border);">
                                <p class="px-4 text-xs font-medium uppercase tracking-wider mb-2" style="color: var(--text-muted);">{{ __($item->label) }}</p>
                            </div>
                        @else
                            <div class="my-2 h-px mx-4" style="background-color: var(--border);"></div>
                        @endif
                    @else
                        <a href="{{ $url }}" target="{{ $item->target ?? '_self' }}" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-smooth hover-active-primary"
                           style="{{ $isActive ? 'background-color: var(--primary); color: white;' : 'color: var(--text-secondary);' }}"
                           
                            >
                            @if($item->icon)
                                <i class="ph {{ $item->icon }} text-lg"></i>
                            @endif
                            {{ __($item->label) }}
                        </a>
                    @endif
                @endforeach
            @else
                {{-- Legacy Hardcoded Navigation --}}
                @foreach($navigation as $item)
                    @php
                        $isActive = isset($item['exact']) && $item['exact']
                            ? request()->routeIs($item['route'])
                            : request()->routeIs($item['route'].'*');
                    @endphp
                    <a href="{{ route($item['route']) }}" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-smooth hover-active-primary"
                       style="{{ $isActive ? 'background-color: var(--primary); color: white;' : 'color: var(--text-secondary);' }}"
                       
                        >
                        <i class="ph {{ $item['icon'] }} text-lg"></i>
                        @lang($item['name'])
                    </a>
                @endforeach

                {{-- Account Section in Mobile --}}
                @if(count($accountNav) > 0)
                <div class="pt-4 mt-4" style="border-top: 1px solid var(--border);">
                    <p class="px-4 text-xs font-medium uppercase tracking-wider mb-2" style="color: var(--text-muted);">@lang('Account')</p>
                    @foreach($accountNav as $item)
                        @php $isActive = request()->routeIs($item['route'].'*'); @endphp
                        <a href="{{ route($item['route']) }}" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-smooth hover-active-primary"
                           style="{{ $isActive ? 'background-color: var(--primary); color: white;' : 'color: var(--text-secondary);' }}"
                           
                            >
                            <i class="ph {{ $item['icon'] }} text-lg"></i>
                            @lang($item['name'])
                        </a>
                    @endforeach
                </div>
                @endif
            @endif

            {{-- Language Switcher in Mobile --}}
            <div class="pt-4 mt-4 px-4" style="border-top: 1px solid var(--border);">
                <x-client.language-switcher variant="header" position="bottom" align="left" />
            </div>
        </nav>
    </div>
</header>

