{{-- 
    Global Page Loader Overlay
    Activated by body.navigating class.
--}}
<div id="page-loader">
    <div class="loader-spinner"></div>
</div>

<style>
    #page-loader {
        position: fixed;
        inset: 0;
        z-index: 99999;
        background: rgba(10, 10, 10, 0.5);
        backdrop-filter: blur(4px);
        -webkit-backdrop-filter: blur(4px);
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease-in-out;
    }

    body.navigating #page-loader {
        opacity: 1;
        pointer-events: auto;
    }

    .loader-spinner {
        width: 48px;
        height: 48px;
        border: 3px solid rgba(255, 255, 255, 0.1);
        border-radius: 50%;
        border-top-color: var(--primary, #CC2628);
        animation: loader-spin 0.8s linear infinite;
    }

    @keyframes loader-spin {
        to { transform: rotate(360deg); }
    }

    /* Light-mode override for client area */
    html:not(.dark) #page-loader {
        background: rgba(255, 255, 255, 0.5);
    }
    html:not(.dark) .loader-spinner {
        border-color: rgba(0, 0, 0, 0.08);
        border-top-color: var(--primary, #6366f1);
    }
</style>
