@php
$caSettings = clientAreaSettings();
$primaryColor = $caSettings['primary_color'] ?? '#4f46e5';

// Get logo path for DomPDF (local path is preferred)
$logoName = gs('dark_logo') ?: 'logo_dark.png';

// Try different possible paths
$possiblePaths = [
    getFilePath('logo'),
    'assets/images/logo_icon',
    'assets/images/logo'
];

$logo = null;
foreach ($possiblePaths as $path) {
    if (!$path) continue;
    $testPath = public_path($path . '/' . $logoName);
    if (file_exists($testPath) && is_file($testPath)) {
        $logo = $testPath;
        break;
    }
}

// Fallback to light logo if dark one not found
if (!$logo) {
    $logoName = gs('logo') ?: 'logo.png';
    foreach ($possiblePaths as $path) {
        if (!$path) continue;
        $testPath = public_path($path . '/' . $logoName);
        if (file_exists($testPath) && is_file($testPath)) {
            $logo = $testPath;
            break;
        }
    }
}
@endphp
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice #{{ $invoice->invoice_number }}</title>
    <style>
        @page {
            margin: 0;
        }
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11pt;
            color: #1f2937;
            line-height: 1.4;
            margin: 0;
            padding: 40pt;
        }
        .text-primary { color: {{ $primaryColor }}; }
        .text-muted { color: #6b7280; }
        .text-right { text-align: right; }
        .font-bold { font-weight: bold; }
        
        table { width: 100%; border-collapse: collapse; }
        
        /* Layout Header */
        .header-table td { vertical-align: middle; }
        .logo { max-height: 50pt; max-width: 200pt; }
        .invoice-title { 
            font-size: 28pt; 
            font-weight: 900; 
            margin: 0; 
            text-transform: uppercase; 
            letter-spacing: -1pt;
        }
        
        .status-badge {
            display: inline-block;
            padding: 4pt 12pt;
            border-radius: 4pt;
            font-size: 9pt;
            font-weight: 700;
            text-transform: uppercase;
            margin-top: 5pt;
        }
        .status-paid { background: #dcfce7; color: #166534; }
        .status-unpaid { background: #fee2e2; color: #991b1b; }
        
        /* Info Section */
        .info-section { margin-top: 30pt; margin-bottom: 30pt; }
        .info-table td { vertical-align: top; width: 33.33%; padding: 0 10pt 0 0; }
        .info-label { 
            font-size: 8pt; 
            font-weight: 700; 
            color: #9ca3af; 
            text-transform: uppercase; 
            margin-bottom: 4pt;
        }
        .info-content { font-size: 10pt; }

        /* Items Table */
        .items-table { margin-top: 10pt; }
        .items-table th {
            background: #f9fafb;
            border-bottom: 2pt solid {{ $primaryColor }};
            padding: 10pt;
            text-align: left;
            font-size: 9pt;
            font-weight: 700;
            color: #374151;
            text-transform: uppercase;
        }
        .items-table td {
            padding: 12pt 10pt;
            border-bottom: 1pt solid #f3f4f6;
            font-size: 10pt;
        }
        .item-main { font-weight: 600; color: #111827; }
        .item-sub { font-size: 9pt; color: #6b7280; margin-top: 2pt; }

        /* Summary */
        .summary-container { margin-top: 20pt; }
        .summary-table td { padding: 4pt 0; font-size: 10pt; }
        .summary-label { color: #6b7280; }
        .summary-value { text-align: right; font-weight: 600; }
        .total-row { border-top: 1pt solid #e5e7eb; margin-top: 5pt; }
        .total-label { font-size: 14pt; font-weight: 800; padding-top: 10pt !important; }
        .total-value { font-size: 18pt; font-weight: 800; color: {{ $primaryColor }}; padding-top: 10pt !important; text-align: right; }

        .footer {
            position: fixed;
            bottom: 40pt;
            left: 40pt;
            right: 40pt;
            border-top: 1pt solid #f3f4f6;
            padding-top: 10pt;
            font-size: 8pt;
            color: #9ca3af;
            text-align: center;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <table class="header-table">
        <tr>
            <td>
                @if($logo)
                    <img src="{{ $logo }}" class="logo" alt="Logo">
                @else
                    <h2 class="invoice-title text-primary">{{ $gs->site_name }}</h2>
                @endif
            </td>
            <td class="text-right">
                <h1 class="invoice-title text-primary">Invoice</h1>
                <div style="font-weight: 700; font-size: 12pt;">#{{ $invoice->invoice_number }}</div>
                <div class="status-badge {{ $invoice->status == 1 ? 'status-paid' : 'status-unpaid' }}">
                    {{ $invoice->status == 1 ? 'Paid' : ($invoice->status == 2 ? 'Unpaid' : ($invoice->status == 3 ? 'Cancelled' : 'Partially Paid')) }}
                </div>
            </td>
        </tr>
    </table>

    <!-- Info Section -->
    <div class="info-section">
        <table class="info-table">
            <tr>
                <td>
                    <div class="info-label">From</div>
                    <div class="info-content">
                        <strong>{{ $bs->company_name }}</strong><br>
                        {{ $bs->company_address }}<br>
                        {{ $bs->company_city }}, {{ $bs->company_state }} {{ $bs->company_zip }}<br>
                        {{ $bs->company_country }}
                        @if($bs->company_phone)<br>P: {{ $bs->company_phone }}@endif
                        @if($bs->company_email)<br>E: {{ $bs->company_email }}@endif
                    </div>
                </td>
                <td>
                    <div class="info-label">To</div>
                    <div class="info-content">
                        <strong>{{ $invoice->user->fullname }}</strong><br>
                        @if($invoice->user->address)
                            {{ $invoice->user->address }}<br>
                        @endif
                        @if($invoice->user->city || $invoice->user->state || $invoice->user->zip)
                            {{ implode(', ', array_filter([$invoice->user->city, $invoice->user->state, $invoice->user->zip])) }}<br>
                        @endif
                        @if($invoice->user->country_name)
                            {{ $invoice->user->country_name }}<br>
                        @endif
                        E: {{ $invoice->user->email }}
                    </div>
                </td>
                <td style="padding-right: 0;">
                    <div class="info-label">Details</div>
                    <table style="width: 100%;">
                        <tr>
                            <td style="font-size: 9pt; color: #9ca3af; padding: 2pt 0;">Invoice Date:</td>
                            <td class="text-right" style="font-size: 9pt; font-weight: 600;">{{ showDateTime($invoice->created_at, 'd M Y') }}</td>
                        </tr>
                        <tr>
                            <td style="font-size: 9pt; color: #9ca3af; padding: 2pt 0;">Due Date:</td>
                            <td class="text-right" style="font-size: 9pt; font-weight: 600;">{{ showDateTime($invoice->due_date, 'd M Y') }}</td>
                        </tr>
                        @if($invoice->order)
                        <tr>
                            <td style="font-size: 9pt; color: #9ca3af; padding: 2pt 0;">Order Reference:</td>
                            <td class="text-right" style="font-size: 9pt; font-weight: 600;">#{{ $invoice->order->id }}</td>
                        </tr>
                        @endif
                    </table>
                </td>
            </tr>
        </table>
    </div>

    <!-- Items -->
    <table class="items-table">
        <thead>
            <tr>
                <th>Item Description</th>
                <th class="text-right" style="width: 80pt;">Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoice->items as $item)
                @if($item->amount >= 0) {{-- Only show positive charges in main list, discounts in summary --}}
                <tr>
                    <td>
                        <div class="item-main">{{ $item->description }}</div>
                        <div class="item-sub">
                            @if($item->hosting)
                                {{ $item->hosting->package_name }} - {{ $item->hosting->domain }}
                            @elseif($item->domain)
                                {{ $item->domain->domain }}
                            @endif
                        </div>
                    </td>
                    <td class="text-right font-bold">{{ showAmount(abs($item->amount)) }}</td>
                </tr>
                @endif
            @endforeach
        </tbody>
    </table>

    <!-- Summary -->
    <div class="summary-container">
        <table style="width: 100%;">
            <tr>
                <td style="vertical-align: top; width: 60%; padding-right: 50pt;">
                    @if($invoice->status != 1)
                        <div style="background: #fffbeb; border: 1pt solid #fef3c7; border-left: 3pt solid #f59e0b; padding: 10pt; border-radius: 4pt;">
                            <div style="font-size: 9pt; font-weight: 700; color: #92400e; text-transform: uppercase;">Payment Instruction</div>
                            <div style="font-size: 9pt; color: #b45309; margin-top: 4pt;">
                                Please settle this invoice by {{ showDateTime($invoice->due_date, 'd M Y') }}. 
                                @if($bs->invoice_late_fee_amount > 0)
                                    A late fee of {{ showAmount($bs->invoice_late_fee_amount) }} may apply after {{ $bs->invoice_late_fee_days }} days.
                                @endif
                            </div>
                        </div>
                    @else
                        <div style="background: #f0fdf4; border: 1pt solid #dcfce7; border-left: 3pt solid #22c55e; padding: 10pt; border-radius: 4pt;">
                            <div style="font-size: 9pt; font-weight: 700; color: #166534; text-transform: uppercase;">Payment Confirmed</div>
                            <div style="font-size: 9pt; color: #15803d; margin-top: 4pt;">
                                This invoice was paid on {{ showDateTime($invoice->updated_at, 'd M Y') }}. Thank you for choosing {{ $gs->site_name }}.
                            </div>
                        </div>
                    @endif
                </td>
                <td style="vertical-align: top; width: 40%;">
                    @php
                        // Correct logic to reconstruct the display summary:
                        // 1. Paid Total is fixed (invoice->total)
                        // 2. Discount is fixed (invoice->discount)
                        // 3. Subtotal (Gross) = Paid Total + Discount - Tax - Late Fee
                        $displaySubtotal = $invoice->total + $invoice->discount - $invoice->tax - $invoice->late_fee;
                    @endphp
                    <table class="summary-table">
                        <tr>
                            <td class="summary-label">Subtotal</td>
                            <td class="summary-value">{{ showAmount($displaySubtotal) }}</td>
                        </tr>
                        @if($invoice->discount > 0)
                            @php
                                $couponCode = null;
                                if($invoice->order && $invoice->order->coupon) {
                                    $couponCode = $invoice->order->coupon->code;
                                } else {
                                    foreach($invoice->items as $it) {
                                        if($it->hosting && $it->hosting->coupon) { $couponCode = $it->hosting->coupon->code; break; }
                                    }
                                }
                            @endphp
                            <tr>
                                <td class="summary-label">Discount @if($couponCode)({{ $couponCode }})@endif</td>
                                <td class="summary-value" style="color: #ef4444;">-{{ showAmount($invoice->discount) }}</td>
                            </tr>
                        @endif
                        @if($invoice->tax > 0)
                            <tr>
                                <td class="summary-label">Tax</td>
                                <td class="summary-value">{{ showAmount($invoice->tax) }}</td>
                            </tr>
                        @endif
                        @if($invoice->late_fee > 0)
                            <tr>
                                <td class="summary-label">Late Fee</td>
                                <td class="summary-value">{{ showAmount($invoice->late_fee) }}</td>
                            </tr>
                        @endif
                        <tr class="total-row">
                            <td class="total-label">Total</td>
                            <td class="total-value">{{ showAmount($invoice->total) }}</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>

    @if($bs->invoice_footer)
        <div class="footer">
            {{ $bs->invoice_footer }}
        </div>
    @endif
</body>
</html>

