// Salieno Specific JavaScript
import './order';

// Countdown Timer — shared Alpine data function for discount countdowns
// Used by pricing.blade.php and category.blade.php
window.countdownTimer = function (endTimestamp) {
    return {
        days: 0,
        hours: 0,
        minutes: 0,
        seconds: 0,
        expired: false,
        interval: null,

        init() {
            this.updateCountdown();
            this.interval = setInterval(() => this.updateCountdown(), 1000);
        },

        updateCountdown() {
            const now = Date.now();
            const diff = endTimestamp - now;

            if (diff <= 0) {
                this.expired = true;
                clearInterval(this.interval);
                return;
            }

            this.days = Math.floor(diff / (1000 * 60 * 60 * 24));
            this.hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            this.minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
            this.seconds = Math.floor((diff % (1000 * 60)) / 1000);
        },

        destroy() {
            if (this.interval) clearInterval(this.interval);
        }
    }
};
