<div class="min-h-screen flex bg-dynamic relative overflow-hidden transition-smooth">
    {{-- Background Effects --}}
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_60%_60%_at_50%_50%,black_40%,transparent_100%)]"></div>
        <div class="absolute top-1/4 right-1/4 w-[600px] h-[600px] bg-primary-500/10 dark:bg-primary-500/20 rounded-full blur-[120px] animate-pulse-glow"></div>
        <div class="absolute bottom-0 left-0 w-[500px] h-[500px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[100px]"></div>
    </div>

    <div class="w-full flex items-center justify-center p-6 sm:p-12 relative z-10">
        <div class="w-full max-w-2xl">

            <div class="flex justify-center mb-10">
                <x-logo maxHeight="max-h-14" maxWidth="max-w-[240px]" containerClass="h-14 justify-center" imageClass="object-contain object-center" />
            </div>

            <div class="card-dynamic rounded-2xl p-8 sm:p-10 shadow-xl shadow-slate-200/50 dark:shadow-none transition-smooth">
                <div class="text-center mb-8">
                    <h2 class="text-xl font-bold text-slate-900 dark:text-white mb-1.5">@lang('Finalize Your Profile')</h2>
                    <p class="text-slate-500 dark:text-slate-400 text-sm">@lang('Just a few more details to get your account fully mission-ready.')</p>
                </div>

                <form wire:submit="submit" class="space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                        {{-- Username & Mobile Section --}}
                        <div class="space-y-5">
                            <div>
                                <label for="username" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Choose Username') <span class="text-primary-500">*</span></label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                        <i class="ph ph-user-circle text-slate-500 dark:text-slate-400"></i>
                                    </div>
                                    <input type="text" id="username" wire:model.blur="username" required
                                        class="w-full pl-11 pr-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                        placeholder="@lang('username123')">
                                </div>
                                @error('username') <p class="mt-1 text-xs text-red-400">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="mobile" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Phone Number') <span class="text-primary-500">*</span></label>
                                <div class="flex gap-2.5">
                                    <div class="h-11 w-14 bg-slate-100 dark:bg-white/5 border border-slate-200 dark:border-white/10 rounded-xl flex items-center justify-center text-slate-500 dark:text-slate-400 text-xs font-mono shrink-0">
                                        {{ $dial_code }}
                                    </div>
                                    <input type="tel" id="mobile" wire:model.blur="mobile" required
                                        class="w-full px-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                        placeholder="@lang('Mobile number')">
                                </div>
                                @error('mobile') <p class="mt-1 text-xs text-red-400">{{ $message }}</p> @enderror
                            </div>

                             <div>
                                <label for="country_code" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Country') <span class="text-primary-500">*</span></label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                        <i class="ph ph-globe-hemisphere-west text-slate-500 dark:text-slate-400"></i>
                                    </div>
                                    <select id="country_code" wire:model.live="country_code" required
                                        class="w-full pl-11 pr-10 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white appearance-none focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans">
                                        <option value="" class="bg-white dark:bg-slate-900">@lang('Select Country')</option>
                                        @foreach($countries as $code => $data)
                                            <option value="{{ $code }}" class="bg-white dark:bg-slate-900">{{ $data['country'] }}</option>
                                        @endforeach
                                    </select>
                                    <div class="absolute inset-y-0 right-0 pr-4 flex items-center pointer-events-none">
                                        <i class="ph ph-caret-down text-slate-500 dark:text-slate-400"></i>
                                    </div>
                                </div>
                                @error('country_code') <p class="mt-1 text-xs text-red-400">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        {{-- Address Section --}}
                        <div class="space-y-5">
                            <div class="grid grid-cols-2 gap-3">
                                <div>
                                    <label for="city" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('City')</label>
                                    <input type="text" id="city" wire:model.blur="city"
                                        class="w-full px-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                        placeholder="@lang('City')">
                                    @error('city') <p class="mt-1 text-xs text-red-400">{{ $message }}</p> @enderror
                                </div>
                                <div>
                                    <label for="state" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('State')</label>
                                    <input type="text" id="state" wire:model.blur="state"
                                        class="w-full px-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                        placeholder="@lang('State')">
                                    @error('state') <p class="mt-1 text-xs text-red-400">{{ $message }}</p> @enderror
                                </div>
                            </div>

                            <div>
                                <label for="zip" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Zip / Postal Code')</label>
                                <input type="text" id="zip" wire:model.blur="zip"
                                    class="w-full px-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                    placeholder="@lang('10001')">
                                @error('zip') <p class="mt-1 text-xs text-red-400">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label for="address" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Street Address')</label>
                                <textarea id="address" wire:model.blur="address" rows="2"
                                    class="w-full p-4 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans resize-none"
                                    placeholder="@lang('123 Cyber Way, Floor 42')"></textarea>
                                @error('address') <p class="mt-1 text-xs text-red-400">{{ $message }}</p> @enderror
                            </div>
                        </div>
                    </div>

                    <div class="pt-5 border-t border-slate-200 dark:border-white/5">
                        <button type="submit" wire:loading.attr="disabled"
                            class="group w-full inline-flex items-center justify-center gap-2 px-7 py-2.5
                                   bg-primary-500 hover:bg-primary-600
                                   text-white font-bold text-sm rounded-xl
                                   shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40
                                   transition-[background-color,color,transform,box-shadow] duration-300 hover:scale-[1.02] active:scale-[0.98]
                                   ">
                            <span wire:loading.remove wire:target="submit" class="flex items-center gap-2">
                                @lang('Complete Onboarding')
                                <svg class="w-4 h-4 transition-transform group-hover:translate-x-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                </svg>
                            </span>
                            <span wire:loading wire:target="submit" class="flex items-center gap-2">
                               <svg class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                   <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                   <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                               </svg>
                               @lang('Finalizing...')
                            </span>
                        </button>
                    </div>
                </form>

                <div class="mt-8 pt-5 border-t border-slate-200 dark:border-white/5 text-center">
                    <form action="{{ route('client.logout') }}" method="POST">
                        @csrf
                        <button type="submit" class="text-slate-500 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white transition-colors text-xs font-medium flex items-center justify-center gap-1.5 mx-auto">
                            <i class="ph ph-sign-out"></i>
                            @lang('Logout and finish later')
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
