<div class="min-h-screen flex bg-dynamic relative overflow-hidden transition-smooth">
    {{-- Background Effects --}}
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_60%_60%_at_50%_50%,black_40%,transparent_100%)]"></div>
        <div class="absolute top-1/4 right-1/4 w-[600px] h-[600px] bg-primary-500/10 dark:bg-primary-500/20 rounded-full blur-[120px] animate-pulse-glow"></div>
        <div class="absolute bottom-0 left-0 w-[500px] h-[500px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[100px]"></div>
    </div>

    <div class="w-full flex items-center justify-center p-6 sm:p-12 relative z-10">
        <div class="w-full max-w-md">

            <div class="flex justify-center mb-10">
                <x-logo maxHeight="max-h-14" maxWidth="max-w-[240px]" containerClass="h-14 justify-center" imageClass="object-contain object-center" />
            </div>

            <div class="card-dynamic rounded-2xl p-8 sm:p-10 shadow-xl shadow-slate-200/50 dark:shadow-none transition-smooth">
                @if($emailSent)
                    <div class="text-center space-y-5">
                        <div class="w-16 h-16 bg-green-500/10 rounded-2xl flex items-center justify-center mx-auto border border-green-500/20">
                            <i class="ph ph-check-circle text-3xl text-green-500"></i>
                        </div>
                        <div>
                            <h2 class="text-xl font-bold text-slate-900 dark:text-white mb-1.5">@lang('Check your email')</h2>
                            <p class="text-slate-500 dark:text-slate-400 text-sm leading-relaxed">
                                @lang("We've sent a password reset link to") <br>
                                <span class="text-slate-900 dark:text-white font-semibold">{{ $email }}</span>
                            </p>
                        </div>
                        <div class="pt-3 space-y-2">
                            <p class="text-xs text-slate-400 dark:text-slate-500">
                                @lang("Didn't receive the email? Check your spam folder or")
                            </p>
                            <button wire:click="$set('emailSent', false)" class="text-primary-500 hover:text-primary-600 dark:text-primary-400 dark:hover:text-primary-300 font-semibold transition-colors text-sm">
                                @lang('Try another email address')
                            </button>
                        </div>
                        <div class="pt-5 border-t border-slate-200 dark:border-white/5">
                            <a href="{{ route('client.login') }}" wire:navigate class="text-slate-500 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white transition-colors text-sm flex items-center justify-center gap-1.5">
                                <i class="ph ph-arrow-left"></i>
                                @lang('Back to Sign In')
                            </a>
                        </div>
                    </div>
                @else
                    <div class="text-center mb-8">
                        <h2 class="text-xl font-bold text-slate-900 dark:text-white mb-1.5">@lang('Forgot Password?')</h2>
                        <p class="text-slate-500 dark:text-slate-400 text-sm">@lang("No worries, we'll send you reset instructions.")</p>
                    </div>

                    <form wire:submit="sendResetLink" class="space-y-5">
                        <div>
                            <label for="email" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Email Address')</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                    <i class="ph ph-envelope text-slate-500 dark:text-slate-400"></i>
                                </div>
                                <input type="email" id="email" wire:model="email" required
                                    class="w-full pl-11 pr-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                    placeholder="you@example.com" autofocus autocomplete="email">
                            </div>
                            @error('email')
                                <p class="mt-1 text-xs text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <button type="submit" wire:loading.attr="disabled"
                            class="group w-full inline-flex items-center justify-center gap-2 px-7 py-2.5
                                   bg-primary-500 hover:bg-primary-600
                                   text-white font-bold text-sm rounded-xl
                                   shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40
                                   transition-[background-color,color,transform,box-shadow] duration-300 hover:scale-[1.02] active:scale-[0.98]
                                   ">
                            <span wire:loading.remove wire:target="sendResetLink" class="flex items-center gap-2">
                                @lang('Send Reset Link')
                                <svg class="w-4 h-4 transition-transform group-hover:translate-x-1 group-hover:-translate-y-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                </svg>
                            </span>
                            <span wire:loading wire:target="sendResetLink" class="flex items-center gap-2">
                               <svg class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                   <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                   <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                               </svg>
                               @lang('Sending...')
                            </span>
                        </button>
                    </form>

                    <div class="mt-8 pt-5 border-t border-slate-200 dark:border-white/5 text-center">
                        <a href="{{ route('client.login') }}" wire:navigate
                            class="text-slate-500 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white transition-colors text-sm font-medium flex items-center justify-center gap-1.5">
                            <i class="ph ph-arrow-left"></i>
                            @lang('Back to Sign In')
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
