<div class="min-h-screen flex bg-dynamic relative overflow-hidden transition-smooth">
    {{-- Background Effects --}}
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_60%_60%_at_50%_50%,black_40%,transparent_100%)]"></div>
        <div class="absolute top-1/4 right-1/4 w-[600px] h-[600px] bg-primary-500/10 dark:bg-primary-500/20 rounded-full blur-[120px] animate-pulse-glow"></div>
        <div class="absolute bottom-0 left-0 w-[500px] h-[500px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[100px]"></div>
    </div>

    {{-- Left Panel - Branding (Hidden on Mobile) --}}
    <div class="hidden lg:flex lg:w-1/2 xl:w-2/5 relative items-center justify-center p-12">
        <div class="relative z-10 text-center">
            <div class="flex justify-center mb-8">
                <x-logo maxHeight="max-h-20" maxWidth="max-w-[280px]" containerClass="h-20 justify-center" imageClass="object-contain object-center" />
            </div>
            <h1 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold tracking-tight leading-tight text-slate-900 dark:text-white mb-5">
                @lang('Welcome Back to') <span
                    class="text-transparent bg-clip-text bg-gradient-to-r from-primary-500 via-primary-600 to-primary-800">{{ gs('site_name') ?? 'salieno' }}</span>
            </h1>
            <p class="text-sm sm:text-base text-slate-600 dark:text-slate-400 leading-relaxed max-w-md mx-auto">
                @lang('Access your mission control center to manage services, billing, and support tickets.')
            </p>

            {{-- Trust Metrics --}}
            @php
                $userCount = \App\Models\User::count();
                if ($userCount >= 1000) {
                    $formattedUsers = number_format($userCount / 1000, $userCount >= 10000 ? 0 : 1) . 'K+';
                } else {
                    $formattedUsers = $userCount;
                }
            @endphp
            <div class="mt-10 flex items-center justify-center gap-6 lg:gap-10 text-sm">
                <div class="flex flex-col items-center">
                    <span class="text-xl sm:text-2xl font-extrabold text-slate-900 dark:text-white">99.9%</span>
                    <span class="text-slate-500 dark:text-slate-400 text-[10px] sm:text-xs uppercase tracking-wider">@lang('Uptime')</span>
                </div>
                <div class="w-px h-8 bg-slate-200 dark:bg-white/10"></div>
                <div class="flex flex-col items-center">
                    <span class="text-xl sm:text-2xl font-extrabold text-slate-900 dark:text-white">{{ $formattedUsers }}</span>
                    <span class="text-slate-500 dark:text-slate-400 text-[10px] sm:text-xs uppercase tracking-wider">@lang('Users')</span>
                </div>
                <div class="w-px h-8 bg-slate-200 dark:bg-white/10"></div>
                <div class="flex flex-col items-center">
                    <span class="text-xl sm:text-2xl font-extrabold text-slate-900 dark:text-white">24/7</span>
                    <span class="text-slate-500 dark:text-slate-400 text-[10px] sm:text-xs uppercase tracking-wider">@lang('Support')</span>
                </div>
            </div>
        </div>
    </div>

    {{-- Right Panel - Login Form --}}
    <div class="w-full lg:w-1/2 xl:w-3/5 flex items-center justify-center p-6 sm:p-12 relative z-10">
        <div class="w-full max-w-md">

            {{-- Mobile Logo --}}
            <div class="lg:hidden flex justify-center mb-10">
                <x-logo maxHeight="max-h-14" maxWidth="max-w-[240px]" containerClass="h-14 justify-center" imageClass="object-contain object-center" />
            </div>

            <div class="card-dynamic rounded-2xl p-8 sm:p-10 shadow-xl shadow-slate-200/50 dark:shadow-none transition-smooth">
                <div class="text-center mb-8">
                    <h2 class="text-xl font-bold text-slate-900 dark:text-white mb-1.5">@lang('Sign In')</h2>
                    <p class="text-slate-500 dark:text-slate-400 text-sm">@lang('Enter your credentials to access your account')</p>
                </div>

                <form wire:submit="login" class="space-y-5">
                    <div>
                        <label for="username"
                            class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Email or Username')</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <svg class="w-4 h-4 text-slate-500 dark:text-slate-400" fill="none" viewBox="0 0 24 24"
                                    stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                </svg>
                            </div>
                            <input type="text" id="username" wire:model="username" required
                                class="w-full pl-11 pr-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                placeholder="@lang('Username or Email')" autofocus autocomplete="username">
                        </div>
                        @error('username')
                            <p class="mt-1 text-xs text-red-400">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <div class="flex items-center justify-between mb-2">
                            <label for="password"
                                class="block text-sm font-medium text-slate-700 dark:text-slate-300">@lang('Password')</label>
                            <a href="{{ route('client.password.request') }}" wire:navigate
                                class="text-xs text-primary-500 hover:text-primary-600 dark:text-primary-400 dark:hover:text-primary-300 transition-colors font-medium">@lang('Forgot Password?')</a>
                        </div>
                        <div class="relative" x-data="{ showPassword: false }">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <svg class="w-4 h-4 text-slate-500 dark:text-slate-400" fill="none" viewBox="0 0 24 24"
                                    stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                </svg>
                            </div>
                            <input :type="showPassword ? 'text' : 'password'" id="password" wire:model="password" required
                                class="w-full pl-11 pr-11 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                placeholder="••••••••" autocomplete="current-password">
                            <button type="button" @click="showPassword = !showPassword"
                                class="absolute inset-y-0 right-0 pr-4 flex items-center" aria-label="Toggle password visibility">
                                <i class="ph text-slate-500 dark:text-slate-400 hover:text-slate-600 dark:hover:text-white transition-colors" :class="showPassword ? 'ph-eye-slash' : 'ph-eye'"></i>
                            </button>
                        </div>
                        @error('password')
                            <p class="mt-1 text-xs text-red-400">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" id="remember" wire:model="remember"
                            class="w-4 h-4 rounded bg-slate-100 dark:bg-slate-800 border-slate-300 dark:border-slate-700 text-primary-500 focus:ring-primary-500 focus:ring-offset-0">
                        <label for="remember" class="ml-2.5 text-sm text-slate-600 dark:text-slate-400">@lang('Remember me')</label>
                    </div>

                    <button type="submit" wire:loading.attr="disabled"
                        class="group w-full inline-flex items-center justify-center gap-2 px-7 py-2.5
                               bg-primary-500 hover:bg-primary-600
                               text-white font-bold text-sm rounded-xl
                               shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40
                               transition-[background-color,color,transform,box-shadow] duration-300 hover:scale-[1.02] active:scale-[0.98]
                               ">
                        <span wire:loading.remove wire:target="login" class="flex items-center gap-2">
                            @lang('Sign In')
                            <svg class="w-4 h-4 transition-transform group-hover:translate-x-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                            </svg>
                        </span>
                        <span wire:loading wire:target="login" class="flex items-center gap-2">
                           <svg class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                               <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                               <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                           </svg>
                           @lang('Signing in...')
                        </span>
                    </button>
                </form>

                {{-- Social Login --}}
                @php $socialProviders = getSocialProviders(); @endphp
                @if(count($socialProviders) > 0)
                    <div class="mt-6 flex items-center gap-4">
                        <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                        <span class="text-xs text-slate-500 dark:text-slate-400 uppercase tracking-widest font-medium">@lang('Or continue with')</span>
                        <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                    </div>
                    <div class="mt-5 grid grid-cols-1 sm:grid-cols-2 gap-3">
                        @foreach($socialProviders as $provider => $config)
                            <a href="{{ route('client.social.redirect', $provider) }}" class="flex items-center justify-center gap-2.5 h-11 rounded-xl bg-slate-900/5 dark:bg-white/5 hover:bg-slate-900/10 dark:hover:bg-white/10 border border-slate-200 dark:border-white/10 hover:border-slate-300 dark:hover:border-white/20 transition-[border-color,background-color] duration-300">
                                <i class="ph ph-bold {{ $config['icon'] }} text-base"></i>
                                <span class="text-sm font-medium text-slate-700 dark:text-slate-200">{{ $config['name'] }}</span>
                            </a>
                        @endforeach
                    </div>
                @endif

                <div class="mt-8 text-center">
                    <p class="text-slate-500 dark:text-slate-400 text-sm">
                        @lang("Don't have an account?")
                        <a href="{{ route('client.register') }}" wire:navigate
                            class="text-primary-500 hover:text-primary-600 dark:text-primary-400 dark:hover:text-primary-300 font-semibold transition-colors">@lang('Create Account')</a>
                    </p>
                </div>
            </div>

            <p class="mt-6 text-center text-xs text-slate-500 dark:text-slate-400">
                @lang('By signing in, you agree to our')
                <a href="{{ route('policy.pages', 'terms-of-service') }}" class="text-slate-600 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white transition-colors">@lang('Terms of Service')</a>
                @lang('and')
                <a href="{{ route('policy.pages', 'privacy-policy') }}" class="text-slate-600 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white transition-colors">@lang('Privacy Policy')</a>
            </p>
        </div>
    </div>
</div>