<div class="min-h-screen flex bg-dynamic relative overflow-hidden transition-smooth">
    {{-- Background Effects --}}
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_60%_60%_at_50%_50%,black_40%,transparent_100%)]"></div>
        <div class="absolute top-1/4 left-1/4 w-[600px] h-[600px] bg-primary-500/10 dark:bg-primary-500/20 rounded-full blur-[120px] animate-pulse-glow"></div>
        <div class="absolute bottom-0 right-0 w-[500px] h-[500px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[100px]"></div>
    </div>

    {{-- Left Panel - Register Form --}}
    <div class="w-full lg:w-1/2 xl:w-3/5 flex items-center justify-center p-6 sm:p-12 relative z-10">
        <div class="w-full max-w-lg">

            {{-- Mobile Logo --}}
            <div class="lg:hidden flex justify-center mb-10">
                <x-logo maxHeight="max-h-14" maxWidth="max-w-[240px]" containerClass="h-14 justify-center" imageClass="object-contain object-center" />
            </div>

            <div class="card-dynamic rounded-2xl p-8 sm:p-10 shadow-xl shadow-slate-200/50 dark:shadow-none transition-smooth">
                <div class="text-center mb-8">
                    <h2 class="text-xl font-bold text-slate-900 dark:text-white mb-1.5">@lang('Create Account')</h2>
                    <p class="text-slate-500 dark:text-slate-400 text-sm">@lang('Start your journey with us today')</p>
                </div>

                <form wire:submit="register" class="space-y-5">
                    {{-- Hidden country_code for core system binding --}}
                    <input type="hidden" wire:model="country_code">

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <label for="firstname"
                                class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('First Name')</label>
                            <input type="text" id="firstname" wire:model="firstname" required
                                class="w-full px-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                placeholder="John">
                            @error('firstname')
                                <p class="mt-1 text-xs text-red-400">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label for="lastname"
                                class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Last Name')</label>
                            <input type="text" id="lastname" wire:model="lastname" required
                                class="w-full px-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                placeholder="Doe">
                            @error('lastname')
                                <p class="mt-1 text-xs text-red-400">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <div>
                        <label for="email"
                            class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Email Address')</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <svg class="w-4 h-4 text-slate-500 dark:text-slate-400" fill="none" viewBox="0 0 24 24"
                                    stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <input type="email" id="email" wire:model="email" required
                                class="w-full pl-11 pr-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                placeholder="you@example.com" autocomplete="email">
                        </div>
                        @error('email')
                            <p class="mt-1 text-xs text-red-400">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="mobile"
                            class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Phone Number')</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <svg class="w-4 h-4 text-slate-500 dark:text-slate-400" fill="none" viewBox="0 0 24 24"
                                    stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                </svg>
                            </div>
                            <input type="tel" id="mobile" wire:model="mobile"
                                class="w-full pl-11 pr-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                placeholder="+1 (555) 000-0000" autocomplete="tel">
                        </div>
                        @error('mobile')
                            <p class="mt-1 text-xs text-red-400">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <label for="password"
                                class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Password')</label>
                            <div class="relative" x-data="{ show: false }">
                                <input :type="show ? 'text' : 'password'" id="password" wire:model="password" required
                                    class="w-full px-4 pr-10 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                    placeholder="••••••••" autocomplete="new-password">
                                <button type="button" @click="show = !show"
                                    class="absolute inset-y-0 right-0 pr-3 flex items-center" aria-label="Toggle password visibility">
                                    <i class="ph text-slate-500 dark:text-slate-400 hover:text-slate-600 dark:hover:text-white transition-colors" :class="show ? 'ph-eye-slash' : 'ph-eye'"></i>
                                </button>
                            </div>
                            @error('password')
                                <p class="mt-1 text-xs text-red-400">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label for="password_confirmation"
                                class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Confirm Password')</label>
                            <input type="password" id="password_confirmation" wire:model="password_confirmation" required
                                class="w-full px-4 h-11 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-sm text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-1 focus:ring-primary-500/20 transition-[border-color,box-shadow] font-sans"
                                placeholder="••••••••" autocomplete="new-password">
                        </div>
                    </div>

                    <div class="flex items-start">
                        <input type="checkbox" id="agree" wire:model="agree" required
                            class="mt-0.5 w-4 h-4 rounded bg-slate-100 dark:bg-slate-800 border-slate-300 dark:border-slate-700 text-primary-500 focus:ring-primary-500 focus:ring-offset-0">
                        <label for="agree" class="ml-2.5 text-sm text-slate-600 dark:text-slate-400">
                            @lang('I agree to the') <a href="{{ route('policy.pages', 'terms-of-service') }}" wire:navigate
                                class="text-primary-500 hover:text-primary-600 dark:text-primary-400 dark:hover:text-primary-300 font-medium">@lang('Terms of Service')</a> @lang('and')
                            <a href="{{ route('policy.pages', 'privacy-policy') }}" wire:navigate class="text-primary-500 hover:text-primary-600 dark:text-primary-400 dark:hover:text-primary-300 font-medium">@lang('Privacy Policy')</a>
                        </label>
                    </div>
                    @error('agree')
                        <p class="mt-1 text-xs text-red-400">{{ $message }}</p>
                    @enderror

                    <button type="submit" wire:loading.attr="disabled"
                        class="group w-full inline-flex items-center justify-center gap-2 px-7 py-2.5
                               bg-primary-500 hover:bg-primary-600
                               text-white font-bold text-sm rounded-xl
                               shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40
                               transition-[background-color,color,transform,box-shadow] duration-300 hover:scale-[1.02] active:scale-[0.98]
                               ">
                        <span wire:loading.remove wire:target="register" class="flex items-center gap-2">
                             @lang('Create Account')
                             <svg class="w-4 h-4 transition-transform group-hover:translate-x-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                             </svg>
                        </span>
                        <span wire:loading wire:target="register" class="flex items-center gap-2">
                           <svg class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                               <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                               <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                           </svg>
                           @lang('Creating Account...')
                        </span>
                    </button>
                </form>

                {{-- Social Login --}}
                @php $socialProviders = getSocialProviders(); @endphp
                @if(count($socialProviders) > 0)
                    <div class="mt-6 flex items-center gap-4">
                        <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                        <span class="text-xs text-slate-500 dark:text-slate-400 uppercase tracking-widest font-medium">@lang('Or continue with')</span>
                        <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                    </div>
                    <div class="mt-5 grid grid-cols-1 sm:grid-cols-2 gap-3">
                        @foreach($socialProviders as $provider => $config)
                            <a href="{{ route('client.social.redirect', $provider) }}" class="flex items-center justify-center gap-2.5 h-11 rounded-xl bg-slate-900/5 dark:bg-white/5 hover:bg-slate-900/10 dark:hover:bg-white/10 border border-slate-200 dark:border-white/10 hover:border-slate-300 dark:hover:border-white/20 transition-[border-color,background-color] duration-300">
                                <i class="ph ph-bold {{ $config['icon'] }} text-base"></i>
                                <span class="text-sm font-medium text-slate-700 dark:text-slate-200">{{ $config['name'] }}</span>
                            </a>
                        @endforeach
                    </div>
                @endif

                <div class="mt-8 text-center">
                    <p class="text-slate-500 dark:text-slate-400 text-sm">
                        @lang('Already have an account?')
                        <a href="{{ route('client.login') }}" wire:navigate
                            class="text-primary-500 hover:text-primary-600 dark:text-primary-400 dark:hover:text-primary-300 font-semibold transition-colors">@lang('Sign In')</a>
                    </p>
                </div>
            </div>
        </div>
    </div>

    {{-- Right Panel - Branding (Hidden on Mobile) --}}
    <div class="hidden lg:flex lg:w-1/2 xl:w-2/5 relative items-center justify-center p-12">
        <div class="relative z-10 text-center">
            <div class="flex justify-center mb-8">
                <x-logo maxHeight="max-h-20" maxWidth="max-w-[280px]" containerClass="h-20 justify-center" imageClass="object-contain object-center" />
            </div>
            <h1 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold tracking-tight leading-tight text-slate-900 dark:text-white mb-5">
                @lang('Join the') <span
                    class="text-transparent bg-clip-text bg-gradient-to-r from-primary-500 via-primary-600 to-primary-800">{{ gs('site_name') ?? 'salieno' }}</span>
                @lang('Fleet')
            </h1>
            <p class="text-sm sm:text-base text-slate-600 dark:text-slate-400 leading-relaxed max-w-md mx-auto">
                @lang('Create your account and get access to enterprise-grade infrastructure in minutes.')
            </p>

            {{-- Features --}}
            <div class="mt-10 space-y-3 max-w-sm mx-auto text-left">
                @foreach(['Instant provisioning in 60 seconds', 'Free SSL certificates included', '24/7 expert support', '30-day money back guarantee'] as $feature)
                    <div class="flex items-center gap-3 text-slate-600 dark:text-slate-300">
                        <div class="w-5 h-5 rounded-full bg-primary-500/10 text-primary-600 flex items-center justify-center flex-shrink-0">
                            <svg class="w-3 h-3" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="3">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                        </div>
                        <span class="text-sm font-medium">{{ __($feature) }}</span>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>