@extends(activeTemplate() . 'layouts.frontend')

@section('content')
<div class="relative overflow-hidden pt-36 pb-32 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
    {{-- Artistic Background --}}
    <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-100"></div>
        <div class="absolute top-[5%] left-1/2 -translate-x-1/2 w-[800px] h-[600px] bg-primary-500/10 dark:bg-primary-500/20 rounded-full blur-[150px]"></div>
    </div>

    <div class="relative z-10 max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Navigation --}}
        <div class="flex items-center justify-between gap-6 mb-16">
            <nav class="flex items-center gap-3 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400 dark:text-slate-500">
                <a href="{{ route('blog.index') }}" class="hover:text-primary-500 transition-colors">@lang('Transmission Logs')</a>
                <i class="ph ph-bold ph-caret-right opacity-40"></i>
                <span class="text-slate-900 dark:text-white truncate">@lang('Article Detail')</span>
            </nav>

            <a href="{{ route('blog.index') }}" class="inline-flex items-center gap-2 text-[10px] font-black uppercase tracking-[0.2em] text-primary-500 hover:text-slate-900 dark:hover:text-white transition-[border-color,background-color,color,transform] group">
                <i class="ph ph-bold ph-arrow-left group-hover:-translate-x-1 transition-transform"></i>
                @lang('Back to Index')
            </a>
        </div>

        {{-- Article Content --}}
        <article class="bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 rounded-2xl overflow-hidden shadow-2xl shadow-slate-200/50 dark:shadow-none">
            @if(@$blog->data_values->image)
                <div class="aspect-video w-full overflow-hidden">
                    <img src="{{ getImage('assets/images/frontend/blog/' . @$blog->data_values->image) }}" 
                         alt="{{ __(@$blog->data_values->title) }}"
                         loading="lazy"
                         width="800" height="450"
                         class="w-full h-full object-cover">
                </div>
            @endif

            <div class="p-8 md:p-12 lg:p-16">
                <div class="flex items-center gap-4 text-[10px] font-black uppercase tracking-[0.3em] text-primary-500 mb-10">
                    <span class="flex h-2 w-2 relative">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-primary-400 opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-2 w-2 bg-primary-500"></span>
                    </span>
                    @lang('Mission Log') #{{ $blog->id }} // <time datetime="{{ $blog->created_at->toIso8601String() }}">{{ showDateTime($blog->created_at, 'd M Y') }}</time>
                </div>

                <h1 class="text-4xl sm:text-5xl font-extrabold text-slate-900 dark:text-white mb-12 tracking-tight leading-tight">
                    {{ __(@$blog->data_values->title) }}
                </h1>

                <div class="prose prose-slate dark:prose-invert max-w-none 
                    prose-headings:font-black prose-headings:tracking-tight 
                    prose-p:text-lg prose-p:leading-relaxed prose-p:font-medium
                    prose-a:text-primary-500 prose-a:font-bold hover:prose-a:text-primary-400
                    prose-strong:text-slate-900 dark:prose-strong:text-white">
                    {!! purify($blog->data_values->description) !!}
                </div>

                <div class="mt-12 pt-10 border-t border-slate-100 dark:border-white/10">
                    <div class="flex flex-wrap items-center justify-between gap-8">
                        <div class="flex items-center gap-4">
                            <span class="text-[10px] font-black uppercase tracking-widest text-slate-500 dark:text-slate-400">@lang('Share Logs'):</span>
                            <div class="flex gap-2">
                                <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" target="_blank" rel="noopener" aria-label="@lang('Share on Facebook')" class="w-10 h-10 rounded-xl bg-slate-50 dark:bg-white/5 flex items-center justify-center text-slate-500 dark:text-slate-400 hover:bg-primary-500 hover:text-white transition-colors">
                                    <i class="ph ph-bold ph-facebook-logo"></i>
                                </a>
                                <a href="https://twitter.com/intent/tweet?text={{ urlencode(__($blog->data_values->title)) }}&url={{ urlencode(url()->current()) }}" target="_blank" rel="noopener" aria-label="@lang('Share on Twitter')" class="w-10 h-10 rounded-xl bg-slate-50 dark:bg-white/5 flex items-center justify-center text-slate-500 dark:text-slate-400 hover:bg-primary-500 hover:text-white transition-colors">
                                    <i class="ph ph-bold ph-twitter-logo"></i>
                                </a>
                                <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode(url()->current()) }}" target="_blank" rel="noopener" aria-label="@lang('Share on LinkedIn')" class="w-10 h-10 rounded-xl bg-slate-50 dark:bg-white/5 flex items-center justify-center text-slate-500 dark:text-slate-400 hover:bg-primary-500 hover:text-white transition-colors">
                                    <i class="ph ph-bold ph-linkedin-logo"></i>
                                </a>
                            </div>
                        </div>
                        
                        <a href="{{ route('blog.index') }}" class="group inline-flex items-center gap-3 text-[10px] font-black uppercase tracking-[0.2em] text-primary-500">
                            <i class="ph ph-bold ph-arrow-left group-hover:-translate-x-1 transition-transform"></i>
                            @lang('Return to Command Center')
                        </a>
                    </div>
                </div>
            </div>
        </article>

        {{-- Recent Logs --}}
        @if($recentBlogs->count() > 0)
            <div class="mt-16">
                <div class="flex items-center gap-5 mb-16">
                    <div class="h-12 w-2 bg-primary-500 rounded-full shadow-lg shadow-primary-500/40"></div>
                    <h2 class="text-4xl font-black text-slate-900 dark:text-white tracking-tight uppercase">@lang('Related Segments')</h2>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    @foreach($recentBlogs as $recent)
                        <a href="{{ route('blog.details', [\Illuminate\Support\Str::slug(@$recent->data_values->title)]) }}" class="group p-6 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 hover:border-primary-500/30 transition-[border-color,background-color,color,transform] duration-500 shadow-xl shadow-slate-200/30 dark:shadow-none">
                            <div class="text-[10px] font-black uppercase tracking-widest text-primary-500 mb-4 opacity-60">
                                <time datetime="{{ $recent->created_at->toIso8601String() }}">{{ showDateTime($recent->created_at, 'd M Y') }}</time>
                            </div>
                            <h3 class="text-xl font-black text-slate-900 dark:text-white group-hover:text-primary-500 transition-colors tracking-tight mb-2 line-clamp-2">
                                {{ __(@$recent->data_values->title) }}
                            </h3>
                            <div class="flex items-center gap-2 text-[10px] font-black uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400 group-hover:text-primary-500 transition-colors">
                                @lang('View Log')
                                <i class="ph ph-bold ph-arrow-right group-hover:translate-x-1 transition-transform"></i>
                            </div>
                        </a>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>
@endsection
