@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative overflow-hidden pt-36 pb-32 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Background Effects --}}
        <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
            <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-100"></div>
            <div class="absolute top-[10%] right-[10%] w-[700px] h-[700px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[150px]"></div>
        </div>

        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Header --}}
            <div class="text-center max-w-3xl mx-auto mb-20">
                <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary-500/10 border border-primary-500/20 mb-8">
                    <span class="text-[10px] font-black uppercase tracking-[0.2em] text-primary-500">@lang('Company Feedback & News')</span>
                </div>
                <h1 class="text-4xl sm:text-5xl font-extrabold text-slate-900 dark:text-white mb-6 tracking-tight leading-tight">
                    {{ __($pageTitle) }}
                </h1>
                <p class="text-lg text-slate-500 dark:text-slate-400 font-medium">
                    @lang('Stay updated with our latest news, technical updates, and industry insights.')
                </p>
            </div>

            {{-- Blog Grid --}}
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @forelse($blogs as $blog)
                    <article class="group relative flex flex-col bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 rounded-2xl overflow-hidden hover:border-primary-500/30 transition-[border-color,background-color,color,transform] duration-500 hover:-translate-y-2 shadow-xl shadow-slate-200/30 dark:shadow-none">
                        @if(@$blog->data_values->image)
                            <div class="aspect-video overflow-hidden">
                                <img src="{{ getImage('assets/images/frontend/blog/' . @$blog->data_values->image) }}" 
                                     alt="{{ __(@$blog->data_values->title) }}"
                                     loading="lazy"
                                     width="640" height="360"
                                     class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-700">
                            </div>
                        @endif
                        
                        <div class="p-10 flex flex-col flex-1">
                            <div class="flex items-center gap-3 text-[10px] font-black uppercase tracking-widest text-slate-500 dark:text-slate-400 mb-6">
                                <i class="ph ph-bold ph-calendar text-primary-500"></i>
                                <time datetime="{{ @$blog->created_at->toIso8601String() }}">{{ showDateTime(@$blog->created_at, 'd M Y') }}</time>
                            </div>
                            
                            <h2 class="text-2xl font-black text-slate-900 dark:text-white mb-4 group-hover:text-primary-500 transition-colors leading-tight tracking-tight">
                                <a href="{{ route('blog.details', [\Illuminate\Support\Str::slug(@$blog->data_values->title)]) }}">
                                    {{ __(@$blog->data_values->title) }}
                                </a>
                            </h2>
                            
                            <p class="text-slate-500 dark:text-slate-400 text-sm font-medium mb-8 line-clamp-3">
                                @php echo strLimit(strip_tags($blog->data_values->description), 150) @endphp
                            </p>
                            
                            <div class="mt-auto">
                                <a href="{{ route('blog.details', [\Illuminate\Support\Str::slug(@$blog->data_values->title)]) }}" 
                                   class="inline-flex items-center gap-3 text-[10px] font-black uppercase tracking-[0.2em] text-primary-500 hover:text-slate-900 dark:hover:text-white transition-[border-color,background-color,color,transform] group/link px-6 py-2 rounded-full border border-primary-500/20 hover:bg-primary-500/20">
                                    @lang('Launch Article')
                                    <i class="ph ph-bold ph-arrow-right group-hover/link:translate-x-1 transition-transform"></i>
                                </a>
                            </div>
                        </div>
                    </article>
                @empty
                    <div class="col-span-full py-20 text-center">
                        <div class="w-20 h-20 mx-auto mb-8 bg-slate-100 dark:bg-white/5 rounded-2xl flex items-center justify-center text-slate-300">
                            <i class="ph ph-bold ph-newspaper text-5xl"></i>
                        </div>
                        <h3 class="text-2xl font-black text-slate-900 dark:text-white italic uppercase tracking-tight">@lang('No Transmission Found')</h3>
                        <p class="text-slate-500 dark:text-slate-400 italic">@lang('We haven\'t published any logs yet. Please check back later.')</p>
                    </div>
                @endforelse
            </div>

            {{-- Pagination --}}
            @if ($blogs->hasPages())
                <div class="mt-20 flex justify-center">
                    {{ $blogs->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection
