@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative pt-32 pb-24 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Animated Gradient Background --}}
        <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
            <div class="absolute top-[-10%] left-[-10%] w-[70vw] h-[70vw] max-w-[600px] max-h-[600px] rounded-full 
                        bg-gradient-to-br from-primary-500/10 dark:from-primary-500/20 via-primary-600/5 dark:via-primary-600/10 to-transparent 
                        blur-[100px] animate-blob"></div>
            <div class="absolute bottom-[-10%] right-[-10%] w-[50vw] h-[50vw] max-w-[500px] max-h-[500px] rounded-full 
                        bg-gradient-to-tl from-primary-500/5 dark:from-primary-500/10 via-primary-500/5 dark:via-primary-500/5 to-transparent 
                        blur-[80px] animate-blob" style="animation-delay: 2s;"></div>
            
            <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_50%_50%_at_50%_50%,black_40%,transparent_100%)]"></div>
        </div>

        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Header --}}
            <div class="text-center mb-12">
                <h1 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-3 tracking-tight leading-tight">
                    @lang('Finalize Your') 
                    <span class="bg-gradient-to-r from-primary-500 via-primary-600 to-primary-800 bg-clip-text text-transparent">
                        @lang('Order')
                    </span>
                </h1>
                <p class="text-slate-600 dark:text-slate-400 text-base max-w-2xl mx-auto">@lang('Review your billing information and choose a payment method to complete your purchase.')</p>
            </div>

            @if (session('success'))
                <div class="flex items-center gap-3 p-4 rounded-2xl bg-green-500/10 border border-green-500/20 text-green-600 dark:text-green-400 mb-8 animate-fade-in">
                    <i class="ph ph-bold ph-check-circle text-xl"></i>
                    <span class="font-bold text-sm">{{ session('success') }}</span>
                </div>
            @endif

            @if (session('error'))
                <div class="flex items-center gap-3 p-4 rounded-2xl bg-rose-500/10 border border-rose-500/20 text-rose-600 dark:text-rose-400 mb-8 animate-fade-in">
                    <i class="ph ph-bold ph-warning-circle text-xl"></i>
                    <span class="font-bold text-sm">{{ session('error') }}</span>
                </div>
            @endif

            @if ($errors->any())
                <div class="p-6 rounded-2xl bg-rose-500/10 border border-rose-500/20 text-rose-600 dark:text-rose-400 mb-8 animate-fade-in">
                    <div class="flex items-center gap-3 mb-2 font-bold uppercase tracking-widest text-xs">
                        <i class="ph ph-bold ph-warning-circle text-lg"></i>
                        @lang('Please fix the following errors')
                    </div>
                    <ul class="list-disc list-inside text-sm font-medium opacity-90">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-12 gap-8 items-start">
                {{-- Checkout Form --}}
                <div class="lg:col-span-8 space-y-6">
                    <form action="{{ route('user.checkout.process') }}" method="POST" id="checkoutForm">
                        @csrf

                        {{-- Billing Information --}}
                        <div class="group relative overflow-hidden rounded-[2rem] bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 shadow-xl shadow-slate-200/50 dark:shadow-none p-6 sm:p-10 transition-[border-color,background-color,opacity] duration-500">
                            <h2 class="text-lg font-bold text-slate-900 dark:text-white mb-6 flex items-center gap-3">
                                <span class="w-9 h-9 rounded-xl bg-primary-500/10 text-primary-600 flex items-center justify-center text-sm">
                                    <i class="ph ph-bold ph-user-circle"></i>
                                </span>
                                @lang('Billing Details')
                            </h2>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="space-y-2">
                                    <label class="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">@lang('First Name')</label>
                                    <div class="relative">
                                        <i class="ph ph-bold ph-user absolute left-4 top-1/2 -translate-y-1/2 text-slate-500 dark:text-slate-400"></i>
                                        <input type="text" value="{{ $user->firstname ?? '' }}" readonly
                                               class="w-full h-14 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl pl-12 pr-5 text-slate-900 dark:text-white font-bold text-sm focus:border-primary-500 focus:ring-0 transition-opacity opacity-70">
                                    </div>
                                </div>
                                <div class="space-y-2">
                                    <label class="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">@lang('Last Name')</label>
                                    <div class="relative">
                                        <i class="ph ph-bold ph-user absolute left-4 top-1/2 -translate-y-1/2 text-slate-500 dark:text-slate-400"></i>
                                        <input type="text" value="{{ $user->lastname ?? '' }}" readonly
                                               class="w-full h-14 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl pl-12 pr-5 text-slate-900 dark:text-white font-bold text-sm focus:border-primary-500 focus:ring-0 transition-opacity opacity-70">
                                    </div>
                                </div>
                                <div class="md:col-span-2 space-y-2">
                                    <label class="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">@lang('Email Address')</label>
                                    <div class="relative">
                                        <i class="ph ph-bold ph-envelope absolute left-4 top-1/2 -translate-y-1/2 text-slate-500 dark:text-slate-400"></i>
                                        <input type="email" value="{{ $user->email ?? '' }}" readonly
                                               class="w-full h-14 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl pl-12 pr-5 text-slate-900 dark:text-white font-bold text-sm focus:border-primary-500 focus:ring-0 transition-opacity opacity-70">
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Payment Method Selection --}}
                        <div class="rounded-[2rem] bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 shadow-xl shadow-slate-200/50 dark:shadow-none p-6 sm:p-10 transition-[background-color,border-color,color] mt-6"
                            x-data="{ 
                                uiMethod: 'balance', 
                                selectedGateway: '',
                                balance: {{ $user->balance ?? 0 }},
                                total: {{ $total }}
                            }">
                            <h2 class="text-lg font-bold text-slate-900 dark:text-white mb-6 flex items-center gap-3">
                                <span class="w-9 h-9 rounded-xl bg-primary-500/10 text-primary-600 flex items-center justify-center text-sm">
                                    <i class="ph ph-bold ph-credit-card"></i>
                                </span>
                                @lang('Payment Method')
                            </h2>

                            <input type="hidden" name="payment_method" :value="uiMethod === 'balance' ? 'balance' : 'gateway'">
                            
                            <div class="space-y-4">
                                {{-- Account Balance --}}
                                <label class="group relative flex items-center p-6 rounded-2xl border-2 cursor-pointer transition-[border-color,background-color,opacity] duration-300"
                                    :class="uiMethod === 'balance' ? 'border-primary-500 bg-primary-500/5 shadow-lg shadow-primary-500/10' : 'border-slate-100 dark:border-white/5 hover:border-primary-500/30 bg-slate-50 dark:bg-white/5 text-slate-500 dark:text-slate-400'">
                                    <input type="radio" x-model="uiMethod" value="balance" class="sr-only">
                                    <div class="flex items-center gap-4 flex-1">
                                        <div class="w-12 h-12 rounded-xl bg-primary-500/10 flex items-center justify-center text-primary-500 group-hover:scale-110 transition-transform">
                                            <i class="ph ph-bold ph-wallet text-2xl"></i>
                                        </div>
                                        <div>
                                            <span class="block text-slate-900 dark:text-white font-bold text-base">@lang('Account Balance')</span>
                                            <span class="block text-sm font-medium" :class="uiMethod === 'balance' ? 'text-primary-600' : 'text-slate-500 dark:text-slate-400'">@lang('Current'): {{ showAmount($user->balance ?? 0) }}</span>
                                        </div>
                                    </div>
                                    <div class="w-6 h-6 rounded-full border-2 flex items-center justify-center transition-colors"
                                        :class="uiMethod === 'balance' ? 'border-primary-500 bg-primary-500 text-white' : 'border-slate-200 dark:border-white/10'">
                                        <i x-show="uiMethod === 'balance'" class="ph ph-bold ph-check text-xs"></i>
                                    </div>
                                </label>

                                {{-- Online Payment --}}
                                <div class="space-y-4">
                                    <label class="group relative flex items-center p-6 rounded-2xl border-2 cursor-pointer transition-[border-color,background-color,opacity] duration-300"
                                        :class="uiMethod === 'gateway' ? 'border-primary-500 bg-primary-500/5 shadow-lg shadow-primary-500/10' : 'border-slate-100 dark:border-white/5 hover:border-primary-500/30 bg-slate-50 dark:bg-white/5 text-slate-500 dark:text-slate-400'">
                                        <input type="radio" x-model="uiMethod" value="gateway" class="sr-only">
                                        <div class="flex items-center gap-4 flex-1">
                                            <div class="w-12 h-12 rounded-xl bg-primary-500/10 flex items-center justify-center text-primary-500 group-hover:scale-110 transition-transform">
                                                <i class="ph ph-bold ph-lightning text-2xl"></i>
                                            </div>
                                            <div>
                                                <span class="block text-slate-900 dark:text-white font-bold text-base">@lang('Online Payment')</span>
                                                <span class="block text-sm font-medium" :class="uiMethod === 'gateway' ? 'text-primary-600' : 'text-slate-500 dark:text-slate-400'">@lang('Instant activation via card or crypto')</span>
                                            </div>
                                        </div>
                                        <div class="w-6 h-6 rounded-full border-2 flex items-center justify-center transition-colors"
                                            :class="uiMethod === 'gateway' ? 'border-primary-500 bg-primary-500 text-white' : 'border-slate-200 dark:border-white/10'">
                                            <i x-show="uiMethod === 'gateway'" class="ph ph-bold ph-check text-xs"></i>
                                        </div>
                                    </label>

                                    <div x-show="uiMethod === 'gateway'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 -translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" x-cloak 
                                         class="grid grid-cols-2 sm:grid-cols-4 gap-3 p-4 bg-slate-100 dark:bg-white/5 rounded-2xl border border-slate-200 dark:border-white/5">
                                        @foreach($automaticGateways ?? [] as $gateway)
                                            <label class="relative group cursor-pointer transition-[background-color,color,transform] active:scale-95">
                                                <input type="radio" name="gateway_code" value="{{ $gateway->code }}" x-model="selectedGateway" class="sr-only">
                                                <div class="p-4 rounded-xl border-2 transition-[border-color,background-color,box-shadow] duration-300 text-center flex flex-col items-center gap-2 group-hover:border-primary-500/50"
                                                    :class="selectedGateway == '{{ $gateway->code }}' ? 'border-primary-500 bg-white dark:bg-slate-900 shadow-xl' : 'border-slate-200 dark:border-white/5 bg-white/50 dark:bg-black/20'">
                                                    @if($gateway->image)
                                                        <img src="{{ getImage(getFilePath('gateway') . '/' . $gateway->image) }}" alt="{{ $gateway->name }}" loading="lazy" width="120" height="32" class="h-6 sm:h-8 object-contain">
                                                    @else
                                                        <span class="text-[10px] font-bold text-slate-900 dark:text-white uppercase truncate">{{ __($gateway->name) }}</span>
                                                    @endif
                                                </div>
                                            </label>
                                        @endforeach
                                    </div>
                                </div>

                                {{-- Offline Payment --}}
                                @if(isset($manualGateways) && count($manualGateways) > 0)
                                <div class="space-y-4">
                                    <label class="group relative flex items-center p-6 rounded-2xl border-2 cursor-pointer transition-[border-color,background-color,opacity] duration-300"
                                        :class="uiMethod === 'offline' ? 'border-primary-500 bg-primary-500/5 shadow-lg shadow-primary-500/10' : 'border-slate-100 dark:border-white/5 hover:border-primary-500/30 bg-slate-50 dark:bg-white/5 text-slate-500 dark:text-slate-400'">
                                        <input type="radio" x-model="uiMethod" value="offline" class="sr-only">
                                        <div class="flex items-center gap-4 flex-1">
                                            <div class="w-12 h-12 rounded-xl bg-purple-500/10 flex items-center justify-center text-purple-500 group-hover:scale-110 transition-transform">
                                                <i class="ph ph-bold ph-bank text-2xl"></i>
                                            </div>
                                            <div>
                                                <span class="block text-slate-900 dark:text-white font-bold text-base">@lang('Offline Payment')</span>
                                                <span class="block text-sm font-medium" :class="uiMethod === 'offline' ? 'text-primary-600' : 'text-slate-500 dark:text-slate-400'">@lang('Bank Transfer, M-Pesa, or Cash')</span>
                                            </div>
                                        </div>
                                        <div class="w-6 h-6 rounded-full border-2 flex items-center justify-center transition-colors"
                                            :class="uiMethod === 'offline' ? 'border-primary-500 bg-primary-500 text-white' : 'border-slate-200 dark:border-white/10'">
                                            <i x-show="uiMethod === 'offline'" class="ph ph-bold ph-check text-xs"></i>
                                        </div>
                                    </label>

                                    <div x-show="uiMethod === 'offline'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 -translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" x-cloak class="space-y-4">
                                        <div class="grid grid-cols-2 sm:grid-cols-4 gap-3 p-4 bg-slate-100 dark:bg-white/5 rounded-2xl border border-slate-200 dark:border-white/5">
                                            @foreach($manualGateways as $gateway)
                                                <label class="relative group cursor-pointer active:scale-95">
                                                    <input type="radio" name="gateway_code" value="{{ $gateway->code }}" x-model="selectedGateway" class="sr-only">
                                                    <div class="p-4 rounded-xl border-2 transition-[border-color,background-color,box-shadow] duration-300 text-center flex flex-col items-center gap-2 group-hover:border-primary-500/50"
                                                        :class="selectedGateway == '{{ $gateway->code }}' ? 'border-primary-500 bg-white dark:bg-slate-900 shadow-xl' : 'border-slate-200 dark:border-white/5 bg-white/50 dark:bg-black/20'">
                                                        @if($gateway->image)
                                                            <img src="{{ getImage(getFilePath('gateway') . '/' . $gateway->image) }}" alt="{{ $gateway->name }}" loading="lazy" width="120" height="32" class="h-6 sm:h-8 object-contain">
                                                        @else
                                                            <span class="text-[10px] font-bold text-slate-900 dark:text-white uppercase truncate">{{ __($gateway->name) }}</span>
                                                        @endif
                                                    </div>
                                                </label>
                                            @endforeach
                                        </div>

                                        @foreach($manualGateways as $gateway)
                                            <div x-show="selectedGateway == '{{ $gateway->code }}'" x-transition 
                                                 class="p-6 rounded-2xl bg-primary-500/5 border border-primary-500/20 text-sm text-slate-600 dark:text-slate-400 leading-relaxed shadow-inner">
                                                <div class="flex items-center gap-2 text-primary-600 dark:text-primary-400 font-bold mb-3 uppercase tracking-widest text-[10px]">
                                                    <i class="ph ph-bold ph-info text-base"></i>
                                                    @lang('Manual Payment Instructions')
                                                </div>
                                                <div class="prose prose-sm prose-slate dark:prose-invert max-w-none">
                                                    {!! purify($gateway->description) !!}
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </form>
                </div>

                {{-- Sidebar Summary --}}
                <div class="lg:col-span-4 lg:sticky lg:top-32">
                    <div class="absolute -inset-4 bg-gradient-to-r from-primary-500/10 dark:from-primary-500/20 via-primary-500/5 dark:via-primary-500/10 to-primary-500/10 dark:to-primary-500/20 rounded-[2rem] blur-2xl opacity-60 pointer-events-none"></div>

                    <div class="relative overflow-hidden rounded-[2rem] bg-white dark:bg-slate-900/80 backdrop-blur-xl border border-slate-200 dark:border-white/10 shadow-2xl shadow-slate-200/50 dark:shadow-none p-6">
                        {{-- Header --}}
                        <div class="mb-6">
                            <h3 class="text-sm font-bold text-slate-900 dark:text-white mb-2 text-center uppercase tracking-[0.2em]">@lang('Order Summary')</h3>
                            <div class="w-10 h-0.5 bg-primary-500 mx-auto rounded-full"></div>
                        </div>

                        <div class="space-y-3 mb-6">
                            @foreach($items as $item)
                                <div class="p-4 rounded-xl bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5">
                                    <div class="flex justify-between items-start mb-1">
                                        <span class="text-slate-900 dark:text-white font-bold text-sm tracking-tight">{{ $item['title'] ?? 'Item' }}</span>
                                        <span class="text-slate-900 dark:text-white font-bold text-sm">{{ showAmount($item['unit_price'] * $item['quantity']) }}</span>
                                    </div>
                                    <div class="flex justify-between items-center">
                                        <span class="text-slate-500 dark:text-slate-400 text-[10px] font-bold uppercase tracking-widest">{{ __($item['billing_cycle']) }}</span>
                                        @if(($item['setup_fee'] ?? 0) > 0)
                                            <span class="text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase">Setup: {{ showAmount($item['setup_fee']) }}</span>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        @php
                            $originalSubtotal = collect($items)->map(function($item) {
                                $base = ($item['original_price'] ?? ($item['unit_price'] ?? 0)) * ($item['quantity'] ?? 1);
                                $setup = ($item['setup_fee'] ?? 0);
                                $idProt = (isset($item['id_protection']) && $item['id_protection'] === true) ? (float) ($item['id_protection_price'] ?? 0) : 0;
                                
                                $addonTotal = 0;
                                if (!empty($item['addons'])) {
                                    foreach ($item['addons'] as $addon) {
                                        $addonTotal += ($addon['price'] ?? 0) + ($addon['setup_fee'] ?? 0);
                                    }
                                }

                                return $base + $setup + $idProt + $addonTotal;
                            })->sum();

                            $productDiscountTotal = collect($items)->filter(function($item) {
                                return ($item['has_discount'] ?? false) && ($item['type'] ?? '') === 'product';
                            })->map(function($item) {
                                return (($item['original_price'] ?? 0) - ($item['unit_price'] ?? 0)) * ($item['quantity'] ?? 1);
                            })->sum();
                            
                            $coupon = session('coupon');
                            $couponDiscountTotal = 0;
                            if ($coupon) {
                                foreach($items as $item) {
                                    if (($item['type'] ?? '') === 'product') {
                                        $product = \App\Models\Product::find($item['item_id']);
                                        if ($product && (empty($coupon->products) || in_array($product->id, $coupon->products))) {
                                            $basePrice = ($item['unit_price'] ?? 0) * ($item['quantity'] ?? 1);
                                            $couponDiscountTotal += $coupon->calculateDiscount($basePrice);
                                        }
                                    }
                                }
                            }
                        @endphp

                        <div class="pt-6 border-t border-slate-200 dark:border-white/10 mb-6 space-y-3 text-xs font-bold uppercase tracking-widest">
                            <div class="flex justify-between items-center">
                                <span class="text-slate-500 dark:text-slate-400">@lang('Subtotal')</span>
                                <span class="text-slate-900 dark:text-white">{{ showAmount($originalSubtotal) }}</span>
                            </div>

                            @if($productDiscountTotal > 0)
                                <div class="flex justify-between items-center text-green-500">
                                    <span>@lang('Discount')</span>
                                    <span>-{{ showAmount($productDiscountTotal) }}</span>
                                </div>
                            @endif

                            {{-- Applied Coupon --}}
                            @if($coupon && $couponDiscountTotal > 0)
                                <div class="flex justify-between items-center text-primary-500">
                                    <div class="flex items-center gap-2">
                                        <span>@lang('Promo Discount')</span>
                                        <span class="text-[10px] bg-primary-500/10 px-2 py-0.5 rounded text-primary-600">{{ $coupon->code }}</span>
                                    </div>
                                    <span>-{{ showAmount($couponDiscountTotal) }}</span>
                                </div>
                            @endif

                            <div class="pt-4 border-t border-slate-200 dark:border-white/10">
                                <div class="flex justify-between items-center mb-1">
                                    <span class="text-slate-500 dark:text-slate-400 font-bold text-[10px] uppercase tracking-[0.2em]">@lang('Grand Total')</span>
                                    <span class="text-primary-500 font-bold text-[10px] uppercase tracking-widest">@lang('Live')</span>
                                </div>
                                <div class="flex items-baseline gap-0.5">
                                    <span class="text-3xl font-bold text-slate-900 dark:text-white tracking-tighter">{{ showAmount($total) }}</span>
                                </div>
                            </div>
                        </div>

                        <button type="submit" form="checkoutForm"
                                x-data="{ busy: false }" @click="busy = true"
                                :class="busy ? 'opacity-70 pointer-events-none' : ''"
                                class="group w-full inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-6 py-3 text-sm">
                            <span x-show="!busy">@lang('Place Order')</span>
                            <i x-show="!busy" class="ph ph-bold ph-lock-key group-hover:translate-x-1 transition-transform"></i>
                            <i x-show="busy" class="ph ph-spinner animate-spin text-2xl"></i>
                        </button>

                        <a href="{{ route('shopping.cart.index') }}" 
                           class="flex items-center justify-center gap-2 mt-6 text-slate-500 dark:text-slate-400 hover:text-primary-600 dark:hover:text-white text-[10px] font-bold uppercase tracking-[0.2em] transition-colors">
                            <i class="ph ph-arrow-left"></i>
                            @lang('Modify Cart')
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection