@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative pt-28 sm:pt-36 pb-16 sm:pb-24 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Background --}}
        <div class="absolute inset-0 pointer-events-none">
            <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-30">
            </div>
            <div class="absolute top-1/4 left-1/2 -translate-x-1/2 w-[600px] h-[600px] bg-green-600/10 rounded-full blur-[120px]">
            </div>
        </div>

        <div class="relative z-10 max-w-3xl mx-auto px-4 sm:px-6">

            {{-- Success Header --}}
            <div class="text-center mb-8 sm:mb-10">
                <div class="w-16 h-16 sm:w-20 sm:h-20 mx-auto mb-5 rounded-full bg-green-500/15 border border-green-500/20 flex items-center justify-center">
                    <i class="ph-fill ph-check-circle text-3xl sm:text-4xl text-green-500 dark:text-green-400"></i>
                </div>
                <h1 class="text-2xl sm:text-3xl font-extrabold text-slate-900 dark:text-white mb-2 tracking-tight">
                    @lang('Order Confirmed!')
                </h1>
                <p class="text-sm sm:text-base text-green-600 dark:text-green-400 font-medium">
                    @lang('Thank you for your order. Your order has been successfully placed.')
                </p>
            </div>

            {{-- Order & Invoice Summary --}}
            <div class="rounded-2xl bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 overflow-hidden shadow-lg shadow-slate-200/50 dark:shadow-none mb-6 transition-[border-color,background-color,box-shadow] duration-300">
                <div class="grid grid-cols-1 sm:grid-cols-2 divide-y sm:divide-y-0 sm:divide-x divide-slate-100 dark:divide-white/10">
                    {{-- Order Details --}}
                    <div class="p-5 sm:p-6">
                        <h2 class="text-xs font-bold uppercase tracking-widest text-slate-400 dark:text-slate-500 mb-4">@lang('Order Details')</h2>
                        <div class="space-y-3">
                            <div class="flex items-center justify-between gap-3">
                                <span class="text-sm text-slate-500 dark:text-slate-400 shrink-0">@lang('Order ID')</span>
                                <span class="text-sm text-slate-900 dark:text-white font-semibold">#{{ $order->id }}</span>
                            </div>
                            <div class="flex items-center justify-between gap-3">
                                <span class="text-sm text-slate-500 dark:text-slate-400 shrink-0">@lang('Date')</span>
                                <span class="text-sm text-slate-900 dark:text-white font-medium">{{ $order->created_at->format('M d, Y') }}</span>
                            </div>
                            <div class="flex items-center justify-between gap-3">
                                <span class="text-sm text-slate-500 dark:text-slate-400 shrink-0">@lang('Status')</span>
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-bold rounded-full {{ $order->status == \App\Models\Order::STATUS_ACTIVE ? 'bg-green-500/15 text-green-600 dark:text-green-400' : 'bg-amber-500/15 text-amber-600 dark:text-amber-400' }}">
                                    <span class="w-1.5 h-1.5 rounded-full {{ $order->status == \App\Models\Order::STATUS_ACTIVE ? 'bg-green-500' : 'bg-amber-500' }}"></span>
                                    {{ $order->status_label }}
                                </span>
                            </div>
                        </div>
                    </div>

                    {{-- Invoice Details --}}
                    <div class="p-5 sm:p-6">
                        <h2 class="text-xs font-bold uppercase tracking-widest text-slate-400 dark:text-slate-500 mb-4">@lang('Invoice')</h2>
                        <div class="space-y-3">
                            <div class="flex items-center justify-between gap-3">
                                <span class="text-sm text-slate-500 dark:text-slate-400 shrink-0">@lang('Invoice No.')</span>
                                <span class="text-sm text-slate-900 dark:text-white font-semibold">{{ $invoice->invoice_number }}</span>
                            </div>
                            <div class="flex items-center justify-between gap-3">
                                <span class="text-sm text-slate-500 dark:text-slate-400 shrink-0">@lang('Amount')</span>
                                <span class="text-sm text-slate-900 dark:text-white font-bold">{{ showAmount($invoice->amount) }}</span>
                            </div>
                            <div class="flex items-center justify-between gap-3">
                                <span class="text-sm text-slate-500 dark:text-slate-400 shrink-0">@lang('Payment')</span>
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-bold rounded-full {{ $invoice->status == \App\Models\Invoice::STATUS_PAID ? 'bg-green-500/15 text-green-600 dark:text-green-400' : 'bg-amber-500/15 text-amber-600 dark:text-amber-400' }}">
                                    <span class="w-1.5 h-1.5 rounded-full {{ $invoice->status == \App\Models\Invoice::STATUS_PAID ? 'bg-green-500' : 'bg-amber-500' }}"></span>
                                    {{ $invoice->status_label }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Order Items --}}
            <div class="rounded-2xl bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 overflow-hidden shadow-lg shadow-slate-200/50 dark:shadow-none mb-6 transition-[border-color,background-color,box-shadow] duration-300">
                <div class="px-5 sm:px-6 py-4 border-b border-slate-100 dark:border-white/10">
                    <h2 class="text-xs font-bold uppercase tracking-widest text-slate-400 dark:text-slate-500">@lang('Order Items')</h2>
                </div>
                <div class="divide-y divide-slate-100 dark:divide-white/10">
                    @foreach($invoice->items as $item)
                        <div class="px-5 sm:px-6 py-4 flex items-start justify-between gap-4">
                            <div class="min-w-0 flex-1">
                                <h3 class="text-sm font-semibold text-slate-900 dark:text-white truncate">{{ $item->description }}</h3>
                                <p class="text-xs text-slate-500 dark:text-slate-400 mt-0.5">@lang('Qty'): {{ $item->quantity }}</p>
                            </div>
                            <span class="text-sm text-slate-900 dark:text-white font-bold shrink-0">{{ showAmount($item->amount) }}</span>
                        </div>
                    @endforeach
                </div>
                <div class="px-5 sm:px-6 py-4 bg-slate-50 dark:bg-white/[0.02] border-t border-slate-200 dark:border-white/10">
                    <div class="flex items-center justify-between">
                        <span class="text-sm font-bold text-slate-900 dark:text-white">@lang('Total')</span>
                        <span class="text-lg font-extrabold text-primary-600 dark:text-primary-400">{{ showAmount($invoice->amount) }}</span>
                    </div>
                </div>
            </div>

            {{-- Services --}}
            @if($order->hostings->count() > 0)
                <div class="rounded-2xl bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 overflow-hidden shadow-lg shadow-slate-200/50 dark:shadow-none mb-8 transition-[border-color,background-color,box-shadow] duration-300">
                    <div class="px-5 sm:px-6 py-4 border-b border-slate-100 dark:border-white/10">
                        <h2 class="text-xs font-bold uppercase tracking-widest text-slate-400 dark:text-slate-500">@lang('Services')</h2>
                    </div>
                    <div class="divide-y divide-slate-100 dark:divide-white/10">
                        @foreach($order->hostings as $hosting)
                            <div class="px-5 sm:px-6 py-4 flex items-start justify-between gap-4">
                                <div class="min-w-0 flex-1">
                                    <h3 class="text-sm font-semibold text-slate-900 dark:text-white">{{ $hosting->product->name ?? 'Service' }}</h3>
                                    @if($hosting->domain)
                                        <p class="text-xs text-primary-600 dark:text-primary-400 mt-0.5 truncate">{{ $hosting->domain }}</p>
                                    @endif
                                    <p class="text-xs text-slate-400 dark:text-slate-500 capitalize mt-0.5">{{ str_replace('_', ' ', $hosting->billing_cycle) }}</p>
                                </div>
                                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 text-xs font-bold rounded-full shrink-0 {{ $hosting->status == \App\Models\Hosting::STATUS_ACTIVE ? 'bg-green-500/15 text-green-600 dark:text-green-400' : 'bg-amber-500/15 text-amber-600 dark:text-amber-400' }}">
                                    <span class="w-1.5 h-1.5 rounded-full {{ $hosting->status == \App\Models\Hosting::STATUS_ACTIVE ? 'bg-green-500' : 'bg-amber-500' }}"></span>
                                    {{ $hosting->status_label }}
                                </span>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            {{-- Actions --}}
            <div class="flex flex-col sm:flex-row gap-3 justify-center">
                @if($invoice->status != \App\Models\Invoice::STATUS_PAID)
                    <x-theme.btn-primary href="{{ route('client.invoices.show', $invoice->id) }}">
                        <i class="ph ph-credit-card mr-1.5"></i>
                        @lang('Pay Now')
                    </x-theme.btn-primary>
                @endif

                <x-theme.btn-secondary href="{{ route('client.home') }}">
                    <i class="ph ph-house mr-1.5"></i>
                    @lang('Go to Dashboard')
                </x-theme.btn-secondary>

                <x-theme.btn-secondary href="{{ route('products.index') }}">
                    <i class="ph ph-shopping-cart mr-1.5"></i>
                    @lang('Continue Shopping')
                </x-theme.btn-secondary>
            </div>
        </div>
    </div>
@endsection