@extends(activeTemplate() . 'layouts.frontend')

@section('content')
<div class="relative pt-32 pb-24 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300" x-data="cartPage()">
    {{-- Animated Gradient Background --}}
    <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
        <div class="absolute top-[-10%] left-[-10%] w-[70vw] h-[70vw] max-w-[600px] max-h-[600px] rounded-full 
                    bg-gradient-to-br from-primary-500/10 dark:from-primary-500/20 via-primary-600/5 dark:via-primary-600/10 to-transparent 
                    blur-[100px] animate-blob"></div>
        <div class="absolute bottom-[-10%] right-[-10%] w-[50vw] h-[50vw] max-w-[500px] max-h-[500px] rounded-full 
                    bg-gradient-to-tl from-primary-500/5 dark:from-primary-500/10 via-primary-500/5 dark:via-primary-500/5 to-transparent 
                    blur-[80px] animate-blob" style="animation-delay: 2s;"></div>
        
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_50%_50%_at_50%_50%,black_40%,transparent_100%)]"></div>
    </div>

    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Header --}}
        <div class="text-center mb-12">
            <h1 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-3 tracking-tight leading-tight">
                @lang('Review Your') 
                <span class="bg-gradient-to-r from-primary-500 via-primary-600 to-primary-800 bg-clip-text text-transparent">
                    @lang('Shopping Cart')
                </span>
            </h1>
            <p class="text-slate-600 dark:text-slate-400 text-base max-w-2xl mx-auto">@lang('Review your selected services and domains before proceeding to checkout.')</p>
        </div>

        @if(session('cart') && count(session('cart')) > 0)
            <div class="grid lg:grid-cols-3 gap-8">
                
                {{-- Cart Items --}}
                <div class="lg:col-span-2 space-y-4">
                    @foreach(session('cart') as $item)
                        <div class="group relative flex flex-col sm:flex-row items-start sm:items-center justify-between gap-6 p-8 rounded-[2rem] bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 shadow-xl shadow-slate-200/50 dark:shadow-none transition-[border-color,background-color,box-shadow] duration-500
                            {{ ($item['type'] === 'domain' && isset($item['required_by'])) ? 'border-l-4 border-l-primary-500' : '' }}">
                            
                            <div class="flex items-center gap-6 flex-1 min-w-0">
                                {{-- Icon --}}
                                <div class="w-12 h-12 rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform duration-500 shadow-inner">
                                    @if($item['type'] === 'domain')
                                        <i class="ph ph-bold ph-globe text-2xl text-primary-500"></i>
                                    @else
                                        <i class="ph ph-bold ph-lightning text-2xl text-primary-500"></i>
                                    @endif
                                </div>

                                <div class="min-w-0 flex-1">
                                    <div class="flex items-center gap-3 flex-wrap mb-1">
                                        <h4 class="text-slate-900 dark:text-white font-bold text-base tracking-tight truncate">{{ $item['title'] ?? 'Product' }}</h4>
                                        
                                        @if(($item['has_discount'] ?? false) && $item['type'] === 'product')
                                            <span class="inline-flex items-center px-2.5 py-1 rounded-full text-[10px] font-bold uppercase tracking-widest bg-green-500/10 text-green-600 dark:text-green-400 border border-green-500/20">
                                                {{ $item['discount_percentage'] }}% OFF
                                            </span>
                                        @endif
                                    </div>

                                    <div class="flex flex-col gap-2mt-1">
                                        <p class="text-slate-500 dark:text-slate-400 text-[10px] font-bold uppercase tracking-widest">{{ __($item['billing_cycle'] ?? 'Monthly') }} @lang('Billing')</p>
                                        
                                        <div class="flex flex-wrap gap-2 mt-2">
                                            @if($item['type'] === 'domain' && isset($item['required_by']))
                                                @php
                                                    $linkedService = collect(session('cart'))->firstWhere('id', $item['required_by']);
                                                @endphp
                                                @if($linkedService)
                                                    <span class="inline-flex items-center gap-1.5 px-3 py-1 rounded-lg bg-primary-500/5 border border-primary-500/10 text-primary-600 dark:text-primary-400 text-[10px] font-bold uppercase tracking-tight">
                                                        <i class="ph ph-bold ph-link-simple"></i>
                                                        @lang('Linked'): {{ $linkedService['title'] }}
                                                    </span>
                                                @endif
                                            @endif
                                            
                                            @if($item['type'] === 'product' && isset($item['domain']))
                                                <span class="inline-flex items-center gap-1.5 px-3 py-1 rounded-lg bg-slate-100 dark:bg-white/5 border border-slate-200 dark:border-white/5 text-slate-600 dark:text-slate-300 text-[10px] font-bold uppercase tracking-tight">
                                                    <i class="ph ph-bold ph-globe"></i>
                                                    {{ $item['domain'] }}
                                                </span>
                                            @endif
                                        </div>

                                        {{-- ID Protection Mini Toggle --}}
                                        @if($item['type'] === 'domain' && isset($item['id_protection']))
                                            @php
                                                $domainSetup = \App\Models\DomainSetup::find($item['item_id']);
                                                $idpPrice = $domainSetup?->pricing->one_year_id_protection ?? 0;
                                            @endphp

                                            @if($idpPrice > 0)
                                            <div class="mt-4 pt-4 border-t border-slate-100 dark:border-white/5 flex items-center justify-between">
                                                <div class="flex items-center gap-2 text-primary-600">
                                                    <i class="ph ph-bold ph-shield-check text-lg"></i>
                                                    <span class="text-[10px] font-bold uppercase tracking-widest">WHOIS @lang('Privacy Protection')</span>
                                                </div>
                                                
                                                <div class="flex items-center gap-4">
                                                    <span class="text-[10px] font-bold text-slate-500 dark:text-slate-400">+{{ gs('cur_sym') }}{{ number_format($idpPrice, 2) }}</span>
                                                    <button type="button" 
                                                            @click="toggleIdProtection('{{ $item['id'] }}')"
                                                            :disabled="processingIdP === '{{ $item['id'] }}'"
                                                            class="relative inline-flex items-center h-6 w-11 rounded-full transition-colors focus:outline-none ring-4 ring-slate-100 dark:ring-white/5"
                                                            :class="'{{ $item['id_protection'] }}' == '1' ? 'bg-primary-500' : 'bg-slate-200 dark:bg-white/10'">
                                                        <span class="inline-block w-4 h-4 transform bg-white rounded-full transition-transform shadow-md"
                                                              :class="'{{ $item['id_protection'] }}' == '1' ? 'translate-x-6' : 'translate-x-1'"></span>
                                                        <span x-show="processingIdP === '{{ $item['id'] }}'" class="absolute inset-0 flex items-center justify-center">
                                                            <i class="ph ph-spinner animate-spin text-white"></i>
                                                        </span>
                                                    </button>
                                                </div>
                                            </div>
                                            @endif
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="flex items-center gap-8 w-full sm:w-auto mt-4 sm:mt-0 pt-4 sm:pt-0 border-t sm:border-t-0 border-slate-100 dark:border-white/5">
                                <div class="text-right flex-1 sm:flex-initial">
                                    @if(($item['has_discount'] ?? false) && $item['type'] === 'product')
                                        <div class="text-xs text-slate-500 dark:text-slate-400 line-through font-bold mb-0.5">{{ gs('cur_sym') }}{{ number_format($item['original_price'] ?? 0, 2) }}</div>
                                        <span class="text-xl font-bold text-green-500 tracking-tighter">{{ gs('cur_sym') }}{{ number_format($item['unit_price'] ?? 0, 2) }}</span>
                                    @else
                                        <span class="text-xl font-bold text-slate-900 dark:text-white tracking-tighter">{{ gs('cur_sym') }}{{ number_format($item['unit_price'] ?? 0, 2) }}</span>
                                    @endif
                                    <span class="block text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase tracking-widest mt-0.5">@lang('Subtotal')</span>
                                </div>
                                <a href="{{ route('shopping.cart.remove', $item['id']) }}" 
                                   class="w-10 h-10 rounded-xl flex items-center justify-center bg-slate-100 dark:bg-white/5 text-slate-500 dark:text-slate-400 hover:bg-rose-500/10 hover:text-rose-500 transition-[border-color,background-color,opacity] duration-300 active:scale-90" 
                                   title="@lang('Remove')"
                                   @if($item['type'] === 'domain' && isset($item['required_by']))
                                       onclick="return confirm('@lang('Removing this domain will also remove the linked service. Continue?')')"
                                   @endif>
                                    <i class="ph ph-bold ph-trash text-lg"></i>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>

                {{-- Order Summary Sidebar --}}
                <div class="lg:col-span-1">
                    <div class="sticky top-32">
                        {{-- Card Decoration Glow --}}
                        <div class="absolute -inset-4 bg-gradient-to-r from-primary-500/10 dark:from-primary-500/20 via-primary-500/5 dark:via-primary-500/10 to-primary-500/10 dark:to-primary-500/20 rounded-[2rem] blur-2xl opacity-60 pointer-events-none"></div>

                        <div class="relative overflow-hidden rounded-[2rem] bg-white dark:bg-slate-900/80 backdrop-blur-xl border border-slate-200 dark:border-white/10 shadow-2xl shadow-slate-200/50 dark:shadow-none p-6 transition-[border-color,background-color,box-shadow] duration-500">
                            
                            {{-- Header --}}
                            <div class="mb-6">
                                <h3 class="text-sm font-bold text-slate-900 dark:text-white mb-2 text-center uppercase tracking-[0.2em]">@lang('Total Summary')</h3>
                                <div class="w-10 h-0.5 bg-primary-500 mx-auto rounded-full"></div>
                            </div>
                            @php
                                $originalSubtotal = collect(session('cart'))->map(function($item) {
                                    $base = ($item['original_price'] ?? ($item['unit_price'] ?? 0)) * ($item['quantity'] ?? 1);
                                    $setup = ($item['setup_fee'] ?? 0);
                                    $idProt = (isset($item['id_protection']) && $item['id_protection'] === true) ? (float) ($item['id_protection_price'] ?? 0) : 0;
                                    
                                    $addonTotal = 0;
                                    if (!empty($item['addons'])) {
                                        foreach ($item['addons'] as $addon) {
                                            $addonTotal += ($addon['price'] ?? 0) + ($addon['setup_fee'] ?? 0);
                                        }
                                    }

                                    return $base + $setup + $idProt + $addonTotal;
                                })->sum();
                                
                                $totalProductDiscount = collect(session('cart'))->filter(function($item) {
                                    return ($item['has_discount'] ?? false) && $item['type'] === 'product';
                                })->map(function($item) {
                                    return (($item['original_price'] ?? 0) - ($item['unit_price'] ?? 0)) * ($item['quantity'] ?? 1);
                                })->sum();
                            @endphp

                            <div class="space-y-3 mb-6">
                                <div class="flex justify-between items-center text-xs font-bold uppercase tracking-widest">
                                    <span class="text-slate-500 dark:text-slate-400">@lang('Subtotal')</span>
                                    <span class="text-slate-900 dark:text-white">{{ gs('cur_sym') }}{{ number_format($originalSubtotal, 2) }}</span>
                                </div>
                                @if($totalProductDiscount > 0)
                                    <div class="flex justify-between items-center text-xs font-bold uppercase tracking-widest text-green-500">
                                        <span>@lang('Discount')</span>
                                        <span>-{{ gs('cur_sym') }}{{ number_format($totalProductDiscount, 2) }}</span>
                                    </div>
                                @endif

                            {{-- Coupon Section --}}
                            <div class="pt-4 border-t border-slate-100 dark:border-white/5 space-y-4">
                                @if(session('coupon'))
                                    <div class="flex items-center justify-between p-3 rounded-xl bg-green-500/10 border border-green-500/20">
                                        <div class="flex items-center gap-2">
                                            <i class="ph ph-bold ph-ticket text-green-500"></i>
                                            <span class="text-[10px] font-bold text-green-600 dark:text-green-400 uppercase tracking-widest">{{ session('coupon')->code }}</span>
                                        </div>
                                        <a href="{{ route('shopping.cart.remove-coupon') }}" class="text-rose-500 hover:text-rose-600 transition-colors">
                                            <i class="ph ph-bold ph-x-circle text-lg"></i>
                                        </a>
                                    </div>
                                    @php
                                        // Re-calculate total with coupon if not already done by controller
                                        $coupon = session('coupon');
                                        $couponDiscount = 0;
                                        foreach(session('cart') as $item) {
                                            if ($item['type'] === 'product') {
                                                $product = \App\Models\Product::find($item['item_id']);
                                                if ($product && (empty($coupon->products) || in_array($product->id, $coupon->products))) {
                                                    // Base price for coupon calculation should be the unit price after product-specific discounts
                                                    $basePrice = ($item['unit_price'] ?? 0) * ($item['quantity'] ?? 1);
                                                    $couponDiscount += $coupon->calculateDiscount($basePrice);
                                                }
                                            }
                                        }
                                    @endphp
                                    @if($couponDiscount > 0)
                                         <div class="flex justify-between items-center text-xs font-bold uppercase tracking-widest text-primary-500">
                                             <span>@lang('Promo Discount')</span>
                                             <span>-{{ gs('cur_sym') }}{{ number_format($couponDiscount, 2) }}</span>
                                         </div>
                                    @endif
                                @else
                                    <form action="{{ route('shopping.cart.apply-coupon') }}" method="POST" class="relative group">
                                        @csrf
                                        <input type="text" name="coupon_code" placeholder="@lang('Promo Code')" required
                                               class="w-full h-12 bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 rounded-xl pl-4 pr-12 text-xs font-bold uppercase tracking-widest focus:border-primary-500 focus:ring-0 transition-[border-color,background-color,color]">
                                        <button type="submit" class="absolute right-2 top-1/2 -translate-y-1/2 w-8 h-8 rounded-lg bg-primary-500 text-white flex items-center justify-center hover:bg-primary-600 transition-[background-color,color,transform] active:scale-95">
                                            <i class="ph ph-bold ph-arrow-right"></i>
                                        </button>
                                    </form>
                                @endif
                                <div class="flex justify-between items-center text-xs font-bold uppercase tracking-widest">
                                    <span class="text-slate-500 dark:text-slate-400">@lang('Taxes')</span>
                                    <span class="text-slate-900 dark:text-white">{{ gs('cur_sym') }}0.00</span>
                                </div>
                            </div>

                            <div class="pt-5 border-t border-slate-200 dark:border-white/10 mb-6">
                                <div class="flex justify-between items-center mb-1">
                                    <span class="text-slate-500 dark:text-slate-400 font-bold text-[10px] uppercase tracking-[0.2em]">@lang('Grand Total')</span>
                                    <span class="text-primary-500 font-bold text-[10px] uppercase tracking-widest">@lang('Live')</span>
                                </div>
                                <div class="flex items-baseline gap-0.5">
                                    <span class="text-slate-500 dark:text-slate-400 dark:text-white/60 font-bold text-lg">{{ gs('cur_sym') }}</span>
                                    <span class="text-3xl font-bold text-slate-900 dark:text-white tracking-tighter">{{ number_format($total, 2) }}</span>
                                </div>
                            </div>

                            {{-- Checkout Button --}}
                            <x-theme.btn-primary href="{{ route('user.checkout') }}" full size="lg">
                                @lang('Proceed to Checkout')
                            </x-theme.btn-primary>

                            <p class="text-center text-[10px] text-slate-400 dark:text-slate-500 mt-6 font-bold uppercase tracking-[0.2em] flex items-center justify-center gap-2">
                                <i class="ph ph-bold ph-lock-key text-green-500 text-sm"></i> @lang('SSL SECURED CHECKOUT')
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        @else
            {{-- Empty Cart --}}
            <div class="relative overflow-hidden rounded-2xl bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 p-10 sm:p-16 text-center shadow-xl shadow-slate-200/50 dark:shadow-none animate-fade-in">
                <div class="absolute inset-0 bg-gradient-to-b from-primary-500/5 to-transparent pointer-events-none"></div>
                
                <div class="relative z-10">
                    <div class="w-28 h-28 mx-auto mb-10 rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 flex items-center justify-center shadow-inner group">
                        <i class="ph ph-shopping-cart-simple text-6xl text-slate-300 dark:text-slate-600 group-hover:scale-110 transition-transform duration-500"></i>
                    </div>
                    
                    <h2 class="text-2xl sm:text-3xl font-black text-slate-900 dark:text-white mb-4 tracking-tight">@lang('Your Cart is Empty')</h2>
                    <p class="text-slate-600 dark:text-slate-400 mb-10 max-w-md mx-auto font-medium text-sm">@lang('Looks like you haven\'t added any items to your cart yet. Explore our top-tier performance plans to get started.')</p>
                    
                    <x-theme.btn-primary href="{{ route('pricing') }}">
                        @lang('Explore Products')
                    </x-theme.btn-primary>
                </div>
            </div>
        @endif
    </div>
</div>

@push('script')
<script nonce="{{ csp_nonce() }}">
function cartPage() {
    return {
        processingIdP: null,
        
        async toggleIdProtection(id) {
            this.processingIdP = id;
            try {
                const response = await fetch(`{{ route('shopping.cart.toggle-id-protection', ['id' => 'ID']) }}`.replace('ID', id), {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    }
                });
                
                const data = await response.json();
                if (data.success) {
                    window.location.reload();
                }
            } catch (error) {
                console.error('Toggle ID Protection failed:', error);
            } finally {
                this.processingIdP = null;
            }
        }
    }
}
</script>
@endpush
@endsection
