@props([
    'href' => null,
    'type' => 'submit',
    'icon' => true,
    'size' => 'md',
    'full' => false,
])

@php
    $sizeClasses = match($size) {
        'sm' => 'px-5 py-2 text-xs',
        'lg' => 'px-8 py-3.5 text-base',
        default => 'px-7 py-2.5 text-sm',
    };

    $baseClasses = "group inline-flex items-center justify-center gap-2 font-bold rounded-xl
        bg-primary-500 hover:bg-primary-600 text-white
        shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40
        transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98]
        {$sizeClasses}";

    $baseClasses .= $full ? ' w-full' : '';
@endphp

@if($href)
    <a href="{{ $href }}" {{ $attributes->merge(['class' => $baseClasses]) }}>
        {{ $slot }}
        @if($icon)
            <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
            </svg>
        @endif
    </a>
@else
    <button type="{{ $type }}" {{ $attributes->merge(['class' => $baseClasses]) }}>
        {{ $slot }}
        @if($icon)
            <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
            </svg>
        @endif
    </button>
@endif
