@props([
    'href' => null,
    'type' => 'button',
    'icon' => false,
    'size' => 'md',
    'full' => false,
])

@php
    $sizeClasses = match($size) {
        'sm' => 'px-5 py-2 text-xs',
        'lg' => 'px-8 py-3.5 text-base',
        default => 'px-7 py-2.5 text-sm',
    };

    $baseClasses = "inline-flex items-center justify-center gap-2 font-bold rounded-xl
        bg-slate-900/5 dark:bg-white/5 hover:bg-slate-900/10 dark:hover:bg-white/10
        text-slate-900 dark:text-white
        border border-slate-200 dark:border-white/10 hover:border-slate-300 dark:hover:border-white/20
        backdrop-blur-sm transition-[border-color,background-color,box-shadow,transform] duration-300
        {$sizeClasses}";

    $baseClasses .= $full ? ' w-full' : '';
@endphp

@if($href)
    <a href="{{ $href }}" {{ $attributes->merge(['class' => $baseClasses]) }}>
        {{ $slot }}
        @if($icon)
            <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
            </svg>
        @endif
    </a>
@else
    <button type="{{ $type }}" {{ $attributes->merge(['class' => $baseClasses]) }}>
        {{ $slot }}
        @if($icon)
            <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
            </svg>
        @endif
    </button>
@endif
