@props([
    'data' => [],
    'selectedCycle' => 'monthly',
    'highlightDifferences' => false,
    'showPricing' => true
])

<div class="overflow-x-auto">
    <table class="w-full text-left border-collapse">
        <thead>
            <tr class="border-b border-slate-200 dark:border-white/10">
                <th class="p-6 text-sm font-bold text-slate-500 dark:text-slate-400">@lang('Features')</th>
                @foreach($data['products'] ?? [] as $product)
                    <th class="p-6 text-sm font-black text-slate-900 dark:text-white uppercase tracking-tight">
                        {{ __($product['name']) }}
                    </th>
                @endforeach
            </tr>
        </thead>
        <tbody class="divide-y divide-slate-100 dark:divide-white/5">
            {{-- This is a temporary stub to unblock compilation --}}
            <tr class="group hover:bg-slate-50 dark:hover:bg-white/5 transition-colors">
                <td class="p-6 text-sm font-bold text-slate-600 dark:text-slate-300">@lang('Monthly Price')</td>
                @foreach($data['products'] ?? [] as $product)
                    <td class="p-6 text-sm font-black text-primary-600">
                        {{ gs('cur_sym') }}{{ $product['pricing']['cycles'][$selectedCycle]['price_raw'] ?? $product['pricing']['monthly'] ?? '0.00' }}
                    </td>
                @endforeach
            </tr>
        </tbody>
    </table>
</div>
