@props([
    'cycles' => [],
    'selected' => 'monthly',
    'style' => 'underline',
    'eventName' => 'cycle-changed'
])

@php
    // Normalize cycles to ['key' => 'label'] format for the tabs component
    $tabItems = [];
    foreach ($cycles as $cycle => $cData) {
        $tabItems[$cycle] = is_array($cData) ? ($cData['label'] ?? $cycle) : $cData;
    }
@endphp

<x-theme.ui.tabs 
    :tabs="$tabItems" 
    model="billingCycle" 
    :event="$eventName" 
    :style="$style"
    {{ $attributes }} 
/>
