@php
    $lightLogo = siteLogo();
    $darkLogo = siteLogo('dark');
    
    // Check if we have real logos or just default
    $hasRealLogo = !str_contains($lightLogo, 'default.png') || !str_contains($darkLogo, 'default.png');

    $branding = getContent('branding.content', true);
    $showIcon = @$branding->data_values->show_icon ?? 'yes';
@endphp

@if($hasRealLogo)
    {{-- Logo container with strict height constraints to prevent navbar size changes --}}
    <div class="flex items-center h-12 logo-wrapper">
        <img :src="$store.theme.on ? '{{ $darkLogo }}' : '{{ $lightLogo }}'" 
             alt="{{ gs('site_name') }}" 
             width="200" height="48"
             fetchpriority="high"
             class="max-h-12 h-auto w-auto max-w-[200px] object-contain object-left">
    </div>
@else
    {{-- Premium SVG Fallback --}}
    <div class="flex items-center gap-2 font-bold text-xl tracking-tight text-slate-900 dark:text-white">
        @if($showIcon !== 'no')
            <div class="relative flex items-center justify-center w-8 h-8 rounded-lg bg-gradient-to-br from-primary-500 to-primary-600 shadow-lg shadow-primary-500/20">
                <svg class="w-5 h-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M13 10V3L4 14h7v7l9-11h-7z" />
                </svg>
            </div>
        @endif
        <span>{{ gs('site_name') ?? 'salieno' }}</span>
    </div>
@endif