@props([
    'tabs' => [],
    'model' => 'activeTab',
    'event' => null,
    'style' => 'underline',
    'size' => 'md',
    'justify' => 'center',
])

@php
    $sizes = [
        'sm' => 'text-xs sm:text-sm',
        'md' => 'text-sm sm:text-base',
        'lg' => 'text-base sm:text-lg',
    ];
    $textSize = $sizes[$size] ?? $sizes['md'];

    $justifyMap = [
        'start'  => 'justify-start',
        'center' => 'sm:justify-center',
        'end'    => 'justify-end',
    ];
    $justifyClass = $justifyMap[$justify] ?? $justifyMap['center'];

    // Normalize tabs to ['key' => 'label'] format
    $normalizedTabs = [];
    foreach ($tabs as $key => $value) {
        if (is_array($value)) {
            $normalizedTabs[$key] = $value['label'] ?? $key;
        } elseif (is_object($value)) {
            // Support Eloquent models / stdClass with 'name' or 'label'
            $k = $value->id ?? $key;
            $normalizedTabs[$k] = $value->name ?? $value->label ?? $key;
        } else {
            $normalizedTabs[$key] = $value;
        }
    }

    // Build the @click expression
    $clickBase = "{$model} = __key__";
    if ($event) {
        $clickBase .= "; \$dispatch('{$event}', { tab: __key__ })";
    }
@endphp

@if($style === 'pills')
    {{-- ═══════════════════════════════════════════════════
         PILLS STYLE — card-like segmented control
    ═══════════════════════════════════════════════════ --}}
    <div {{ $attributes->merge(['class' => "inline-flex flex-col sm:flex-row p-1.5 bg-slate-100 dark:bg-white/5 rounded-2xl w-full sm:w-auto overflow-hidden {$justifyClass}"]) }}>
        @foreach($normalizedTabs as $key => $label)
            @php
                $isNumeric = is_numeric($key);
                $keyExpr = $isNumeric ? $key : "'{$key}'";
                $click = str_replace('__key__', $keyExpr, $clickBase);
            @endphp
            <button 
                type="button"
                @click="{{ $click }}"
                :class="{{ $model }} === {{ $keyExpr }}
                    ? 'bg-white dark:bg-slate-800 text-primary-600 shadow-lg' 
                    : 'text-slate-500 dark:text-slate-400 hover:text-slate-700 dark:hover:text-slate-200'"
                class="px-4 lg:px-8 py-3.5 rounded-xl {{ $textSize }} font-bold transition-colors duration-300 uppercase tracking-wider flex-1 sm:flex-none"
            >
                {{ __($label) }}
            </button>
        @endforeach
    </div>
@else
    {{-- ═══════════════════════════════════════════════════
         UNDERLINE STYLE — the default, matching screenshot
    ═══════════════════════════════════════════════════ --}}
    <div {{ $attributes->merge(['class' => 'relative']) }}>
        <div class="flex {{ $justifyClass }} overflow-x-auto scrollbar-hide border-b border-slate-200 dark:border-white/10">
            @foreach($normalizedTabs as $key => $label)
                @php
                    $isNumeric = is_numeric($key);
                    $keyExpr = $isNumeric ? $key : "'{$key}'";
                    $click = str_replace('__key__', $keyExpr, $clickBase);
                @endphp
                <button 
                    type="button"
                    @click="{{ $click }}"
                    :class="{{ $model }} === {{ $keyExpr }} 
                        ? 'text-primary-600 dark:text-primary-400 border-primary-500' 
                        : 'text-slate-500 dark:text-slate-400 border-transparent hover:text-slate-700 dark:hover:text-slate-200 hover:border-slate-300 dark:hover:border-white/20'"
                    class="relative flex-shrink-0 px-5 sm:px-6 py-3 {{ $textSize }} font-bold capitalize tracking-wide whitespace-nowrap border-b-2 -mb-px transition-[color,border-color] duration-300"
                >
                    {{ __($label) }}
                </button>
            @endforeach
        </div>
    </div>

    <style>
        .scrollbar-hide { -ms-overflow-style: none; scrollbar-width: none; }
        .scrollbar-hide::-webkit-scrollbar { display: none; }
    </style>
@endif
