@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    @php
        $contact = getContent('contact.content', true);
    @endphp
    <div class="relative pt-40 pb-24 bg-white dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Background --}}
        <div class="absolute inset-0 pointer-events-none">
            <div
                class="absolute inset-0 bg-[linear-gradient(var(--border)_1px,transparent_1px),linear-gradient(90deg,var(--border)_1px,transparent_1px)] bg-[size:50px_50px] opacity-10">
            </div>
            <div class="absolute top-1/4 left-1/4 w-[500px] h-[500px] bg-primary-600/10 rounded-full blur-[100px]"></div>
        </div>

        <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h1 class="text-4xl sm:text-5xl font-extrabold text-slate-900 dark:text-white mb-4 tracking-tight leading-tight">
                    {{ __(@$contact->data_values->heading ?? 'Contact Us') }}
                </h1>
                <p class="text-slate-500 dark:text-slate-400 text-lg">
                    {{ __(@$contact->data_values->subheading ?? 'Have questions? We\'d love to hear from you.') }}
                </p>
            </div>

            <div class="grid md:grid-cols-2 gap-8">
                {{-- Contact Info --}}
                <div class="space-y-6">
                    <div class="rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 backdrop-blur-sm p-6">
                        <div class="flex items-start gap-4">
                            <div
                                class="w-12 h-12 rounded-xl bg-primary-500/20 flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-primary-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-slate-900 dark:text-white font-bold mb-1">@lang('Email')</h3>
                                <p class="text-slate-500 dark:text-slate-400 text-sm">{{ @$contact->data_values->email ?? 'support@' . request()->getHost() }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 backdrop-blur-sm p-6">
                        <div class="flex items-start gap-4">
                            <div
                                class="w-12 h-12 rounded-xl bg-primary-500/20 flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-primary-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-slate-900 dark:text-white font-bold mb-1">{{ __(@$contact->data_values->chat_title ?? 'Live Chat') }}</h3>
                                <p class="text-slate-500 dark:text-slate-400 text-sm">
                                    {{ __(@$contact->data_values->chat_desc ?? 'Available 24/7 for assistance') }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Contact Form --}}
                <div class="rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 backdrop-blur-sm p-8">
                    <form action="{{ route('contact.submit') }}" method="POST" class="verify-gcaptcha space-y-5">
                        @csrf
                        <div>
                            <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Name')</label>
                            <input type="text" name="name" required
                                class="w-full px-4 h-12 bg-white dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 transition-[border-color,box-shadow]"
                                placeholder="John Doe">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Email')</label>
                            <input type="email" name="email" required
                                class="w-full px-4 h-12 bg-white dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 transition-[border-color,box-shadow]"
                                placeholder="you@example.com">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Subject')</label>
                            <input type="text" name="subject" required
                                class="w-full px-4 h-12 bg-white dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 transition-[border-color,box-shadow]"
                                placeholder="How can we help?">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">@lang('Message')</label>
                            <textarea name="message" rows="4" required
                                class="w-full px-4 py-3 bg-white dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 transition-[border-color,box-shadow] resize-none"
                                placeholder="Your message..."></textarea>
                        </div>
                        <x-theme.btn-primary type="submit" full :icon="false">
                            @lang('Send Message')
                        </x-theme.btn-primary>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection