@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative pt-40 pb-24 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Background --}}
        <div class="absolute inset-0 pointer-events-none">
            <div
                class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-30">
            </div>
        </div>

        <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="rounded-3xl bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 backdrop-blur-xl p-8 md:p-12 shadow-xl shadow-slate-200/50 dark:shadow-2xl transition-[border-color,background-color,box-shadow] duration-300">
                <h1 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-8 tracking-tight leading-tight transition-colors">@lang('Cookie Policy')</h1>

                <div class="prose dark:prose-invert prose-primary max-w-none text-slate-600 dark:text-slate-300 prose-headings:text-slate-900 dark:prose-headings:text-white prose-a:text-primary-600 dark:prose-a:text-primary-400 prose-strong:text-slate-900 dark:prose-strong:text-white transition-colors">
                    @php echo $cookie->data_values->description @endphp
                </div>
            </div>
        </div>
    </div>
@endsection