@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative pt-40 pb-24 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Background --}}
        <div class="absolute inset-0 pointer-events-none">
            <div
                class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-30">
            </div>
            <div class="absolute top-1/4 right-1/4 w-[500px] h-[500px] bg-primary-600/10 rounded-full blur-[100px]"></div>
        </div>

        <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Header --}}
            <div class="text-center mb-12">
                <h1 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-4 tracking-tight leading-tight transition-colors">@lang('Choose a Domain')</h1>
                <p class="text-slate-500 dark:text-slate-400 text-lg">
                    @lang('To perfect your hosting experience with')
                    <span class="font-bold text-primary-400">{{ $product->name ?? 'your plan' }}</span>,
                    @lang('please choose a domain name.')
                </p>
            </div>

            {{-- Tab Card --}}
            <div class="rounded-3xl bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 backdrop-blur-sm overflow-hidden shadow-xl shadow-slate-200/50 dark:shadow-none transition-[border-color,background-color,box-shadow] duration-300"
                x-data="domainConfig">
                {{-- Tab Navigation --}}
                <div class="flex border-b border-slate-200 dark:border-white/10">
                    <button @click="tab = 'register'; results = []; hasMore = false; cursor = null;"
                        :class="{ 'border-b-2 border-primary-500 text-primary-600 dark:text-primary-400 bg-primary-50 dark:bg-white/5': tab === 'register', 'text-slate-500 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white hover:bg-slate-50 dark:hover:bg-white/5': tab !== 'register' }"
                        class="flex-1 py-5 px-6 text-center font-semibold transition-colors focus:outline-none">
                        <i class="ph ph-bold ph-plus-circle mr-2"></i>@lang('Register New Domain')
                    </button>
                    <button @click="tab = 'transfer'; results = []; hasMore = false; cursor = null;"
                        :class="{ 'border-b-2 border-primary-500 text-primary-600 dark:text-primary-400 bg-primary-50 dark:bg-white/5': tab === 'transfer', 'text-slate-500 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white hover:bg-slate-50 dark:hover:bg-white/5': tab !== 'transfer' }"
                        class="flex-1 py-5 px-6 text-center font-semibold transition-colors focus:outline-none">
                        <i class="ph ph-bold ph-arrows-left-right mr-2"></i>@lang('Transfer Domain')
                    </button>
                </div>

                <div class="p-8">
                    {{-- Search Area --}}
                    <div class="space-y-6">
                        <div class="flex flex-col sm:flex-row gap-4">
                            <div class="flex-1 relative">
                                <div class="absolute inset-y-0 left-0 pl-5 flex items-center pointer-events-none">
                                    <i class="ph ph-bold ph-magnifying-glass text-slate-500 dark:text-slate-400"></i>
                                </div>
                                <input type="text" x-model="domainQuery" @keydown.enter.prevent="performSearch()"
                                    class="w-full pl-14 pr-4 h-14 bg-slate-100 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:border-primary-500/50 focus:ring-2 focus:ring-primary-500/20 transition-colors text-lg"
                                    placeholder="example.com or keyword">
                            </div>
                            <button type="button" @click="performSearch()" :disabled="loading"
                                class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] h-14 px-8 text-sm min-w-[160px] disabled:opacity-50">
                                <span x-show="!loading" x-text="tab === 'register' ? '@lang('Search')' : '@lang('Check')'"></span>
                                <span x-show="loading" class="animate-spin h-5 w-5 border-2 border-white/30 border-t-white rounded-full"></span>
                            </button>
                        </div>

                        {{-- Search Results --}}
                        <div x-show="results.length > 0" class="space-y-6 pt-4">
                            
                            {{-- Featured .com Result --}}
                            <template x-for="tld in [results.find(r => r.extension === '.com')]" :key="'featured-com'">
                                <template x-if="tld">
                                    <div class="relative overflow-hidden p-6 rounded-2xl bg-gradient-to-br from-primary-600 to-primary-800 text-white shadow-xl shadow-primary-500/20">
                                        <div class="absolute top-0 right-0 p-4 opacity-10">
                                            <i class="ph-fill ph-star text-7xl"></i>
                                        </div>
                                        <div class="relative z-10 flex flex-col sm:flex-row items-center justify-between gap-6">
                                            <div>
                                                <div class="inline-flex items-center gap-1.5 px-2 py-0.5 rounded-full bg-white/80 dark:bg-white/10 border border-white dark:border-white/20 text-[8px] font-bold uppercase tracking-widest mb-2">
                                                    <i class="ph-fill ph-crown text-orange-400"></i>
                                                    <span>Featured</span>
                                                </div>
                                                <h4 class="text-2xl font-black tracking-tight" x-text="tld.domain"></h4>
                                                <div class="flex items-center gap-2 mt-2">
                                                    <template x-if="tld.available === true">
                                                        <span class="text-[10px] font-bold text-green-400">Available</span>
                                                    </template>
                                                    <template x-if="tld.available === false">
                                                        <span class="text-[10px] font-bold text-red-200">Unavailable</span>
                                                    </template>
                                                </div>
                                            </div>
                                            
                                            <div class="flex flex-col items-end gap-3">
                                                <div class="flex items-center gap-6">
                                                    <div class="text-right">
                                                        <span class="block text-2xl font-black" x-text="tld.formatted_pricing.registration"></span>
                                                        <span class="text-[10px] font-bold uppercase opacity-70">per year</span>
                                                    </div>
                                                    <template x-if="tld.available === true || (tab === 'transfer' && tld.available === false)">
                                                        <button type="button" @click="selectDomain(tld)"
                                                                class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-white dark:bg-white/10 hover:bg-slate-100 dark:hover:bg-white/20 text-primary-950 dark:text-white shadow-lg transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] h-11 px-6 text-sm">
                                                            @lang('Continue')
                                                        </button>
                                                    </template>
                                                </div>
                                                
                                                {{-- ID Protection Toggle (Mini) --}}
                                                <template x-if="tld.pricing.id_protection > 0">
                                                    <label class="flex items-center gap-2 cursor-pointer group/idp">
                                                        <span class="text-[10px] font-bold opacity-70 group-hover/idp:opacity-100 transition-opacity">ID Protection (+<span x-text="tld.formatted_pricing.id_protection"></span>)</span>
                                                        <div class="relative inline-flex items-center h-4 w-8 rounded-full transition-colors bg-white/20"
                                                             :class="tld.id_protection ? 'bg-orange-400' : 'bg-white/20'">
                                                            <input type="checkbox" x-model="tld.id_protection" class="sr-only" @click.stop>
                                                            <span class="inline-block w-2.5 h-2.5 transform bg-white rounded-full transition-transform"
                                                                  :class="tld.id_protection ? 'translate-x-4.5' : 'translate-x-1'"></span>
                                                        </div>
                                                    </label>
                                                </template>
                                            </div>
                                        </div>
                                    </div>
                                </template>
                            </template>

                            {{-- Other Results List --}}
                            <div class="space-y-3">
                                <template x-for="res in results.filter(r => r.extension !== '.com')" :key="res.domain">
                                    <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4 p-5 rounded-2xl border bg-slate-50 dark:bg-white/5 backdrop-blur-sm transition-[border-color,background-color,opacity] duration-300"
                                         :class="res.available ? 'border-green-500/20 hover:border-green-500/40' : 'border-slate-200 dark:border-white/10'">
                                        <div class="flex items-center gap-4">
                                            <div class="w-10 h-10 rounded-xl bg-slate-100 dark:bg-white/5 flex items-center justify-center text-primary-500 dark:text-primary-400">
                                                <i class="ph ph-bold ph-globe"></i>
                                            </div>
                                            <div>
                                                <span class="text-slate-900 dark:text-white font-bold text-lg" x-text="res.domain"></span>
                                                <div class="flex items-center gap-2 mt-1">
                                                    <template x-if="res.available === true">
                                                        <span class="text-[10px] font-black uppercase tracking-widest text-green-400 bg-green-500/10 px-2 py-0.5 rounded">Available</span>
                                                    </template>
                                                    <template x-if="res.available === false">
                                                        <span class="text-[10px] font-black uppercase tracking-widest text-red-400 bg-red-500/10 px-2 py-0.5 rounded">Unavailable</span>
                                                    </template>
                                                    <template x-if="res.available === null">
                                                        <span class="text-[10px] font-black uppercase tracking-widest text-slate-500 dark:text-slate-400 animate-pulse">Checking...</span>
                                                    </template>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="flex flex-col items-end gap-2 border-t sm:border-t-0 border-slate-100 dark:border-white/5 pt-4 sm:pt-0">
                                            <div class="flex items-center justify-between sm:justify-end gap-6">
                                                <div class="text-right">
                                                    <span class="block text-xl font-extrabold text-slate-900 dark:text-white" x-text="res.formatted_pricing.registration"></span>
                                                    <span class="text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase tracking-widest">per year</span>
                                                </div>
                                                <template x-if="res.available === true || (tab === 'transfer' && res.available === false)">
                                                    <button type="button" @click="selectDomain(res)"
                                                            class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] h-11 px-6 text-sm">
                                                        @lang('Continue')
                                                    </button>
                                                </template>
                                            </div>

                                            {{-- ID Protection Toggle (Mini) --}}
                                            <template x-if="res.pricing.id_protection > 0">
                                                <label class="flex items-center gap-2 cursor-pointer group/idp">
                                                    <span class="text-[10px] font-bold text-slate-500 dark:text-slate-400 group-hover/idp:text-slate-300 transition-colors">ID Protection (+<span x-text="res.formatted_pricing.id_protection"></span>)</span>
                                                    <div class="relative inline-flex items-center h-4 w-7 rounded-full transition-colors"
                                                         :class="res.id_protection ? 'bg-primary-600' : 'bg-slate-200 dark:bg-white/10'">
                                                        <input type="checkbox" x-model="res.id_protection" class="sr-only" @click.stop>
                                                        <span class="inline-block w-2.5 h-2.5 transform bg-white rounded-full transition-transform"
                                                              :class="res.id_protection ? 'translate-x-4' : 'translate-x-0.5'"></span>
                                                    </div>
                                                </label>
                                            </template>
                                        </div>
                                    </div>
                                </template>
                            </div>
                            
                            {{-- Load More --}}
                            <div x-show="hasMore" class="pt-4 text-center">
                                <button type="button" @click="loadMore()" :disabled="loadingMore"
                                        class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-slate-100 dark:bg-white/5 hover:bg-slate-200 dark:hover:bg-white/10 text-slate-700 dark:text-white border border-slate-200 dark:border-white/10 hover:border-slate-300 dark:hover:border-white/20 transition-[background-color,border-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-7 py-2.5 text-sm mx-auto disabled:opacity-50">
                                    <span x-show="!loadingMore">@lang('Show More Extensions')</span>
                                    <span x-show="loadingMore" class="animate-spin h-4 w-4 border-2 border-primary-500/30 border-t-primary-500 rounded-full"></span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <form id="domainForm" action="{{ route('shopping.cart.add.domain') }}" method="POST" class="hidden">
                    @csrf
                    <input type="hidden" name="domain">
                    <input type="hidden" name="action">
                    <input type="hidden" name="reg_period" value="1">
                    <input type="hidden" name="id_protection">
                </form>

                <div class="bg-slate-50 dark:bg-white/5 px-8 py-4 border-t border-slate-200 dark:border-white/10">
                    <p class="text-xs text-slate-500 dark:text-slate-400 text-center">
                        @lang('By proceeding, you agree to our Terms of Service and Domain Registration Agreement.')
                    </p>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
<script nonce="{{ csp_nonce() }}">
document.addEventListener('alpine:init', () => {
    Alpine.data('domainConfig', () => ({
        tab: 'register',
        domainQuery: '',
        loading: false,
        loadingMore: false,
        results: [],
        cursor: null,
        hasMore: false,

        async performSearch() {
            if (!this.domainQuery.trim()) return;
            this.loading = true;
            this.results = [];
            this.cursor = null;
            await this.fetchResults();
            this.loading = false;
        },

        async loadMore() {
            if (!this.hasMore || this.loadingMore) return;
            this.loadingMore = true;
            await this.fetchResults();
            this.loadingMore = false;
        },

        async fetchResults() {
            try {
                const response = await fetch('/api/domains/search', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({ 
                        query: this.domainQuery,
                        cursor: this.cursor,
                        limit: 45
                    })
                });
                
                const data = await response.json();
                if (data.success) {
                    this.results = [...this.results, ...data.data.map(item => ({...item, id_protection: false}))];
                    this.cursor = data.meta.next_cursor;
                    this.hasMore = data.meta.has_more;
                }
            } catch (error) {
                console.error('Domain search failed:', error);
            }
        },

        selectDomain(res) {
            const form = document.getElementById('domainForm');
            form.querySelector('input[name="domain"]').value = res.domain;
            form.querySelector('input[name="action"]').value = this.tab;
            form.querySelector('input[name="id_protection"]').value = res.id_protection ? 1 : 0;
            form.submit();
        }
    }));
});
</script>
@endpush