@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative pt-40 pb-24 bg-slate-100 dark:bg-slate-950 min-h-screen">
        {{-- Background --}}
        <div class="absolute inset-0 pointer-events-none overflow-hidden">
            <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-100"></div>
            <div class="absolute top-1/4 left-1/4 w-[500px] h-[500px] bg-primary-600/10 rounded-full blur-[100px] animate-pulse-glow"></div>
        </div>

        <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Header --}}
            <div class="text-center mb-12">
                <h1 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-4 tracking-tight leading-tight">@lang('Register Domain')</h1>
                <p class="text-slate-600 dark:text-zinc-400 text-lg">
                    @lang('Find your new domain name. Enter your desired domain name or keyword below to check availability.')
                </p>
            </div>

            {{-- Unified Domain Search Component --}}
            <div class="max-w-3xl mx-auto">
                @livewire('store.domain-search-widget', [
                    'mode' => 'full',
                    'prefilledQuery' => $query ?? request()->domain ?? ''
                ])
            </div>
        </div>
    </div>
@endsection