@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative pt-40 pb-24 bg-slate-100 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Background --}}
        <div class="absolute inset-0 pointer-events-none">
            <div
                class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-30">
            </div>
        </div>

        <div class="relative z-10 max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <div class="mb-8">
                <div
                    class="w-32 h-32 mx-auto mb-8 rounded-3xl bg-gradient-to-br from-primary-500/20 to-orange-500/20 border border-slate-200 dark:border-white/10 flex items-center justify-center transition-colors">
                    <span
                        class="text-6xl font-black text-transparent bg-clip-text bg-gradient-to-r from-primary-400 to-orange-400">404</span>
                </div>
                <h1 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-4 tracking-tight leading-tight transition-colors">@lang('Page Not Found')</h1>
                <p class="text-slate-600 dark:text-slate-400 text-lg mb-8 transition-colors">
                    @lang('The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.')
                </p>
                <x-theme.btn-primary href="{{ route('home') }}">
                    @lang('Back to Home')
                </x-theme.btn-primary>
            </div>
        </div>
    </div>
@endsection