@extends(activeTemplate() . 'layouts.frontend')
@section('content')
    <div class="relative pt-40 pb-24 bg-slate-100 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        <div class="absolute inset-0 pointer-events-none">
            <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-30"></div>
        </div>
        <div class="relative z-10 max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <div class="mb-8">
                <div class="w-32 h-32 mx-auto mb-8 rounded-3xl bg-gradient-to-br from-blue-500/20 to-indigo-500/20 border border-slate-200 dark:border-white/10 flex items-center justify-center transition-colors">
                    <span class="text-6xl font-black text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-indigo-400">419</span>
                </div>
                <h1 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-4 tracking-tight">@lang('Session Expired')</h1>
                <p class="text-slate-600 dark:text-slate-400 text-lg mb-8">
                    @lang('Your session has expired. Please refresh the page and try again.')
                </p>
                <x-theme.btn-primary href="javascript:location.reload()">@lang('Refresh Page')</x-theme.btn-primary>
            </div>
        </div>
    </div>
@endsection
