@extends(activeTemplate() . 'layouts.frontend')

@section('content')
<div class="relative overflow-hidden pt-36 pb-32 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
    {{-- Artistic Background - Adaptive Theme --}}
    <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
        {{-- Technical Grid Pattern --}}
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-100"></div>
        
        {{-- Accent Glows --}}
        <div class="absolute top-0 right-1/4 w-[600px] h-[600px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[150px] animate-pulse-glow"></div>
        <div class="absolute bottom-1/4 left-1/4 w-[400px] h-[400px] bg-indigo-500/5 dark:bg-indigo-500/10 rounded-full blur-[130px]"></div>
    </div>

    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Header Navigation --}}
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-16">
            <nav class="flex items-center gap-3 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400 dark:text-slate-500 overflow-x-auto whitespace-nowrap pb-2 no-scrollbar">
                <a href="{{ route('kb.index') }}" class="hover:text-primary-500 transition-colors">@lang('Portal')</a>
                <i class="ph ph-bold ph-caret-right text-[10px] opacity-40"></i>
                <a href="{{ route('kb.category', $article->category->slug) }}" class="hover:text-primary-500 transition-colors">{{ __($article->category->name) }}</a>
                <i class="ph ph-bold ph-caret-right text-[10px] opacity-40"></i>
                <span class="text-slate-900 dark:text-white line-clamp-1 truncate">{{ __($article->title) }}</span>
            </nav>

            <a href="{{ route('kb.category', $article->category->slug) }}" class="inline-flex items-center gap-2 text-[10px] font-black uppercase tracking-[0.2em] text-primary-500 hover:text-slate-900 dark:hover:text-white transition-[color,transform] group">
                <i class="ph ph-bold ph-arrow-left group-hover:-translate-x-1 transition-transform"></i>
                @lang('Return to Sector')
            </a>
        </div>

        <div class="flex flex-col lg:flex-row gap-12">
            {{-- Main content --}}
            <div class="flex-1 min-w-0">
                <article class="relative p-8 md:p-12 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 backdrop-blur-xl shadow-2xl shadow-slate-900/[0.05] dark:shadow-none overflow-hidden">
                    {{-- Interior Content Decoration --}}
                    <div class="absolute -top-32 -right-32 w-64 h-64 bg-primary-500/[0.03] dark:bg-primary-500/5 rounded-full blur-3xl"></div>
                    
                    <header class="relative mb-12">
                        <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary-500/10 border border-primary-500/20 mb-8">
                            <span class="text-[10px] font-black uppercase tracking-[0.2em] text-primary-500">@lang('Technical Log')</span>
                        </div>
                        <h1 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold tracking-tight text-slate-900 dark:text-white mb-5 leading-tight">{{ __($article->title) }}</h1>
                        
                        <div class="flex flex-wrap items-center gap-6 text-slate-400 dark:text-slate-500 text-xs font-black uppercase tracking-widest">
                            <div class="flex items-center gap-2">
                                <i class="ph ph-bold ph-calendar-blank text-primary-500"></i>
                                {{ showDateTime($article->created_at, 'd M Y') }}
                            </div>
                            <div class="flex items-center gap-2">
                                <i class="ph ph-bold ph-eye text-primary-500"></i>
                                @lang('Views'): {{ $article->views }}
                            </div>
                        </div>
                    </header>

                    <div class="relative prose prose-slate dark:prose-invert max-w-none 
                        prose-headings:font-black prose-headings:tracking-tighter prose-headings:text-slate-900 dark:prose-headings:text-white
                        prose-p:text-slate-600 dark:prose-p:text-slate-500 dark:text-slate-400 prose-p:font-medium prose-p:leading-relaxed
                        prose-strong:text-primary-500 prose-strong:font-black
                        prose-code:text-primary-500 dark:prose-code:text-primary-400 prose-code:bg-slate-50 dark:prose-code:bg-white/5 prose-code:px-2 prose-code:py-0.5 prose-code:rounded-md prose-code:before:content-none prose-code:after:content-none
                        prose-pre:bg-slate-900 prose-pre:rounded-2xl prose-pre:border prose-pre:border-white/10
                        prose-li:text-slate-600 dark:prose-li:text-slate-500 dark:text-slate-400 prose-li:font-medium font-sans">
                        @php echo $article->content @endphp
                    </div>

                    {{-- Feedback System --}}
                    <div id="feedback-section" class="mt-12 pt-10 border-t border-slate-100 dark:border-white/10 text-center relative">
                        <div id="feedback-form" class="transition-colors duration-500">
                            <h4 class="text-2xl font-bold text-slate-900 dark:text-white mb-10 uppercase tracking-tighter">@lang('Was this intelligence helpful?')</h4>
                            <div class="flex justify-center items-center gap-6">
                                <button type="button" onclick="submitFeedback('helpful')" 
                                    class="group relative flex items-center gap-4 px-7 py-3.5 rounded-xl bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 hover:border-primary-500 hover:bg-primary-500 hover:text-white transition-colors duration-300 shadow-xl shadow-slate-200/20 dark:shadow-none hover:-translate-y-1">
                                    <i class="ph ph-bold ph-thumbs-up text-2xl text-primary-500 group-hover:text-white transition-colors"></i>
                                    <span class="text-xs font-black uppercase tracking-[0.2em] text-slate-600 dark:text-slate-300 group-hover:text-white">@lang('Affirmative')</span>
                                </button>
                                <button type="button" onclick="submitFeedback('not_helpful')" 
                                    class="group relative flex items-center gap-4 px-7 py-3.5 rounded-xl bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 hover:border-slate-800 dark:hover:border-slate-400 hover:bg-slate-900 dark:hover:bg-white hover:text-white dark:hover:text-slate-900 transition-colors duration-300 shadow-xl shadow-slate-200/20 dark:shadow-none hover:-translate-y-1">
                                    <i class="ph ph-bold ph-thumbs-down text-2xl text-slate-500 dark:text-slate-400 group-hover:text-white dark:group-hover:text-slate-900 transition-colors"></i>
                                    <span class="text-xs font-black uppercase tracking-[0.2em] text-slate-600 dark:text-slate-300 group-hover:text-white dark:group-hover:text-slate-900">@lang('Negative')</span>
                                </button>
                            </div>
                        </div>

                        <div id="feedback-success" class="hidden absolute inset-x-0 bottom-0 opacity-0 transform translate-y-4 transition-colors duration-500">
                            <div class="inline-flex flex-col items-center gap-4 p-8 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 shadow-2xl">
                                <div class="w-20 h-20 rounded-full bg-primary-500 shadow-lg shadow-primary-500/30 flex items-center justify-center text-white text-3xl animate-bounce">
                                    <i class="ph ph-bold ph-check"></i>
                                </div>
                                <h4 class="text-2xl font-bold text-slate-900 dark:text-white tracking-tighter">@lang('Intelligence Log Updated')</h4>
                                <p class="text-slate-500 dark:text-slate-400 text-sm font-medium">@lang('Your feedback has been decrypted and recorded. Thank you.')</p>
                            </div>
                        </div>
                    </div>
                </article>
            </div>

            {{-- Sidebar --}}
            <div class="w-full lg:w-96">
                <div class="sticky top-32 space-y-10">
                    {{-- Navigator Card --}}
                    <div class="rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 backdrop-blur-xl p-6 overflow-hidden relative shadow-2xl shadow-slate-900/[0.03] dark:shadow-2xl">
                        {{-- Top Glow --}}
                        <div class="absolute -top-12 -left-12 w-32 h-32 bg-primary-500/5 rounded-full blur-2xl"></div>
                        
                        <h3 class="relative text-xl font-medium text-slate-900 dark:text-white mb-8 flex items-center gap-3 uppercase tracking-tighter">
                            <i class="ph ph-bold ph-strategy text-primary-500"></i>
                            @lang('Sector Grid')
                        </h3>
                        <div class="relative space-y-3">
                            @foreach ($allCategories as $cat)
                                <a href="{{ route('kb.category', $cat->slug) }}" 
                                   class="flex items-center justify-between group/item px-5 py-4 rounded-2xl transition-[background-color,color,transform] font-bold tracking-tight {{ $cat->id == $article->category->id ? 'bg-primary-500 text-white shadow-lg shadow-primary-500/30' : 'bg-slate-50 dark:bg-white/5 text-slate-600 dark:text-slate-400 hover:text-primary-600 dark:hover:text-white hover:bg-slate-100 dark:hover:bg-white/10 hover:translate-x-1' }}">
                                    <span class="flex items-center gap-4 text-sm">
                                        <i class="{{ $cat->icon ?: 'ph-duotone ph-folder' }} text-xl opacity-70 group-hover/item:rotate-12 transition-transform"></i>
                                        {{ __($cat->name) }}
                                    </span>
                                    @if($cat->id == $article->category->id)
                                        <div class="w-1.5 h-1.5 rounded-full bg-white animate-pulse"></div>
                                    @endif
                                </a>
                            @endforeach
                        </div>
                    </div>

                    {{-- Support Uplink --}}
                    <div class="rounded-2xl bg-gradient-to-br from-primary-600 to-indigo-900 p-8 text-center relative overflow-hidden group shadow-2xl">
                        <div class="absolute inset-0 bg-primary-500 animate-pulse opacity-0 group-hover:opacity-10 transition-opacity"></div>
                        <div class="relative z-10">
                            <div class="w-16 h-16 mx-auto mb-6 bg-white/10 rounded-2xl flex items-center justify-center text-white backdrop-blur-md">
                                <i class="ph-duotone ph-headset text-3xl"></i>
                            </div>
                            <h4 class="text-white text-2xl font-medium mb-4 tracking-tight uppercase">@lang('Need Extra Fuel?')</h4>
                            <p class="text-white/70 text-sm font-medium mb-10">@lang('Our support astronauts are orbiting 24/7 to assist your mission.')</p>
                            <x-theme.btn-secondary href="{{ route('contact') }}" full class="bg-white text-slate-900 hover:bg-slate-100 border-0 shadow-xl h-14">
                                @lang('Open Support Uplink')
                            </x-theme.btn-secondary>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
<script nonce="{{ csp_nonce() }}">
    (function($) {
        "use strict";
        $('.feedback-btn').on('click', function() {
            let value = $(this).data('val');
            let url = "{{ route('kb.article.feedback', $article->slug) }}";
            let btn = $(this);
            
            $.ajax({
                type: "POST",
                url: url,
                data: {
                    value: value,
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('.feedback-container').fadeOut(400, function() {
                            $(this).html(`
                                <div class="bg-primary-500/10 border border-primary-500/20 rounded-[2.5rem] p-12 font-black shadow-2xl backdrop-blur-xl animate-scale-up">
                                    <div class="w-20 h-20 mx-auto mb-8 bg-primary-500 rounded-[1.5rem] flex items-center justify-center text-white text-3xl shadow-xl shadow-primary-500/40 animate-bounce">
                                        <i class="ph ph-bold ph-heart"></i>
                                    </div>
                                    <h4 class="text-3xl mb-4 tracking-tighter uppercase text-slate-900 dark:text-white">${response.message}</h4>
                                    <p class="text-slate-600 dark:text-slate-400 text-lg font-medium">@lang('Your insight has been logged in our systems. Mission accomplished.')</p>
                                </div>
                            `).fadeIn();
                        });
                    }
                }
            });
        });
    })(jQuery);
</script>
@endpush