@extends(activeTemplate() . 'layouts.frontend')

@section('content')
<div class="relative overflow-hidden pt-36 pb-32 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
    {{-- Artistic Background - Adaptive Theme --}}
    <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
        {{-- Technical Grid Pattern --}}
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-100"></div>
        
        {{-- Accent Glows --}}
        <div class="absolute top-[5%] left-1/2 -translate-x-1/2 w-[800px] h-[600px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[150px] animate-pulse-glow"></div>
        <div class="absolute bottom-1/4 right-[10%] w-[500px] h-[500px] bg-indigo-500/5 dark:bg-indigo-500/10 rounded-full blur-[130px]"></div>
    </div>

    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Header Navigation --}}
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-16">
            <nav class="flex items-center gap-3 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400 dark:text-slate-500 overflow-x-auto whitespace-nowrap pb-2 no-scrollbar">
                <a href="{{ route('kb.index') }}" class="hover:text-primary-500 transition-colors">@lang('Portal')</a>
                <i class="ph ph-bold ph-caret-right text-[10px] opacity-40"></i>
                <span class="text-slate-900 dark:text-white">{{ __($category->name) }}</span>
            </nav>

            <a href="{{ route('kb.index') }}" class="inline-flex items-center gap-2 text-[10px] font-black uppercase tracking-[0.2em] text-primary-500 hover:text-slate-900 dark:hover:text-white transition-[color,transform] group">
                <i class="ph ph-bold ph-arrow-left group-hover:-translate-x-1 transition-transform"></i>
                @lang('Return to Terminal')
            </a>
        </div>

        <div class="flex flex-col lg:flex-row gap-12">
            {{-- Main Intelligence Stream --}}
            <div class="flex-1">
                <div class="mb-20 relative">
                    <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary-500/10 border border-primary-500/20 mb-8">
                        <span class="text-[10px] font-black uppercase tracking-[0.2em] text-primary-500">@lang('Sector Records')</span>
                    </div>
                    
                    <h1 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold tracking-tight text-slate-900 dark:text-white mb-8 leading-tight">
                        {{ __($category->name) }}
                    </h1>
                    
                    <p class="text-lg text-slate-500 dark:text-slate-400 font-medium max-w-2xl leading-relaxed">
                        {{ __($category->description) ?: __('Access specialized technical documentation and orbital guides for this quadrant.') }}
                    </p>
                </div>

                <div class="space-y-6">
                    @forelse ($articles as $article)
                        <a href="{{ route('kb.article', $article->slug) }}" 
                           class="group relative flex flex-col sm:flex-row sm:items-center justify-between p-6 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 hover:border-primary-500/30 hover:bg-slate-50 dark:hover:bg-white/[0.08] transition-colors duration-500 shadow-2xl shadow-slate-900/[0.03] dark:shadow-2xl">
                            <div class="flex items-start sm:items-center gap-8">
                                <div class="w-16 h-16 shrink-0 rounded-2xl bg-slate-50 dark:bg-white/5 flex items-center justify-center text-slate-500 dark:text-slate-400 group-hover:bg-primary-500 group-hover:text-white transition-colors duration-500 shadow-inner">
                                    <i class="ph-duotone ph-file-text text-3xl"></i>
                                </div>
                                <div>
                                     <h3 class="text-xl font-medium text-slate-900 dark:text-white group-hover:text-primary-500 transition-colors mb-3 leading-tight tracking-tight">
                                        {{ __($article->title) }}
                                    </h3>
                                    <p class="text-slate-500 dark:text-slate-400 text-sm font-medium line-clamp-1 opacity-80">
                                        {{ Str::limit(strip_tags($article->content), 120) }}
                                    </p>
                                </div>
                            </div>
                            <div class="mt-6 sm:mt-0 flex items-center justify-end">
                                <div class="w-12 h-12 rounded-full border border-slate-200 dark:border-white/10 flex items-center justify-center text-slate-500 dark:text-slate-400 group-hover:bg-primary-500 group-hover:border-primary-500 group-hover:text-white group-hover:translate-x-1 transition-[background-color,border-color,color,transform]">
                                    <i class="ph ph-bold ph-arrow-right text-lg"></i>
                                </div>
                            </div>
                        </a>
                    @empty
                        <div class="text-center py-24 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 backdrop-blur-xl shadow-2xl shadow-slate-900/[0.03] dark:shadow-none">
                            <div class="w-20 h-20 mx-auto mb-10 bg-slate-50 dark:bg-white/5 rounded-2xl flex items-center justify-center text-slate-200 dark:text-slate-700">
                                <i class="ph-duotone ph-planet text-6xl"></i>
                            </div>
                            <h3 class="text-3xl font-black text-slate-900 dark:text-white mb-4 uppercase tracking-tighter">@lang('Sector Uncharted')</h3>
                            <p class="text-slate-500 dark:text-slate-400 text-lg font-medium">@lang('No intelligence logs detected in this quadrant. Initiating deep scan...')</p>
                        </div>
                    @endforelse

                    @if ($articles->hasPages())
                        <div class="mt-16 flex justify-center">
                            <div class="pagination-salieno">
                                {{ $articles->links() }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            {{-- Sidebar (Tactical Grid) --}}
            <div class="w-full lg:w-96">
                <div class="sticky top-32 space-y-10">
                    {{-- Navigator Card --}}
                    <div class="rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 backdrop-blur-xl p-6 overflow-hidden relative shadow-2xl shadow-slate-900/[0.03] dark:shadow-2xl">
                        {{-- Top Glow --}}
                        <div class="absolute -top-12 -left-12 w-32 h-32 bg-primary-500/5 rounded-full blur-2xl"></div>
                        
                        <h3 class="relative text-xl font-medium text-slate-900 dark:text-white mb-8 flex items-center gap-3 uppercase tracking-tighter">
                            <i class="ph ph-bold ph-strategy text-primary-500"></i>
                            @lang('Sector Grid')
                        </h3>
                        <div class="relative space-y-3">
                            @foreach ($allCategories as $cat)
                                <a href="{{ route('kb.category', $cat->slug) }}" 
                                   class="flex items-center justify-between group/item px-6 py-4 rounded-2xl transition-[background-color,color,transform] font-bold tracking-tight {{ $cat->id == $category->id ? 'bg-primary-500 text-white shadow-lg shadow-primary-500/30' : 'bg-slate-50 dark:bg-white/5 text-slate-600 dark:text-slate-400 hover:text-primary-500 dark:hover:text-white hover:bg-slate-100 dark:hover:bg-white/10 hover:translate-x-1' }}">
                                    <span class="flex items-center gap-4 text-sm font-sans uppercase tracking-widest text-[10px]">
                                        <i class="{{ $cat->icon ?: 'ph-duotone ph-folder' }} text-xl opacity-70"></i>
                                        {{ __($cat->name) }}
                                    </span>
                                    @if($cat->id == $category->id)
                                        <div class="w-1.5 h-1.5 rounded-full bg-white animate-pulse"></div>
                                    @endif
                                </a>
                            @endforeach
                        </div>
                    </div>

                    {{-- Request Support Uplink --}}
                    <div class="rounded-2xl bg-white dark:bg-gradient-to-br dark:from-slate-900 dark:to-indigo-950 p-8 text-center relative overflow-hidden group shadow-2xl shadow-slate-900/[0.03] dark:shadow-2xl border border-slate-100 dark:border-white/5">
                        <div class="absolute inset-0 bg-primary-500/5 dark:bg-primary-500/10 opacity-0 group-hover:opacity-100 transition-opacity duration-700"></div>
                        <div class="relative z-10">
                            <div class="w-14 h-14 mx-auto mb-6 bg-slate-50 dark:bg-white/5 rounded-2xl flex items-center justify-center text-slate-900 dark:text-white backdrop-blur-md shadow-inner">
                                <i class="ph-duotone ph-headset text-3xl"></i>
                            </div>
                            <h4 class="text-slate-900 dark:text-white text-2xl font-bold mb-4 uppercase tracking-tight">@lang('Lost in Orbit?')</h4>
                            <p class="text-slate-500 dark:text-slate-400 text-sm font-medium mb-10">@lang('Our ground team is standing by to guide your mission back on course.')</p>
                            <x-theme.btn-primary href="{{ route('contact') }}" full>
                                @lang('Call Support')
                            </x-theme.btn-primary>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
