@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative overflow-hidden pt-36 pb-32 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Artistic Background - Adaptive Theme --}}
        <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
            {{-- Technical Grid Pattern --}}
            <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-100"></div>
            
            {{-- Accent Glows --}}
            <div class="absolute top-[10%] right-[10%] w-[700px] h-[700px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[150px] animate-pulse-glow"></div>
            <div class="absolute bottom-[20%] left-[5%] w-[600px] h-[600px] bg-indigo-500/5 dark:bg-indigo-500/10 rounded-full blur-[130px]"></div>
            
            {{-- Particle Stars (Dark Mode Only) --}}
            <div class="absolute inset-0 hidden dark:block">
                @for ($i = 0; $i < 50; $i++)
                    <div class="absolute rounded-full bg-white opacity-20 animate-pulse"
                        style="top: {{ rand(0, 100) }}%; left: {{ rand(0, 100) }}%; width: {{ rand(1, 2) }}px; height: {{ rand(1, 2) }}px; animation-duration: {{ rand(3, 8) }}s;">
                    </div>
                @endfor
            </div>
        </div>

        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Search & Hero Section --}}
            <div class="max-w-4xl mx-auto text-center mb-16">
                <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary-500/10 border border-primary-500/20 mb-10">
                    <span class="text-[10px] font-black uppercase tracking-[0.2em] text-primary-500">@lang('Support Intelligence')</span>
                </div>
                
                <h1 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold tracking-tight text-slate-900 dark:text-white mb-5 leading-tight">
                    @lang('Intelligence Portal')
                </h1>
                
                <p class="text-lg md:text-xl text-slate-500 dark:text-slate-400 font-medium mb-12 max-w-2xl mx-auto leading-relaxed">
                    @lang('Access our technical documentation and orbital logs to optimize your mission.')
                </p>
                
                <div class="relative group max-w-2xl mx-auto">
                    {{-- Refined Galactic Search --}}
                    <div class="absolute inset-y-0 left-0 pl-7 flex items-center pointer-events-none">
                        <i class="ph ph-bold ph-magnifying-glass text-2xl text-slate-500 dark:text-slate-400 group-focus-within:text-primary-500 transition-colors"></i>
                    </div>
                    
                    <input type="text" id="kbSearchInput" placeholder="@lang('Search knowledge logs')..."
                        class="w-full h-14 pl-18 pr-12 bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:ring-4 focus:ring-primary-500/10 focus:border-primary-500/50 backdrop-blur transition-[border-color,box-shadow] font-medium text-base shadow-2xl shadow-slate-900/[0.05] dark:shadow-none">
                    
                    <div id="searchLoader" class="absolute right-7 top-1/2 -translate-y-1/2 hidden">
                        <i class="ph ph-bold ph-circle-notch animate-spin text-2xl text-primary-500"></i>
                    </div>
                </div>
            </div>

            {{-- Dynamic Search Results Area --}}
            <div id="searchResults" class="hidden mb-28">
                <div class="flex items-center justify-between gap-5 mb-12">
                    <div class="flex items-center gap-5">
                        <div class="h-10 w-1.5 bg-primary-500 rounded-full"></div>
                        <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">@lang('Found Intelligence')</h2>
                    </div>
                    <button type="button" id="clearSearch" class="text-[10px] font-black uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400 hover:text-primary-500 transition-colors">@lang('Reset Search')</button>
                </div>
                <div id="resultsContent"></div>
            </div>

            <div id="mainKbContent">
                {{-- Categories Intelligence Grid --}}
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
                    @foreach ($categories as $category)
                        <div class="group relative p-8 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/5 hover:border-primary-500/30 transition-[border-color,transform,box-shadow] duration-700 shadow-2xl shadow-slate-900/[0.03] dark:shadow-2xl overflow-hidden hover:-translate-y-2 ">
                            {{-- Hover Interior Glow --}}
                            <div class="absolute -right-20 -bottom-20 w-64 h-64 bg-primary-500/5 rounded-full blur-[100px] group-hover:bg-primary-500/10 transition-colors"></div>

                            <div class="relative">
                                <div class="w-14 h-14 rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/10 flex items-center justify-center text-primary-500 mb-8 group-hover:scale-110 group-hover:bg-primary-500 group-hover:text-white group-hover:shadow-xl group-hover:shadow-primary-500/20 transition-colors duration-500 shadow-inner">
                                    <i class="{{ $category->icon ?: 'ph-duotone ph-folder' }} text-4xl"></i>
                                </div>

                                <h3 class="text-3xl font-medium text-slate-900 dark:text-white mb-6 group-hover:text-primary-500 transition-colors leading-tight tracking-tighter">
                                    <a href="{{ route('kb.category', $category->slug) }}">{{ __($category->name) }}</a>
                                </h3>

                                <p class="text-slate-500 dark:text-slate-400 mb-10 line-clamp-2 font-medium leading-relaxed text-sm">
                                    {{ __($category->description) }}
                                </p>

                                <a href="{{ route('kb.category', $category->slug) }}"
                                    class="inline-flex items-center gap-3 text-primary-500 font-black uppercase text-[10px] tracking-[0.2em] hover:text-white transition-colors group/link px-6 py-2 rounded-full border border-primary-500/20 hover:bg-primary-500/20">
                                    @lang('Enter Sector')
                                    <i class="ph ph-bold ph-arrow-right group-hover/link:translate-x-1 transition-transform"></i>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>

                {{-- Popular Resources --}}
                @if ($popularArticles->count() > 0)
                    <div class="pt-24 border-t border-slate-200 dark:border-white/10">
                        <div class="flex items-center gap-5 mb-16">
                            <div class="h-12 w-2 bg-primary-500 rounded-full shadow-lg shadow-primary-500/40"></div>
                            <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">@lang('High-Priority Logs')</h2>
                        </div>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            @foreach ($popularArticles as $article)
                                <a href="{{ route('kb.article', $article->slug) }}"
                                    class="flex items-center gap-6 p-6 rounded-2xl bg-white dark:bg-white/[0.03] border border-slate-100 dark:border-white/10 hover:border-primary-500/30 hover:bg-slate-50 dark:hover:bg-white/[0.08] transition-colors duration-500 group shadow-lg shadow-slate-900/[0.02] dark:shadow-none">
                                    <div class="w-14 h-14 rounded-2xl bg-slate-50 dark:bg-white/5 flex items-center justify-center text-slate-500 dark:text-slate-400 group-hover:bg-primary-500 group-hover:text-white transition-colors duration-500 shadow-inner">
                                        <i class="ph-duotone ph-article text-3xl"></i>
                                    </div>
                                    <span class="text-slate-700 dark:text-slate-300 font-medium group-hover:text-slate-900 dark:group-hover:text-white transition-colors text-lg tracking-tight">{{ __($article->title) }}</span>
                                </a>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('script')
<script nonce="{{ csp_nonce() }}">
    (function($) {
        "use strict";
        let searchTimer;
        const searchInput = $('#kbSearchInput');
        const searchResults = $('#searchResults');
        const resultsContent = $('#resultsContent');
        const mainKbContent = $('#mainKbContent');
        const loader = $('#searchLoader');

        searchInput.on('input', function() {
            clearTimeout(searchTimer);
            const query = $(this).val();

            if (query.length < 2) {
                searchResults.addClass('hidden');
                mainKbContent.removeClass('hidden');
                return;
            }

            searchTimer = setTimeout(() => {
                executeSearch(query);
            }, 300);
        });

        $('#clearSearch').on('click', function() {
            searchInput.val('').trigger('input');
        });

        function executeSearch(query) {
            loader.removeClass('hidden');
            $.ajax({
                url: "{{ route('kb.search.ajax') }}",
                type: "GET",
                data: { q: query },
                success: function(response) {
                    resultsContent.html(response.html);
                    searchResults.removeClass('hidden');
                    mainKbContent.addClass('hidden');
                    loader.addClass('hidden');
                },
                error: function() {
                    loader.addClass('hidden');
                }
            });
        }
    })(jQuery);
</script>
@endpush