@forelse ($results as $article)
    <a href="{{ route('kb.article', $article->slug) }}"
        class="group relative flex flex-col sm:flex-row sm:items-center justify-between p-6 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/5 hover:border-primary-500/30 hover:bg-white dark:hover:bg-white/10 transition-[border-color,background-color,color] duration-500 shadow-xl shadow-slate-200/40 dark:shadow-none mb-4 last:mb-0">
        <div class="flex items-start sm:items-center gap-6">
            <div class="w-14 h-14 shrink-0 rounded-2xl bg-slate-50 dark:bg-white/5 flex items-center justify-center text-slate-500 dark:text-slate-400 group-hover:bg-primary-500 group-hover:text-white transition-[border-color,background-color,color] duration-500 shadow-inner">
                <i class="ph-duotone ph-article text-3xl"></i>
            </div>
            <div>
                <h3 class="text-xl font-medium text-slate-900 dark:text-white group-hover:text-primary-500 transition-colors mb-2 leading-tight italic tracking-tight">
                    {{ __($article->title) }}
                </h3>
                <p class="text-slate-500 dark:text-slate-400 text-sm font-medium line-clamp-1 italic opacity-80">
                    {{ Str::limit(strip_tags($article->content), 120) }}
                </p>
            </div>
        </div>
        <div class="mt-4 sm:mt-0 flex items-center justify-end">
            <div class="w-10 h-10 rounded-full border border-slate-200 dark:border-white/10 flex items-center justify-center text-slate-500 dark:text-slate-400 group-hover:bg-primary-500 group-hover:border-primary-500 group-hover:text-white group-hover:translate-x-1 transition-[border-color,background-color,color]">
                <i class="ph ph-bold ph-arrow-right text-sm"></i>
            </div>
        </div>
    </a>
@empty
    <div class="text-center py-12 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/5">
        <div class="w-20 h-20 mx-auto mb-6 bg-slate-50 dark:bg-slate-900 rounded-full flex items-center justify-center text-slate-300 dark:text-slate-700">
            <i class="ph ph-bold ph-magnifying-glass text-4xl"></i>
        </div>
        <h4 class="text-xl font-black text-slate-900 dark:text-white mb-2 italic">@lang('No intelligence logs found')</h4>
        <p class="text-slate-500 dark:text-slate-400 font-medium italic">@lang('Try searching for different keywords or sectors.')</p>
    </div>
@endforelse
