@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative overflow-hidden pt-36 pb-32 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Artistic Background - Adaptive Theme --}}
        <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
            {{-- Technical Grid Pattern --}}
            <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-100"></div>
            
            {{-- Accent Glows --}}
            <div class="absolute top-[10%] left-1/4 w-[600px] h-[600px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[150px] animate-pulse-glow"></div>
            <div class="absolute bottom-[10%] right-1/4 w-[700px] h-[700px] bg-indigo-500/5 dark:bg-indigo-500/10 rounded-full blur-[130px]"></div>
        </div>

        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Header Navigation --}}
            <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-16">
                <nav class="flex items-center gap-3 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400 dark:text-slate-500 overflow-x-auto whitespace-nowrap pb-2 no-scrollbar">
                    <a href="{{ route('kb.index') }}" class="hover:text-primary-500 transition-colors">@lang('Portal')</a>
                    <i class="ph ph-bold ph-caret-right text-[10px] opacity-40"></i>
                    <span class="text-slate-900 dark:text-white">@lang('Intelligence Analysis')</span>
                </nav>

                <a href="{{ route('kb.index') }}" class="inline-flex items-center gap-2 text-[10px] font-black uppercase tracking-[0.2em] text-primary-500 hover:text-slate-900 dark:hover:text-white transition-[color,transform] group">
                    <i class="ph ph-bold ph-arrow-left group-hover:-translate-x-1 transition-transform"></i>
                    @lang('Reset Terminal')
                </a>
            </div>

            <div class="mb-20">
                <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary-500/10 border border-primary-500/20 mb-8">
                    <span class="text-[10px] font-black uppercase tracking-[0.2em] text-primary-500">@lang('Scan Results')</span>
                </div>
                
                <h1 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold tracking-tight text-slate-900 dark:text-white mb-6 leading-tight">
                    @lang('Matches for') "<span class="text-primary-500 underline decoration-primary-500/30">{{ $search }}</span>"
                </h1>
                
                <p class="text-slate-500 dark:text-slate-400 text-xl font-medium italic leading-relaxed">
                    @lang('Correlated') <span class="text-slate-900 dark:text-white font-black">{{ $articles->total() }}</span> @lang('intelligence logs matching your query.')
                </p>
            </div>

            <div class="space-y-6">
                @forelse ($articles as $article)
                    <a href="{{ route('kb.article', $article->slug) }}"
                        class="group relative flex flex-col sm:flex-row sm:items-center justify-between p-6 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 hover:border-primary-500/30 hover:bg-slate-50 dark:hover:bg-white/[0.08] transition-colors duration-500 shadow-xl shadow-slate-200/30 dark:shadow-2xl">
                        <div class="flex items-start sm:items-center gap-8">
                            <div class="w-16 h-16 shrink-0 rounded-2xl bg-slate-50 dark:bg-white/5 flex items-center justify-center text-slate-500 dark:text-slate-400 group-hover:bg-primary-500 group-hover:text-white transition-colors duration-500 shadow-inner">
                                <i class="ph-duotone ph-article text-3xl"></i>
                            </div>
                            <div>
                                <h3 class="text-xl font-black text-slate-900 dark:text-white group-hover:text-primary-500 transition-colors mb-3 leading-tight italic tracking-tight">
                                    {{ __($article->title) }}
                                </h3>
                                <p class="text-slate-500 dark:text-slate-400 text-sm font-medium line-clamp-1 italic opacity-80">
                                    {{ Str::limit(strip_tags($article->content), 120) }}
                                </p>
                            </div>
                        </div>
                        <div class="mt-6 sm:mt-0 flex items-center justify-end">
                            <div class="w-12 h-12 rounded-full border border-slate-200 dark:border-white/10 flex items-center justify-center text-slate-500 dark:text-slate-400 group-hover:bg-primary-500 group-hover:border-primary-500 group-hover:text-white group-hover:translate-x-1 transition-[background-color,border-color,color,transform]">
                                <i class="ph ph-bold ph-arrow-right text-lg"></i>
                            </div>
                        </div>
                    </a>
                @empty
                    <div class="text-center py-24 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 backdrop-blur-xl shadow-xl shadow-slate-200/30 dark:shadow-none">
                        <div class="w-20 h-20 mx-auto mb-10 bg-slate-50 dark:bg-white/5 rounded-2xl flex items-center justify-center text-slate-200 dark:text-slate-700">
                            <i class="ph ph-bold ph-magnifying-glass text-6xl"></i>
                        </div>
                        <h3 class="text-3xl font-black text-slate-900 dark:text-white mb-4 italic uppercase tracking-tighter">@lang('Sector Null')</h3>
                        <p class="text-slate-500 dark:text-slate-400 text-lg font-medium italic mb-12">@lang('No intelligence logs were found in the scanned quadrant.')</p>
                        
                        <a href="{{ route('kb.index') }}"
                            class="inline-flex items-center gap-3 text-white font-black uppercase text-[10px] tracking-[0.2em] bg-primary-500 px-7 py-3 rounded-xl shadow-xl shadow-primary-500/20 hover:bg-primary-600 transition-[background-color,border-color,color,transform] hover:-translate-y-1">
                            <i class="ph ph-bold ph-arrow-left"></i>
                            @lang('Return to Terminal')
                        </a>
                    </div>
                @endforelse

                @if ($articles->hasPages())
                    <div class="mt-16 flex justify-center">
                        <div class="pagination-salieno">
                            {{ $articles->appends(['q' => $search])->links() }}
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection